/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives.adapters;

import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections.primitives.ByteCollection;
import org.apache.commons.collections.primitives.ByteIterator;
import org.apache.commons.collections.primitives.ByteList;
import org.apache.commons.collections.primitives.ByteListIterator;
import org.apache.commons.collections.primitives.adapters.AbstractCollectionByteCollection;
import org.apache.commons.collections.primitives.adapters.ByteCollectionCollection;
import org.apache.commons.collections.primitives.adapters.ListByteList;
import org.apache.commons.collections.primitives.adapters.ListIteratorByteListIterator;

abstract class AbstractListByteList
extends AbstractCollectionByteCollection
implements ByteList {
    AbstractListByteList() {
    }

    @Override
    @Nonnull
    protected final Collection<Byte> getCollection() {
        return this.getList();
    }

    @Nonnull
    protected abstract List<Byte> getList();

    @Override
    public void add(int n, byte by) {
        this.getList().add(n, by);
    }

    @Override
    public boolean addAll(int n, @Nonnull ByteCollection byteCollection) {
        return this.getList().addAll(n, ByteCollectionCollection.wrap(byteCollection));
    }

    @Override
    public byte get(int n) {
        return this.getList().get(n);
    }

    @Override
    public int indexOf(byte by) {
        return this.getList().indexOf(by);
    }

    @Override
    public int lastIndexOf(byte by) {
        return this.getList().lastIndexOf(by);
    }

    @Override
    @Nonnull
    public ByteListIterator listIterator() {
        return ListIteratorByteListIterator.wrap(this.getList().listIterator());
    }

    @Override
    @Nonnull
    public ByteListIterator listIterator(int n) {
        return ListIteratorByteListIterator.wrap(this.getList().listIterator(n));
    }

    @Override
    public byte removeElementAt(int n) {
        return this.getList().remove(n);
    }

    @Override
    public byte set(int n, byte by) {
        return this.getList().set(n, by);
    }

    @Override
    @Nonnull
    public ByteList subList(int n, int n2) {
        return ListByteList.wrap(this.getList().subList(n, n2));
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ByteList)) {
            return false;
        }
        ByteList byteList = (ByteList)object;
        if (this.size() != byteList.size()) {
            return false;
        }
        ByteIterator byteIterator = this.iterator();
        ByteIterator byteIterator2 = byteList.iterator();
        while (byteIterator.hasNext()) {
            if (byteIterator.next() == byteIterator2.next()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return ((Object)this.getList()).hashCode();
    }
}

