/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives.adapters.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections.primitives.ByteIterator;

public class InputStreamByteIterator
implements ByteIterator {
    private final InputStream m_aStream;
    private boolean m_bNextAvailable = false;
    private int m_nNext;

    public InputStreamByteIterator(@Nonnull InputStream inputStream) {
        this.m_aStream = inputStream;
    }

    @Override
    public boolean hasNext() {
        this._ensureNextAvailable();
        return -1 != this.m_nNext;
    }

    @Override
    public byte next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No next element");
        }
        this.m_bNextAvailable = false;
        return (byte)this.m_nNext;
    }

    @Override
    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("remove() is not supported here");
    }

    private void _ensureNextAvailable() {
        if (!this.m_bNextAvailable) {
            this._readNext();
        }
    }

    private void _readNext() {
        try {
            this.m_nNext = this.m_aStream.read();
            this.m_bNextAvailable = true;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    @Nullable
    public static ByteIterator adapt(@Nullable InputStream inputStream) {
        return null == inputStream ? null : new InputStreamByteIterator(inputStream);
    }
}

