/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.publisher.impl.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.runtime.api.Framework;

public class DomainsFinder
extends UnrestrictedSessionRunner {
    private static final Log log = LogFactory.getLog(DomainsFinder.class);
    public static final String PUBLISHING_DOMAINS_PROVIDER = "domains_for_publishing";
    protected List<DocumentModel> domains;

    public DomainsFinder(String repositoryName) {
        super(repositoryName);
    }

    public void run() throws ClientException {
        this.domains = this.getDomainsFiltered();
    }

    protected List<DocumentModel> getDomainsFiltered() throws ClientException {
        PageProviderService pps;
        try {
            pps = (PageProviderService)Framework.getService(PageProviderService.class);
        }
        catch (Exception e) {
            log.error((Object)"Failed to get PageProviderService", (Throwable)e);
            return new ArrayList<DocumentModel>();
        }
        HashMap<String, Serializable> props = new HashMap<String, Serializable>();
        props.put("coreSession", (Serializable)this.session);
        PageProvider pageProvider = pps.getPageProvider(PUBLISHING_DOMAINS_PROVIDER, null, null, null, props, new Object[]{this.session.getRootDocument().getId()});
        return pageProvider.getCurrentPage();
    }

    public List<DocumentModel> getDomains() throws ClientException {
        if (this.domains == null) {
            this.runUnrestricted();
        }
        return this.domains;
    }
}

