/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.publisher.impl.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.platform.publisher.api.PublicationNode;
import org.nuxeo.ecm.platform.publisher.api.PublicationTree;
import org.nuxeo.ecm.platform.publisher.api.PublicationTreeNotAvailable;
import org.nuxeo.ecm.platform.publisher.api.PublishedDocument;
import org.nuxeo.ecm.platform.publisher.api.PublishedDocumentFactory;
import org.nuxeo.ecm.platform.publisher.api.PublisherException;
import org.nuxeo.ecm.platform.publisher.api.PublisherService;
import org.nuxeo.ecm.platform.publisher.api.RemotePublicationTreeManager;
import org.nuxeo.ecm.platform.publisher.descriptors.PublicationTreeConfigDescriptor;
import org.nuxeo.ecm.platform.publisher.descriptors.PublicationTreeDescriptor;
import org.nuxeo.ecm.platform.publisher.descriptors.PublishedDocumentFactoryDescriptor;
import org.nuxeo.ecm.platform.publisher.descriptors.RootSectionFinderFactoryDescriptor;
import org.nuxeo.ecm.platform.publisher.helper.PublicationRelationHelper;
import org.nuxeo.ecm.platform.publisher.helper.RootSectionFinder;
import org.nuxeo.ecm.platform.publisher.helper.RootSectionFinderFactory;
import org.nuxeo.ecm.platform.publisher.impl.finder.DefaultRootSectionsFinder;
import org.nuxeo.ecm.platform.publisher.impl.service.DomainsFinder;
import org.nuxeo.ecm.platform.publisher.impl.service.ProxyNode;
import org.nuxeo.ecm.platform.publisher.impl.service.ProxyTree;
import org.nuxeo.ecm.platform.publisher.rules.ValidatorsRule;
import org.nuxeo.ecm.platform.publisher.rules.ValidatorsRuleDescriptor;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class PublisherServiceImpl
extends DefaultComponent
implements PublisherService,
RemotePublicationTreeManager {
    private final Log log = LogFactory.getLog(PublisherServiceImpl.class);
    protected Map<String, PublicationTreeDescriptor> treeDescriptors = new HashMap<String, PublicationTreeDescriptor>();
    protected Map<String, PublishedDocumentFactoryDescriptor> factoryDescriptors = new HashMap<String, PublishedDocumentFactoryDescriptor>();
    protected Map<String, PublicationTreeConfigDescriptor> treeConfigDescriptors = new HashMap<String, PublicationTreeConfigDescriptor>();
    protected Map<String, ValidatorsRuleDescriptor> validatorsRuleDescriptors = new HashMap<String, ValidatorsRuleDescriptor>();
    protected Map<String, PublicationTreeConfigDescriptor> pendingDescriptors = new HashMap<String, PublicationTreeConfigDescriptor>();
    protected Map<String, PublicationTree> liveTrees = new HashMap<String, PublicationTree>();
    protected RootSectionFinderFactory rootSectionFinderFactory = null;
    protected Map<String, String> remoteLiveTrees = new HashMap<String, String>();
    public static final String TREE_EP = "tree";
    public static final String TREE_CONFIG_EP = "treeInstance";
    public static final String VALIDATORS_RULE_EP = "validatorsRule";
    public static final String FACTORY_EP = "factory";
    public static final String ROOT_SECTION_FINDER_FACTORY_EP = "rootSectionFinderFactory";
    protected static final String ROOT_PATH_KEY = "RootPath";
    protected static final String RELATIVE_ROOT_PATH_KEY = "RelativeRootPath";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applicationStarted(ComponentContext context) throws Exception {
        if (TransactionHelper.startTransaction()) {
            try {
                this.doApplicationStarted();
            }
            catch (Throwable e) {
                TransactionHelper.setTransactionRollbackOnly();
            }
            finally {
                TransactionHelper.commitOrRollbackTransaction();
            }
        } else {
            this.doApplicationStarted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doApplicationStarted() {
        ClassLoader jbossCL = Thread.currentThread().getContextClassLoader();
        ClassLoader nuxeoCL = PublisherServiceImpl.class.getClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(nuxeoCL);
            this.log.info((Object)"Publisher Service initialization");
            this.registerPendingDescriptors();
        }
        catch (Exception e) {
            this.log.error((Object)"Unable to register pending descriptors", (Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(jbossCL);
            this.log.debug((Object)"JBoss ClassLoader restored");
        }
    }

    public void activate(ComponentContext context) throws Exception {
        this.liveTrees = new HashMap<String, PublicationTree>();
        this.treeDescriptors = new HashMap<String, PublicationTreeDescriptor>();
        this.factoryDescriptors = new HashMap<String, PublishedDocumentFactoryDescriptor>();
        this.treeConfigDescriptors = new HashMap<String, PublicationTreeConfigDescriptor>();
        this.validatorsRuleDescriptors = new HashMap<String, ValidatorsRuleDescriptor>();
        this.pendingDescriptors = new HashMap<String, PublicationTreeConfigDescriptor>();
    }

    public int getLiveTreeCount() {
        return this.liveTrees.size();
    }

    public PublicationTree getTreeBySid(String sid) {
        return this.liveTrees.get(sid);
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        this.log.debug((Object)("Registry contribution for EP " + extensionPoint));
        if (TREE_EP.equals(extensionPoint)) {
            PublicationTreeDescriptor desc = (PublicationTreeDescriptor)contribution;
            this.treeDescriptors.put(desc.getName(), desc);
        } else if (TREE_CONFIG_EP.equals(extensionPoint)) {
            PublicationTreeConfigDescriptor desc = (PublicationTreeConfigDescriptor)contribution;
            this.registerTreeConfig(desc);
        } else if (FACTORY_EP.equals(extensionPoint)) {
            PublishedDocumentFactoryDescriptor desc = (PublishedDocumentFactoryDescriptor)contribution;
            this.factoryDescriptors.put(desc.getName(), desc);
        } else if (VALIDATORS_RULE_EP.equals(extensionPoint)) {
            ValidatorsRuleDescriptor desc = (ValidatorsRuleDescriptor)contribution;
            this.validatorsRuleDescriptors.put(desc.getName(), desc);
        } else if (ROOT_SECTION_FINDER_FACTORY_EP.equals(extensionPoint)) {
            RootSectionFinderFactoryDescriptor desc = (RootSectionFinderFactoryDescriptor)contribution;
            try {
                this.rootSectionFinderFactory = desc.getFactory().newInstance();
            }
            catch (Throwable t) {
                this.log.error((Object)"Unable to load custom RootSectionFinderFactory", t);
            }
        }
    }

    protected void registerTreeConfig(PublicationTreeConfigDescriptor desc) {
        if (desc.getParameters().get(RELATIVE_ROOT_PATH_KEY) != null) {
            this.pendingDescriptors.put(desc.getName(), desc);
        } else {
            this.treeConfigDescriptors.put(desc.getName(), desc);
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (contribution instanceof PublicationTreeDescriptor) {
            this.treeDescriptors.remove(((PublicationTreeDescriptor)contribution).getName());
        } else if (contribution instanceof PublicationTreeConfigDescriptor) {
            String name = ((PublicationTreeConfigDescriptor)contribution).getName();
            this.pendingDescriptors.remove(name);
            this.treeConfigDescriptors.remove(name);
        } else if (contribution instanceof ValidatorsRuleDescriptor) {
            this.validatorsRuleDescriptors.remove(((ValidatorsRuleDescriptor)contribution).getName());
        } else if (contribution instanceof RootSectionFinderFactoryDescriptor) {
            this.rootSectionFinderFactory = null;
        }
    }

    protected String computeTreeSessionId(String treeConfigName, CoreSession coreSession) {
        return this.computeTreeSessionId(treeConfigName, coreSession.getSessionId());
    }

    protected String computeTreeSessionId(String treeConfigName, String sid) {
        return treeConfigName + sid;
    }

    public List<String> getAvailablePublicationTree() {
        ArrayList<String> treeConfigs = new ArrayList<String>();
        treeConfigs.addAll(this.treeConfigDescriptors.keySet());
        return treeConfigs;
    }

    public Map<String, String> getAvailablePublicationTrees() {
        HashMap<String, String> trees = new HashMap<String, String>();
        for (PublicationTreeConfigDescriptor desc : this.treeConfigDescriptors.values()) {
            String title = desc.getTitle() == null ? desc.getName() : desc.getTitle();
            trees.put(desc.getName(), title);
        }
        return trees;
    }

    public PublicationTree getPublicationTree(String treeName, CoreSession coreSession, Map<String, String> params) throws ClientException, PublicationTreeNotAvailable {
        return this.getPublicationTree(treeName, coreSession, params, null);
    }

    public PublicationTree getPublicationTree(String treeName, CoreSession coreSession, Map<String, String> params, DocumentModel currentDocument) throws ClientException, PublicationTreeNotAvailable {
        PublicationTree tree = this.getOrBuildTree(treeName, coreSession, params);
        if (tree == null) {
            return null;
        }
        if (currentDocument != null) {
            tree.setCurrentDocument(currentDocument);
        }
        return new ProxyTree(tree, tree.getSessionId());
    }

    public Map<String, String> initRemoteSession(String treeConfigName, Map<String, String> params) throws Exception {
        CoreSession coreSession = CoreInstance.openCoreSession(null);
        PublicationTree tree = this.getPublicationTree(treeConfigName, coreSession, params);
        this.remoteLiveTrees.put(tree.getSessionId(), coreSession.getSessionId());
        HashMap<String, String> res = new HashMap<String, String>();
        res.put("sessionId", tree.getSessionId());
        res.put("title", tree.getTitle());
        res.put("nodeType", tree.getNodeType());
        res.put("treeName", tree.getConfigName());
        res.put("path", tree.getPath());
        return res;
    }

    public void release(String sid) {
        if (this.liveTrees.containsKey(sid)) {
            PublicationTree tree = this.liveTrees.get(sid);
            tree.release();
            this.liveTrees.remove(sid);
        }
        if (this.remoteLiveTrees.containsKey(sid)) {
            String sessionId = this.remoteLiveTrees.get(sid);
            CoreSession remoteSession = CoreInstance.getInstance().getSession(sessionId);
            remoteSession.close();
            this.remoteLiveTrees.remove(sid);
        }
    }

    public void releaseAllTrees(String sessionId) {
        for (String configName : this.treeConfigDescriptors.keySet()) {
            String treeid = this.computeTreeSessionId(configName, sessionId);
            this.release(treeid);
        }
    }

    protected PublicationTree getOrBuildTree(String treeConfigName, CoreSession coreSession, Map<String, String> params) throws PublicationTreeNotAvailable {
        PublicationTree tree;
        String key = this.computeTreeSessionId(treeConfigName, coreSession);
        if (this.liveTrees.containsKey(key)) {
            tree = this.liveTrees.get(key);
        } else {
            tree = this.buildTree(key, treeConfigName, coreSession, params);
            if (tree != null) {
                this.liveTrees.put(key, tree);
            }
        }
        return tree;
    }

    protected PublicationTree buildTree(String sid, String treeConfigName, CoreSession coreSession, Map<String, String> params) throws PublicationTreeNotAvailable {
        try {
            PublicationTreeConfigDescriptor config = this.getPublicationTreeConfigDescriptor(treeConfigName);
            Map<String, String> allParameters = this.computeAllParameters(config, params);
            PublicationTreeDescriptor treeDescriptor = this.getPublicationTreeDescriptor(config);
            PublishedDocumentFactory publishedDocumentFactory = this.getPublishedDocumentFactory(config, treeDescriptor, coreSession, allParameters);
            return this.getPublicationTree(treeDescriptor, sid, coreSession, allParameters, publishedDocumentFactory, config.getName(), config.getTitle());
        }
        catch (PublisherException e) {
            this.log.error((Object)"Unable to build PublicationTree", (Throwable)e);
            return null;
        }
    }

    protected Map<String, String> computeAllParameters(PublicationTreeConfigDescriptor config, Map<String, String> params) {
        Map<String, String> allParameters = config.getParameters();
        if (params != null) {
            allParameters.putAll(params);
        }
        return allParameters;
    }

    protected PublishedDocumentFactory getPublishedDocumentFactory(PublicationTreeConfigDescriptor config, PublicationTreeDescriptor treeDescriptor, CoreSession coreSession, Map<String, String> params) throws PublisherException {
        PublishedDocumentFactory factory;
        PublishedDocumentFactoryDescriptor factoryDesc = this.getPublishedDocumentFactoryDescriptor(config, treeDescriptor);
        ValidatorsRule validatorsRule = this.getValidatorsRule(factoryDesc);
        try {
            factory = factoryDesc.getKlass().newInstance();
        }
        catch (Exception e) {
            throw new PublisherException("Error while creating factory " + factoryDesc.getName(), (Throwable)e);
        }
        try {
            factory.init(coreSession, validatorsRule, params);
        }
        catch (Exception e) {
            throw new PublisherException("Error during Factory init", (Throwable)e);
        }
        return factory;
    }

    protected ValidatorsRule getValidatorsRule(PublishedDocumentFactoryDescriptor factoryDesc) throws PublisherException {
        String validatorsRuleName = factoryDesc.getValidatorsRuleName();
        ValidatorsRule validatorsRule = null;
        if (validatorsRuleName != null) {
            ValidatorsRuleDescriptor validatorsRuleDesc = this.validatorsRuleDescriptors.get(validatorsRuleName);
            if (validatorsRuleDesc == null) {
                throw new PublisherException("Unable to find validatorsRule" + validatorsRuleName);
            }
            try {
                validatorsRule = validatorsRuleDesc.getKlass().newInstance();
            }
            catch (Exception e) {
                throw new PublisherException("Error while creating validatorsRule " + validatorsRuleName, (Throwable)e);
            }
        }
        return validatorsRule;
    }

    protected PublishedDocumentFactoryDescriptor getPublishedDocumentFactoryDescriptor(PublicationTreeConfigDescriptor config, PublicationTreeDescriptor treeDescriptor) throws PublisherException {
        PublishedDocumentFactoryDescriptor factoryDesc;
        String factoryName = config.getFactory();
        if (factoryName == null) {
            factoryName = treeDescriptor.getFactory();
        }
        if ((factoryDesc = this.factoryDescriptors.get(factoryName)) == null) {
            throw new PublisherException("Unable to find factory" + factoryName);
        }
        return factoryDesc;
    }

    protected PublicationTreeConfigDescriptor getPublicationTreeConfigDescriptor(String treeConfigName) throws PublisherException {
        if (!this.treeConfigDescriptors.containsKey(treeConfigName)) {
            throw new PublisherException("Unknow treeConfig :" + treeConfigName);
        }
        return this.treeConfigDescriptors.get(treeConfigName);
    }

    protected PublicationTreeDescriptor getPublicationTreeDescriptor(PublicationTreeConfigDescriptor config) throws PublisherException {
        String treeImplName = config.getTree();
        if (!this.treeDescriptors.containsKey(treeImplName)) {
            throw new PublisherException("Unknow treeImplementation :" + treeImplName);
        }
        return this.treeDescriptors.get(treeImplName);
    }

    protected PublicationTree getPublicationTree(PublicationTreeDescriptor treeDescriptor, String sid, CoreSession coreSession, Map<String, String> parameters, PublishedDocumentFactory factory, String configName, String treeTitle) throws PublisherException, PublicationTreeNotAvailable {
        PublicationTree treeImpl;
        try {
            treeImpl = treeDescriptor.getKlass().newInstance();
        }
        catch (Exception e) {
            throw new PublisherException("Error while creating tree implementation", (Throwable)e);
        }
        try {
            treeImpl.initTree(sid, coreSession, parameters, factory, configName, treeTitle);
        }
        catch (Exception e) {
            throw new PublicationTreeNotAvailable("Error during tree init", (Throwable)e);
        }
        return treeImpl;
    }

    public PublishedDocument publish(DocumentModel doc, PublicationNode targetNode) throws ClientException {
        return this.publish(doc, targetNode, null);
    }

    public PublishedDocument publish(DocumentModel doc, PublicationNode targetNode, Map<String, String> params) throws ClientException {
        PublicationTree tree = this.liveTrees.get(targetNode.getSessionId());
        if (tree != null) {
            return tree.publish(doc, targetNode, params);
        }
        throw new ClientException("Calling getChildrenNodes on a closed tree");
    }

    public void unpublish(DocumentModel doc, PublicationNode targetNode) throws ClientException {
        PublicationTree tree = this.liveTrees.get(targetNode.getSessionId());
        if (tree == null) {
            throw new ClientException("Calling getChildrenNodes on a closed tree");
        }
        tree.unpublish(doc, targetNode);
    }

    public void unpublish(String sid, PublishedDocument publishedDocument) throws ClientException {
        PublicationTree tree = this.liveTrees.get(sid);
        if (tree == null) {
            throw new ClientException("Calling getChildrenNodes on a closed tree");
        }
        tree.unpublish(publishedDocument);
    }

    public List<PublishedDocument> getChildrenDocuments(PublicationNode node) throws ClientException {
        PublicationTree tree = this.liveTrees.get(node.getSessionId());
        if (tree != null) {
            return tree.getPublishedDocumentInNode(tree.getNodeByPath(node.getPath()));
        }
        throw new ClientException("Calling getChildrenDocuments on a closed tree");
    }

    protected List<PublicationNode> makeRemotable(List<PublicationNode> nodes, String sid) throws ClientException {
        ArrayList<PublicationNode> remoteNodes = new ArrayList<PublicationNode>();
        for (PublicationNode node : nodes) {
            remoteNodes.add(new ProxyNode(node, sid));
        }
        return remoteNodes;
    }

    public List<PublicationNode> getChildrenNodes(PublicationNode node) throws ClientException {
        String sid = node.getSessionId();
        PublicationTree tree = this.liveTrees.get(sid);
        if (tree != null) {
            return this.makeRemotable(tree.getNodeByPath(node.getPath()).getChildrenNodes(), sid);
        }
        throw new ClientException("Calling getChildrenNodes on a closed tree");
    }

    public PublicationNode getParent(PublicationNode node) {
        String sid = node.getSessionId();
        PublicationTree tree = this.liveTrees.get(sid);
        if (tree != null) {
            try {
                PublicationNode liveNode = tree.getNodeByPath(node.getPath()).getParent();
                if (liveNode == null) {
                    return null;
                }
                return new ProxyNode(liveNode, sid);
            }
            catch (ClientException e) {
                this.log.error((Object)"Error while getting Parent", (Throwable)e);
                return null;
            }
        }
        this.log.error((Object)"Calling getParent on a closed tree");
        return null;
    }

    public PublicationNode getNodeByPath(String sid, String path) throws ClientException {
        PublicationTree tree = this.liveTrees.get(sid);
        if (tree != null) {
            return new ProxyNode(tree.getNodeByPath(path), sid);
        }
        throw new ClientException("Calling getNodeByPath on a closed tree");
    }

    public List<PublishedDocument> getExistingPublishedDocument(String sid, DocumentLocation docLoc) throws ClientException {
        PublicationTree tree = this.liveTrees.get(sid);
        if (tree != null) {
            return tree.getExistingPublishedDocument(docLoc);
        }
        throw new ClientException("Calling getNodeByPath on a closed tree");
    }

    public List<PublishedDocument> getPublishedDocumentInNode(PublicationNode node) throws ClientException {
        String sid = node.getSessionId();
        PublicationTree tree = this.liveTrees.get(sid);
        if (tree != null) {
            return tree.getPublishedDocumentInNode(tree.getNodeByPath(node.getPath()));
        }
        throw new ClientException("Calling getPublishedDocumentInNode on a closed tree");
    }

    public void setCurrentDocument(String sid, DocumentModel currentDocument) throws ClientException {
        PublicationTree tree = this.liveTrees.get(sid);
        if (tree == null) {
            throw new ClientException("Calling validatorPublishDocument on a closed tree");
        }
        tree.setCurrentDocument(currentDocument);
    }

    public void validatorPublishDocument(String sid, PublishedDocument publishedDocument, String comment) throws ClientException {
        PublicationTree tree = this.liveTrees.get(sid);
        if (tree == null) {
            throw new ClientException("Calling validatorPublishDocument on a closed tree");
        }
        tree.validatorPublishDocument(publishedDocument, comment);
    }

    public void validatorRejectPublication(String sid, PublishedDocument publishedDocument, String comment) throws ClientException {
        PublicationTree tree = this.liveTrees.get(sid);
        if (tree == null) {
            throw new ClientException("Calling validatorPublishDocument on a closed tree");
        }
        tree.validatorRejectPublication(publishedDocument, comment);
    }

    public boolean canPublishTo(String sid, PublicationNode publicationNode) throws ClientException {
        PublicationTree tree = this.liveTrees.get(sid);
        if (tree != null) {
            return tree.canPublishTo(publicationNode);
        }
        throw new ClientException("Calling validatorPublishDocument on a closed tree");
    }

    public boolean canUnpublish(String sid, PublishedDocument publishedDocument) throws ClientException {
        PublicationTree tree = this.liveTrees.get(sid);
        if (tree != null) {
            return tree.canUnpublish(publishedDocument);
        }
        throw new ClientException("Calling validatorPublishDocument on a closed tree");
    }

    public boolean canManagePublishing(String sid, PublishedDocument publishedDocument) throws ClientException {
        PublicationTree tree = this.liveTrees.get(sid);
        if (tree != null) {
            return tree.canManagePublishing(publishedDocument);
        }
        throw new ClientException("Calling validatorPublishDocument on a closed tree");
    }

    public boolean isPublishedDocument(DocumentModel documentModel) {
        return PublicationRelationHelper.isPublished(documentModel);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PublicationTree getPublicationTreeFor(DocumentModel doc, CoreSession coreSession) throws ClientException {
        PublicationTree tree = null;
        try {
            return PublicationRelationHelper.getPublicationTreeUsedForPublishing(doc, coreSession);
        }
        catch (ClientException e) {
            String treeName;
            this.log.debug((Object)("Unable to get PublicationTree for " + doc.getPathAsString() + ". Fallback on first PublicationTree accepting this document."));
            Iterator<String> i$ = this.treeConfigDescriptors.keySet().iterator();
            do {
                if (!i$.hasNext()) return tree;
            } while (!(tree = this.getPublicationTree(treeName = i$.next(), coreSession, null)).isPublicationNode(doc));
        }
        return tree;
    }

    public boolean hasValidationTask(String sid, PublishedDocument publishedDocument) throws ClientException {
        PublicationTree tree = this.liveTrees.get(sid);
        if (tree != null) {
            return tree.hasValidationTask(publishedDocument);
        }
        throw new ClientException("Calling validatorPublishDocument on a closed tree");
    }

    public PublishedDocument wrapToPublishedDocument(String sid, DocumentModel documentModel) throws ClientException {
        PublicationTree tree = this.liveTrees.get(sid);
        if (tree != null) {
            return tree.wrapToPublishedDocument(documentModel);
        }
        throw new ClientException("Calling validatorPublishDocument on a closed tree");
    }

    public boolean isPublicationNode(String sid, DocumentModel documentModel) throws ClientException {
        PublicationTree tree = this.liveTrees.get(sid);
        if (tree != null) {
            return tree.isPublicationNode(documentModel);
        }
        throw new ClientException("Calling validatorPublishDocument on a closed tree");
    }

    public PublicationNode wrapToPublicationNode(String sid, DocumentModel documentModel) throws ClientException {
        PublicationTree tree = this.liveTrees.get(sid);
        if (tree != null) {
            return tree.wrapToPublicationNode(documentModel);
        }
        throw new ClientException("Calling validatorPublishDocument on a closed tree");
    }

    public PublicationNode wrapToPublicationNode(DocumentModel documentModel, CoreSession coreSession) throws ClientException, PublicationTreeNotAvailable {
        for (String name : this.getAvailablePublicationTree()) {
            PublicationTree tree = this.getPublicationTree(name, coreSession, null);
            PublicationTreeConfigDescriptor config = this.treeConfigDescriptors.get(tree.getConfigName());
            if (!config.islocalSectionTree() || !tree.isPublicationNode(documentModel)) continue;
            return tree.wrapToPublicationNode(documentModel);
        }
        return null;
    }

    protected void registerPendingDescriptors() throws Exception {
        RepositoryManager repositoryManager = (RepositoryManager)Framework.getService(RepositoryManager.class);
        String repositoryName = repositoryManager.getDefaultRepositoryName();
        List<DocumentModel> domains = new DomainsFinder(repositoryName).getDomains();
        for (DocumentModel domain : domains) {
            this.registerTreeConfigFor(domain);
        }
    }

    public void registerTreeConfigFor(DocumentModel domain) throws ClientException {
        for (PublicationTreeConfigDescriptor desc : this.pendingDescriptors.values()) {
            PublicationTreeConfigDescriptor newDesc = new PublicationTreeConfigDescriptor(desc);
            String newTreeName = desc.getName() + "-" + domain.getName();
            newDesc.setName(newTreeName);
            Path newPath = domain.getPath();
            Map<String, String> parameters = newDesc.getParameters();
            newPath = newPath.append(parameters.remove(RELATIVE_ROOT_PATH_KEY));
            parameters.put(ROOT_PATH_KEY, newPath.toString());
            parameters.put("DomainName", domain.getTitle());
            this.treeConfigDescriptors.put(newDesc.getName(), newDesc);
        }
    }

    public void unRegisterTreeConfigFor(DocumentModel domain) {
        for (PublicationTreeConfigDescriptor desc : this.pendingDescriptors.values()) {
            String treeName = desc.getName() + "-" + domain.getName();
            this.treeConfigDescriptors.remove(treeName);
            Iterator<String> it = this.liveTrees.keySet().iterator();
            while (it.hasNext()) {
                String entry = it.next();
                if (!entry.startsWith(treeName)) continue;
                it.remove();
            }
        }
    }

    public Map<String, String> getParametersFor(String treeConfigName) {
        PublicationTreeConfigDescriptor desc = this.treeConfigDescriptors.get(treeConfigName);
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (desc != null) {
            parameters.putAll(desc.getParameters());
        }
        return parameters;
    }

    public RootSectionFinder getRootSectionFinder(CoreSession session) {
        if (this.rootSectionFinderFactory != null) {
            return this.rootSectionFinderFactory.getRootSectionFinder(session);
        }
        return new DefaultRootSectionsFinder(session);
    }
}

