/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.constructs.blocking;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.concurrent.CacheLockProvider;
import net.sf.ehcache.concurrent.LockType;
import net.sf.ehcache.concurrent.StripedReadWriteLockSync;
import net.sf.ehcache.concurrent.Sync;
import net.sf.ehcache.constructs.EhcacheDecoratorAdapter;
import net.sf.ehcache.constructs.blocking.LockTimeoutException;
import net.sf.ehcache.loader.CacheLoader;

public class BlockingCache
extends EhcacheDecoratorAdapter {
    protected volatile int timeoutMillis;
    private final int stripes;
    private final AtomicReference<CacheLockProvider> cacheLockProviderReference;

    public BlockingCache(Ehcache cache, int numberOfStripes) throws CacheException {
        super(cache);
        this.stripes = numberOfStripes;
        this.cacheLockProviderReference = new AtomicReference();
    }

    public BlockingCache(Ehcache cache) throws CacheException {
        this(cache, 2048);
    }

    private CacheLockProvider getCacheLockProvider() {
        CacheLockProvider provider = this.cacheLockProviderReference.get();
        while (provider == null) {
            this.cacheLockProviderReference.compareAndSet(null, this.createCacheLockProvider());
            provider = this.cacheLockProviderReference.get();
        }
        return provider;
    }

    private CacheLockProvider createCacheLockProvider() {
        Object context = this.underlyingCache.getInternalContext();
        if (this.underlyingCache.getCacheConfiguration().isTerracottaClustered() && context != null) {
            return (CacheLockProvider)context;
        }
        return new StripedReadWriteLockSync(this.stripes);
    }

    protected Ehcache getCache() {
        return this.underlyingCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element get(Object key) throws RuntimeException, LockTimeoutException {
        Element element;
        Sync lock = this.getLockForKey(key);
        this.acquiredLockForKey(key, lock, LockType.READ);
        try {
            element = this.underlyingCache.get(key);
        }
        finally {
            lock.unlock(LockType.READ);
        }
        if (element == null) {
            this.acquiredLockForKey(key, lock, LockType.WRITE);
            element = this.underlyingCache.getQuiet(key);
            if (element != null) {
                if (this.underlyingCache.isStatisticsEnabled()) {
                    element = this.underlyingCache.get(key);
                }
                lock.unlock(LockType.WRITE);
            }
        }
        return element;
    }

    private void acquiredLockForKey(Object key, Sync lock, LockType lockType) {
        block4: {
            if (this.timeoutMillis > 0) {
                try {
                    boolean acquired = lock.tryLock(lockType, this.timeoutMillis);
                    if (!acquired) {
                        StringBuilder message = new StringBuilder("Lock timeout. Waited more than ").append(this.timeoutMillis).append("ms to acquire lock for key ").append(key).append(" on blocking cache ").append(this.underlyingCache.getName());
                        throw new LockTimeoutException(message.toString());
                    }
                    break block4;
                }
                catch (InterruptedException e) {
                    throw new LockTimeoutException("Got interrupted while trying to acquire lock for key " + key, e);
                }
            }
            lock.lock(lockType);
        }
    }

    protected Sync getLockForKey(Object key) {
        return this.getCacheLockProvider().getSyncForKey(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Element element) {
        if (element == null) {
            return;
        }
        Object key = element.getObjectKey();
        Object value = element.getObjectValue();
        Sync lock = this.getLockForKey(key);
        if (!lock.isHeldByCurrentThread(LockType.WRITE)) {
            lock.lock(LockType.WRITE);
        }
        try {
            if (value != null) {
                this.underlyingCache.put(element);
            } else {
                this.underlyingCache.remove(key);
            }
        }
        finally {
            lock.unlock(LockType.WRITE);
        }
    }

    public Element get(Serializable key) throws IllegalStateException, CacheException {
        return this.get((Object)key);
    }

    public synchronized String liveness() {
        return this.getName();
    }

    public void setTimeoutMillis(int timeoutMillis) {
        if (timeoutMillis < 0) {
            throw new CacheException("The lock timeout must be a positive number of ms. Value was " + timeoutMillis);
        }
        this.timeoutMillis = timeoutMillis;
    }

    public int getTimeoutMillis() {
        return this.timeoutMillis;
    }

    public void registerCacheLoader(CacheLoader cacheLoader) {
        throw new CacheException("This method is not appropriate for a blocking cache.");
    }

    public void unregisterCacheLoader(CacheLoader cacheLoader) {
        throw new CacheException("This method is not appropriate for a blocking cache.");
    }

    public Element getWithLoader(Object key, CacheLoader loader, Object loaderArgument) throws CacheException {
        throw new CacheException("This method is not appropriate for a Blocking Cache");
    }

    public Map getAllWithLoader(Collection keys, Object loaderArgument) throws CacheException {
        throw new CacheException("This method is not appropriate for a Blocking Cache");
    }

    public void load(Object key) throws CacheException {
        throw new CacheException("This method is not appropriate for a Blocking Cache");
    }

    public void loadAll(Collection keys, Object argument) throws CacheException {
        throw new CacheException("This method is not appropriate for a Blocking Cache");
    }
}

