/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisFactory;
import redis.clients.jedis.JedisPubSub;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.util.Pool;

public class JedisSentinelPool
extends Pool<Jedis> {
    protected GenericObjectPoolConfig poolConfig;
    protected int timeout = 2000;
    protected String password;
    protected int database = 0;
    protected Set<MasterListener> masterListeners = new HashSet<MasterListener>();
    protected Logger log = Logger.getLogger(this.getClass().getName());
    private volatile HostAndPort currentHostMaster;

    public JedisSentinelPool(String masterName, Set<String> sentinels, GenericObjectPoolConfig poolConfig) {
        this(masterName, sentinels, poolConfig, 2000, null, 0);
    }

    public JedisSentinelPool(String masterName, Set<String> sentinels) {
        this(masterName, sentinels, new GenericObjectPoolConfig(), 2000, null, 0);
    }

    public JedisSentinelPool(String masterName, Set<String> sentinels, String password) {
        this(masterName, sentinels, new GenericObjectPoolConfig(), 2000, password);
    }

    public JedisSentinelPool(String masterName, Set<String> sentinels, GenericObjectPoolConfig poolConfig, int timeout, String password) {
        this(masterName, sentinels, poolConfig, timeout, password, 0);
    }

    public JedisSentinelPool(String masterName, Set<String> sentinels, GenericObjectPoolConfig poolConfig, int timeout) {
        this(masterName, sentinels, poolConfig, timeout, null, 0);
    }

    public JedisSentinelPool(String masterName, Set<String> sentinels, GenericObjectPoolConfig poolConfig, String password) {
        this(masterName, sentinels, poolConfig, 2000, password);
    }

    public JedisSentinelPool(String masterName, Set<String> sentinels, GenericObjectPoolConfig poolConfig, int timeout, String password, int database) {
        this.poolConfig = poolConfig;
        this.timeout = timeout;
        this.password = password;
        this.database = database;
        HostAndPort master = this.initSentinels(sentinels, masterName);
        this.initPool(master);
    }

    @Override
    public void returnBrokenResource(Jedis resource) {
        this.returnBrokenResourceObject(resource);
    }

    @Override
    public void returnResource(Jedis resource) {
        resource.resetState();
        this.returnResourceObject(resource);
    }

    @Override
    public void destroy() {
        for (MasterListener m : this.masterListeners) {
            m.shutdown();
        }
        super.destroy();
    }

    public HostAndPort getCurrentHostMaster() {
        return this.currentHostMaster;
    }

    private void initPool(HostAndPort master) {
        if (!master.equals(this.currentHostMaster)) {
            this.currentHostMaster = master;
            this.log.info("Created JedisPool to master at " + master);
            this.initPool(this.poolConfig, new JedisFactory(master.getHost(), master.getPort(), this.timeout, this.password, this.database));
        }
    }

    private HostAndPort initSentinels(Set<String> sentinels, String masterName) {
        HostAndPort hap;
        HostAndPort master = null;
        boolean running = true;
        block4: while (running) {
            this.log.info("Trying to find master from available Sentinels...");
            for (String sentinel : sentinels) {
                hap = this.toHostAndPort(Arrays.asList(sentinel.split(":")));
                this.log.fine("Connecting to Sentinel " + hap);
                try {
                    Jedis jedis = new Jedis(hap.getHost(), hap.getPort());
                    if (master != null) continue;
                    master = this.toHostAndPort(jedis.sentinelGetMasterAddrByName(masterName));
                    this.log.fine("Found Redis master at " + master);
                    jedis.disconnect();
                    break block4;
                }
                catch (JedisConnectionException e) {
                    this.log.warning("Cannot connect to sentinel running @ " + hap + ". Trying next one.");
                }
            }
            try {
                this.log.severe("All sentinels down, cannot determine where is " + masterName + " master is running... sleeping 1000ms.");
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.log.info("Redis master running at " + master + ", starting Sentinel listeners...");
        for (String sentinel : sentinels) {
            hap = this.toHostAndPort(Arrays.asList(sentinel.split(":")));
            MasterListener masterListener = new MasterListener(masterName, hap.getHost(), hap.getPort());
            this.masterListeners.add(masterListener);
            masterListener.start();
        }
        return master;
    }

    private HostAndPort toHostAndPort(List<String> getMasterAddrByNameResult) {
        String host = getMasterAddrByNameResult.get(0);
        int port = Integer.parseInt(getMasterAddrByNameResult.get(1));
        return new HostAndPort(host, port);
    }

    protected class MasterListener
    extends Thread {
        protected String masterName;
        protected String host;
        protected int port;
        protected long subscribeRetryWaitTimeMillis = 5000L;
        protected Jedis j;
        protected AtomicBoolean running = new AtomicBoolean(false);

        protected MasterListener() {
        }

        public MasterListener(String masterName, String host, int port) {
            this.masterName = masterName;
            this.host = host;
            this.port = port;
        }

        public MasterListener(String masterName, String host, int port, long subscribeRetryWaitTimeMillis) {
            this(masterName, host, port);
            this.subscribeRetryWaitTimeMillis = subscribeRetryWaitTimeMillis;
        }

        @Override
        public void run() {
            this.running.set(true);
            while (this.running.get()) {
                this.j = new Jedis(this.host, this.port);
                try {
                    this.j.subscribe(new JedisPubSubAdapter(){

                        @Override
                        public void onMessage(String channel, String message) {
                            JedisSentinelPool.this.log.fine("Sentinel " + MasterListener.this.host + ":" + MasterListener.this.port + " published: " + message + ".");
                            String[] switchMasterMsg = message.split(" ");
                            if (switchMasterMsg.length > 3) {
                                if (MasterListener.this.masterName.equals(switchMasterMsg[0])) {
                                    JedisSentinelPool.this.initPool(JedisSentinelPool.this.toHostAndPort(Arrays.asList(switchMasterMsg[3], switchMasterMsg[4])));
                                } else {
                                    JedisSentinelPool.this.log.fine("Ignoring message on +switch-master for master name " + switchMasterMsg[0] + ", our master name is " + MasterListener.this.masterName);
                                }
                            } else {
                                JedisSentinelPool.this.log.severe("Invalid message received on Sentinel " + MasterListener.this.host + ":" + MasterListener.this.port + " on channel +switch-master: " + message);
                            }
                        }
                    }, "+switch-master");
                }
                catch (JedisConnectionException e) {
                    if (this.running.get()) {
                        JedisSentinelPool.this.log.severe("Lost connection to Sentinel at " + this.host + ":" + this.port + ". Sleeping 5000ms and retrying.");
                        try {
                            Thread.sleep(this.subscribeRetryWaitTimeMillis);
                        }
                        catch (InterruptedException e1) {
                            e1.printStackTrace();
                        }
                        continue;
                    }
                    JedisSentinelPool.this.log.fine("Unsubscribing from Sentinel at " + this.host + ":" + this.port);
                }
            }
        }

        public void shutdown() {
            try {
                JedisSentinelPool.this.log.fine("Shutting down listener on " + this.host + ":" + this.port);
                this.running.set(false);
                this.j.disconnect();
            }
            catch (Exception e) {
                JedisSentinelPool.this.log.severe("Caught exception while shutting down: " + e.getMessage());
            }
        }
    }

    protected class JedisPubSubAdapter
    extends JedisPubSub {
        protected JedisPubSubAdapter() {
        }

        @Override
        public void onMessage(String channel, String message) {
        }

        @Override
        public void onPMessage(String pattern, String channel, String message) {
        }

        @Override
        public void onPSubscribe(String pattern, int subscribedChannels) {
        }

        @Override
        public void onPUnsubscribe(String pattern, int subscribedChannels) {
        }

        @Override
        public void onSubscribe(String channel, int subscribedChannels) {
        }

        @Override
        public void onUnsubscribe(String channel, int subscribedChannels) {
        }
    }
}

