/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.javascript.JSFunction;
import org.richfaces.application.ServiceTracker;
import org.richfaces.javascript.DnDScript;
import org.richfaces.javascript.JavaScriptService;
import org.richfaces.renderkit.RendererBase;

public abstract class DnDRenderBase
extends RendererBase {
    public void buildAndStoreScript(FacesContext facesContext, UIComponent component) {
        JavaScriptService javaScriptService = (JavaScriptService)ServiceTracker.getService(JavaScriptService.class);
        DnDScript dragScript = this.buildClientScript(facesContext, component);
        if (javaScriptService != null && dragScript != null) {
            javaScriptService.addPageReadyScript(facesContext, (Object)dragScript);
        }
    }

    public abstract Map<String, Object> getOptions(FacesContext var1, UIComponent var2);

    public abstract String getScriptName();

    public abstract DnDScript createScript(String var1);

    public String getParentClientId(FacesContext facesContext, UIComponent component) {
        UIComponent parent = component.getParent();
        return parent != null ? parent.getClientId(facesContext) : "";
    }

    private DnDScript buildClientScript(FacesContext facesContext, UIComponent component) {
        DnDScript script = null;
        String scriptName = this.getScriptName();
        if (!"".equals(scriptName)) {
            JSFunction function = new JSFunction(scriptName, new Object[0]);
            function.addParameter((Object)component.getClientId(facesContext));
            function.addParameter(this.getOptions(facesContext, component));
            script = this.createScript(function.toScript());
        }
        return script;
    }

    protected void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        this.buildAndStoreScript(context, component);
    }
}

