/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.io.File;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.Part;
import org.richfaces.component.AbstractFileUpload;
import org.richfaces.event.FileUploadEvent;
import org.richfaces.exception.FileUploadException;
import org.richfaces.model.UploadedFile;
import org.richfaces.renderkit.RendererBase;
import org.richfaces.request.MultipartRequest25;
import org.richfaces.request.MultipartRequestParser;
import org.richfaces.request.UploadedFile30;

public class FileUploadRendererBase
extends RendererBase {
    private boolean isCreateTempFiles(ServletContext servletContext) {
        String param = servletContext.getInitParameter("org.richfaces.fileUpload.createTempFiles");
        if (param != null) {
            return Boolean.parseBoolean(param);
        }
        return true;
    }

    private String getTempFilesDirectory(ServletContext servletContext) {
        File servletTempDir;
        String result = servletContext.getInitParameter("org.richfaces.fileUpload.tempFilesDirectory");
        if (result == null && (servletTempDir = (File)servletContext.getAttribute("javax.servlet.context.tempdir")) != null) {
            result = servletTempDir.getAbsolutePath();
        }
        if (result == null) {
            result = new File(System.getProperty("java.io.tmpdir")).getAbsolutePath();
        }
        return result;
    }

    private Iterable<UploadedFile> initializeUploadedFiles(ExternalContext context, HttpServletRequest request, String uploadId) {
        try {
            List<UploadedFile> files = new LinkedList<UploadedFile>();
            if (request.getParts().size() > 0) {
                Collection parts = request.getParts();
                for (Part part : parts) {
                    String contentDisposition = part.getHeader("Content-Disposition");
                    String filename = MultipartRequestParser.parseFileName(contentDisposition);
                    if (filename == null) continue;
                    files.add(new UploadedFile30(part.getName(), filename, part));
                }
            } else {
                boolean createTempFiles = this.isCreateTempFiles(request.getServletContext());
                String tempFilesDirectory = this.getTempFilesDirectory(request.getServletContext());
                MultipartRequestParser requestParser = new MultipartRequestParser(request, createTempFiles, tempFilesDirectory);
                MultipartRequest25 multipartRequest = new MultipartRequest25(request, uploadId, requestParser);
                files = (List)multipartRequest.getUploadedFiles();
            }
            return files;
        }
        catch (Exception e) {
            context.setResponseStatus(500);
            throw new FileUploadException("couldn't parse request parts", e);
        }
    }

    private long getMaxRequestSize(ServletContext servletContext) {
        String param = servletContext.getInitParameter("org.richfaces.fileUpload.maxRequestSize");
        if (param != null) {
            return Long.parseLong(param);
        }
        return 0L;
    }

    protected void doDecode(FacesContext context, UIComponent component) {
        String uid;
        HttpServletRequest httpRequest;
        AbstractFileUpload fileUpload = (AbstractFileUpload)component;
        ExternalContext externalContext = context.getExternalContext();
        Object request = externalContext.getRequest();
        if (request instanceof HttpServletRequest && (httpRequest = (HttpServletRequest)request).getContentType() != null && httpRequest.getContentType().startsWith("multipart/") && (uid = MultipartRequestParser.getParameterValueFromQueryString(httpRequest.getQueryString())) != null) {
            long contentLength = Long.parseLong(httpRequest.getHeader("Content-Length"));
            long maxRequestSize = this.getMaxRequestSize(httpRequest.getServletContext());
            if (maxRequestSize != 0L && contentLength > maxRequestSize) {
                externalContext.setResponseStatus(413);
                return;
            }
            Iterable<UploadedFile> uploadedFiles = this.initializeUploadedFiles(externalContext, httpRequest, uid);
            for (UploadedFile file : uploadedFiles) {
                if (!fileUpload.acceptsFile(file)) continue;
                fileUpload.queueEvent(new FileUploadEvent((UIComponent)fileUpload, file));
            }
        }
    }
}

