/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html.images;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.faces.context.FacesContext;
import org.richfaces.resource.AbstractJava2DUserResource;
import org.richfaces.resource.DynamicUserResource;
import org.richfaces.resource.PostConstructResource;
import org.richfaces.resource.StateHolderResource;
import org.richfaces.skin.Skin;
import org.richfaces.skin.SkinFactory;

@DynamicUserResource
public class CalendarIcon
extends AbstractJava2DUserResource
implements StateHolderResource {
    private static final Dimension DIMENSION = new Dimension(20, 20);
    private Integer headerTextColor;
    private Integer headerBackgroundColor;

    public CalendarIcon() {
        super(DIMENSION);
    }

    @PostConstructResource
    public final void initialize() {
        FacesContext context = FacesContext.getCurrentInstance();
        Skin skin = SkinFactory.getInstance((FacesContext)context).getSkin(context);
        Skin defaultSkin = SkinFactory.getInstance((FacesContext)context).getDefaultSkin(context);
        this.headerTextColor = skin.getColorParameter(context, "headerBackgroundColor");
        if (this.headerTextColor == null) {
            this.headerTextColor = defaultSkin.getColorParameter(context, "headerBackgroundColor");
        }
        this.headerBackgroundColor = skin.getColorParameter(context, "selectControlColor");
        if (this.headerBackgroundColor == null) {
            this.headerBackgroundColor = defaultSkin.getColorParameter(context, "selectControlColor");
        }
    }

    public boolean isTransient() {
        return false;
    }

    public void writeState(FacesContext context, DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.headerTextColor);
        dataOutput.writeInt(this.headerBackgroundColor);
    }

    public void readState(FacesContext context, DataInput dataInput) throws IOException {
        this.headerTextColor = dataInput.readInt();
        this.headerBackgroundColor = dataInput.readInt();
    }

    protected BufferedImage createImage(int width, int height) {
        return new BufferedImage(width, height, 2);
    }

    public void paint(Graphics2D graphics2d) {
        BufferedImage image = this.paintImage();
        graphics2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        Dimension dimension = this.getDimension();
        graphics2d.drawImage(image, 0, 0, dimension.width, dimension.height, null);
    }

    public BufferedImage paintImage() {
        BufferedImage image = this.createImage(16, 16);
        Graphics2D g2d = image.createGraphics();
        Color borderColor = new Color(this.headerTextColor);
        Color activeColor = new Color(this.headerBackgroundColor);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        g2d.setStroke(new BasicStroke(1.0f));
        int w = 16;
        int h = 16;
        g2d.setColor(borderColor);
        Rectangle2D.Double border = new Rectangle2D.Double(1.0, 1.0, w - 3, h - 3);
        RoundRectangle2D.Double round = new RoundRectangle2D.Double(1.0, 1.0, w - 3, h - 3, 2.0, 2.0);
        g2d.draw(round);
        Color lightBlue = new Color(216, 226, 240);
        GradientPaint gradient1 = new GradientPaint(w - 4, h - 4, lightBlue, 2.0f, 2.0f, Color.white);
        g2d.setPaint(gradient1);
        border = new Rectangle2D.Double(2.0, 2.0, w - 4, h - 4);
        g2d.fill(border);
        border = new Rectangle2D.Double(3.0, 3.0, w - 6, h - 6);
        gradient1 = new GradientPaint(3.0f, 3.0f, lightBlue, w - 6, h - 6, borderColor);
        g2d.setPaint(gradient1);
        g2d.fill(border);
        g2d.setColor(Color.white);
        g2d.drawLine(3, 6, 3, 11);
        g2d.drawLine(5, 6, 5, 11);
        g2d.drawLine(7, 6, 7, 11);
        g2d.drawLine(9, 6, 9, 11);
        g2d.drawLine(11, 6, 11, 11);
        border = new Rectangle2D.Double(3.0, 3.0, 10.0, 3.0);
        g2d.setColor(Color.white);
        g2d.fill(border);
        Color c = new Color(activeColor.getRed(), activeColor.getGreen(), activeColor.getBlue(), 100);
        Color c2 = new Color(activeColor.getRed(), activeColor.getGreen(), activeColor.getBlue(), 200);
        gradient1 = new GradientPaint(12.0f, 4.0f, activeColor, 4.0f, 7.0f, c2);
        g2d.setPaint(gradient1);
        g2d.fill(border);
        c = new Color(activeColor.getRed(), activeColor.getGreen(), activeColor.getBlue(), 150);
        c2 = new Color(activeColor.getRed(), activeColor.getGreen(), activeColor.getBlue(), 200);
        border = new Rectangle2D.Double(4.0, 4.0, 8.0, 1.0);
        g2d.setColor(Color.white);
        g2d.fill(border);
        gradient1 = new GradientPaint(4.0f, 4.0f, c, 10.0f, 4.0f, c2);
        g2d.setColor(c);
        g2d.fill(border);
        g2d.dispose();
        return image;
    }
}

