/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.wss.impl;

import javax.servlet.http.HttpServletRequest;
import org.nuxeo.ecm.webdav.backend.Backend;
import org.nuxeo.ecm.webdav.backend.BackendHelper;
import org.nuxeo.wss.impl.WSSBackendAdapter;
import org.nuxeo.wss.impl.WSSFakeBackend;
import org.nuxeo.wss.impl.WSSRootBackendAdapter;
import org.nuxeo.wss.impl.WSSVirtualBackendAdapter;
import org.nuxeo.wss.servlet.WSSRequest;
import org.nuxeo.wss.spi.WSSBackend;
import org.nuxeo.wss.spi.WSSBackendFactory;

public class WSSBackendFactoryImpl
implements WSSBackendFactory {
    protected String computeVirtualRoot(WSSRequest request) {
        if (request == null) {
            return "nuxeo";
        }
        String virtualRoot = request.getSitePath();
        if (virtualRoot == null || virtualRoot.equals("")) {
            virtualRoot = request.getHttpRequest().getContextPath();
        }
        if (virtualRoot.startsWith("/")) {
            virtualRoot = virtualRoot.substring(1);
        }
        return virtualRoot;
    }

    @Override
    public WSSBackend getBackend(WSSRequest wssRequest) {
        String path = "/";
        HttpServletRequest request = wssRequest == null ? null : wssRequest.getHttpRequest();
        Backend backend = BackendHelper.getBackend((String)path, (HttpServletRequest)request);
        if (backend == null) {
            return new WSSFakeBackend();
        }
        String virtualRoot = this.computeVirtualRoot(wssRequest);
        if (backend.isRoot()) {
            return new WSSRootBackendAdapter(backend, virtualRoot);
        }
        if (backend.isVirtual()) {
            return new WSSVirtualBackendAdapter(backend, virtualRoot);
        }
        return new WSSBackendAdapter(backend, virtualRoot);
    }
}

