/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.context;

import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;
import org.richfaces.component.MetaComponentEncoder;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;

final class MetaComponentEncodingVisitCallback
implements VisitCallback {
    private static final Logger LOG = RichfacesLogger.CONTEXT.getLogger();
    private FacesContext facesContext;
    private VisitCallback wrapped;

    MetaComponentEncodingVisitCallback(VisitCallback visitCallbackToWrap, FacesContext facesContext) {
        this.wrapped = visitCallbackToWrap;
        this.facesContext = facesContext;
    }

    public VisitResult visit(VisitContext context, UIComponent target) {
        String metaComponentId;
        if (target instanceof MetaComponentEncoder && (metaComponentId = (String)this.facesContext.getAttributes().get("org.richfaces.MetaComponentId")) != null) {
            MetaComponentEncoder encoder = (MetaComponentEncoder)target;
            try {
                encoder.encodeMetaComponent(this.facesContext, metaComponentId);
            }
            catch (Exception e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error(e.getMessage(), e);
                }
                throw new FacesException(String.format("exception thrown during encoding of meta-component %s@%s", target.getId(), metaComponentId), (Throwable)e);
            }
            return VisitResult.REJECT;
        }
        return this.wrapped.visit(context, target);
    }
}

