/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.reroute;

import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.routing.allocation.RoutingExplanations;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class ClusterRerouteResponse
extends AcknowledgedResponse {
    private ClusterState state;
    private RoutingExplanations explanations;

    ClusterRerouteResponse() {
    }

    ClusterRerouteResponse(boolean acknowledged, ClusterState state, RoutingExplanations explanations) {
        super(acknowledged);
        this.state = state;
        this.explanations = explanations;
    }

    public ClusterState getState() {
        return this.state;
    }

    public RoutingExplanations getExplanations() {
        return this.explanations;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.state = ClusterState.Builder.readFrom(in, null);
        this.readAcknowledged(in);
        this.explanations = in.getVersion().onOrAfter(Version.V_1_1_0) ? RoutingExplanations.readFrom(in) : new RoutingExplanations();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        ClusterState.Builder.writeTo(this.state, out);
        this.writeAcknowledged(out);
        if (out.getVersion().onOrAfter(Version.V_1_1_0)) {
            RoutingExplanations.writeTo(this.explanations, out);
        }
    }
}

