/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.snapshots.create;

import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.snapshots.create.CreateSnapshotRequest;
import org.elasticsearch.action.admin.cluster.snapshots.create.CreateSnapshotResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeOperationAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.SnapshotId;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.snapshots.SnapshotInfo;
import org.elasticsearch.snapshots.SnapshotsService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportCreateSnapshotAction
extends TransportMasterNodeOperationAction<CreateSnapshotRequest, CreateSnapshotResponse> {
    private final SnapshotsService snapshotsService;

    @Inject
    public TransportCreateSnapshotAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, SnapshotsService snapshotsService) {
        super(settings, transportService, clusterService, threadPool);
        this.snapshotsService = snapshotsService;
    }

    @Override
    protected String executor() {
        return "snapshot";
    }

    @Override
    protected String transportAction() {
        return "cluster/snapshot/create";
    }

    @Override
    protected CreateSnapshotRequest newRequest() {
        return new CreateSnapshotRequest();
    }

    @Override
    protected CreateSnapshotResponse newResponse() {
        return new CreateSnapshotResponse();
    }

    @Override
    protected ClusterBlockException checkBlock(CreateSnapshotRequest request, ClusterState state) {
        return state.blocks().indexBlockedException(ClusterBlockLevel.METADATA, "");
    }

    @Override
    protected void masterOperation(final CreateSnapshotRequest request, ClusterState state, final ActionListener<CreateSnapshotResponse> listener) throws ElasticsearchException {
        SnapshotsService.SnapshotRequest snapshotRequest = new SnapshotsService.SnapshotRequest("create_snapshot[" + request.snapshot() + "]", request.snapshot(), request.repository()).indices(request.indices()).indicesOptions(request.indicesOptions()).partial(request.partial()).settings(request.settings()).includeGlobalState(request.includeGlobalState()).masterNodeTimeout(request.masterNodeTimeout());
        this.snapshotsService.createSnapshot(snapshotRequest, new SnapshotsService.CreateSnapshotListener(){

            @Override
            public void onResponse() {
                if (request.waitForCompletion()) {
                    TransportCreateSnapshotAction.this.snapshotsService.addListener(new SnapshotsService.SnapshotCompletionListener(){
                        SnapshotId snapshotId;
                        {
                            this.snapshotId = new SnapshotId(request.repository(), request.snapshot());
                        }

                        @Override
                        public void onSnapshotCompletion(SnapshotId snapshotId, SnapshotInfo snapshot) {
                            if (this.snapshotId.equals(snapshotId)) {
                                listener.onResponse(new CreateSnapshotResponse(snapshot));
                                TransportCreateSnapshotAction.this.snapshotsService.removeListener(this);
                            }
                        }

                        @Override
                        public void onSnapshotFailure(SnapshotId snapshotId, Throwable t) {
                            if (this.snapshotId.equals(snapshotId)) {
                                listener.onFailure(t);
                                TransportCreateSnapshotAction.this.snapshotsService.removeListener(this);
                            }
                        }
                    });
                } else {
                    listener.onResponse(new CreateSnapshotResponse());
                }
            }

            @Override
            public void onFailure(Throwable t) {
                listener.onFailure(t);
            }
        });
    }
}

