/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search.type;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.search.ScoreDoc;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.ReduceSearchPhaseException;
import org.elasticsearch.action.search.SearchOperationThreading;
import org.elasticsearch.action.search.SearchPhaseExecutionException;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.action.search.ShardSearchFailure;
import org.elasticsearch.action.search.type.ParsedScrollId;
import org.elasticsearch.action.search.type.TransportSearchHelper;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.hppc.IntArrayList;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.search.action.SearchServiceListener;
import org.elasticsearch.search.action.SearchServiceTransportAction;
import org.elasticsearch.search.controller.SearchPhaseController;
import org.elasticsearch.search.fetch.FetchSearchRequest;
import org.elasticsearch.search.fetch.FetchSearchResult;
import org.elasticsearch.search.internal.InternalSearchResponse;
import org.elasticsearch.search.query.QuerySearchResult;
import org.elasticsearch.threadpool.ThreadPool;

public class TransportSearchScrollQueryThenFetchAction
extends AbstractComponent {
    private final ThreadPool threadPool;
    private final ClusterService clusterService;
    private final SearchServiceTransportAction searchService;
    private final SearchPhaseController searchPhaseController;

    @Inject
    public TransportSearchScrollQueryThenFetchAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, SearchServiceTransportAction searchService, SearchPhaseController searchPhaseController) {
        super(settings);
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.searchService = searchService;
        this.searchPhaseController = searchPhaseController;
    }

    public void execute(SearchScrollRequest request, ParsedScrollId scrollId, ActionListener<SearchResponse> listener) {
        new AsyncAction(request, scrollId, listener).start();
    }

    private class AsyncAction {
        private final SearchScrollRequest request;
        private final ActionListener<SearchResponse> listener;
        private final ParsedScrollId scrollId;
        private final DiscoveryNodes nodes;
        private volatile AtomicArray<ShardSearchFailure> shardFailures;
        final AtomicArray<QuerySearchResult> queryResults;
        final AtomicArray<FetchSearchResult> fetchResults;
        private volatile ScoreDoc[] sortedShardList;
        private final AtomicInteger successfulOps;
        private final long startTime = System.currentTimeMillis();

        private AsyncAction(SearchScrollRequest request, ParsedScrollId scrollId, ActionListener<SearchResponse> listener) {
            this.request = request;
            this.listener = listener;
            this.scrollId = scrollId;
            this.nodes = TransportSearchScrollQueryThenFetchAction.this.clusterService.state().nodes();
            this.successfulOps = new AtomicInteger(scrollId.getContext().length);
            this.queryResults = new AtomicArray(scrollId.getContext().length);
            this.fetchResults = new AtomicArray(scrollId.getContext().length);
        }

        protected final ShardSearchFailure[] buildShardFailures() {
            if (this.shardFailures == null) {
                return ShardSearchFailure.EMPTY_ARRAY;
            }
            List<AtomicArray.Entry<ShardSearchFailure>> entries = this.shardFailures.asList();
            ShardSearchFailure[] failures = new ShardSearchFailure[entries.size()];
            for (int i = 0; i < failures.length; ++i) {
                failures[i] = (ShardSearchFailure)entries.get((int)i).value;
            }
            return failures;
        }

        protected final void addShardFailure(int shardIndex, ShardSearchFailure failure) {
            if (this.shardFailures == null) {
                this.shardFailures = new AtomicArray(this.scrollId.getContext().length);
            }
            this.shardFailures.set(shardIndex, failure);
        }

        public void start() {
            if (this.scrollId.getContext().length == 0) {
                this.listener.onFailure(new SearchPhaseExecutionException("query", "no nodes to search on", null));
                return;
            }
            final AtomicInteger counter = new AtomicInteger(this.scrollId.getContext().length);
            int localOperations = 0;
            Tuple<String, Long>[] context = this.scrollId.getContext();
            for (int i = 0; i < context.length; ++i) {
                Tuple<String, Long> target = context[i];
                DiscoveryNode node = this.nodes.get(target.v1());
                if (node != null) {
                    if (this.nodes.localNodeId().equals(node.id())) {
                        ++localOperations;
                        continue;
                    }
                    this.executeQueryPhase(i, counter, node, target.v2());
                    continue;
                }
                if (TransportSearchScrollQueryThenFetchAction.this.logger.isDebugEnabled()) {
                    TransportSearchScrollQueryThenFetchAction.this.logger.debug("Node [" + target.v1() + "] not available for scroll request [" + this.scrollId.getSource() + "]", new Object[0]);
                }
                this.successfulOps.decrementAndGet();
                if (counter.decrementAndGet() != 0) continue;
                this.executeFetchPhase();
            }
            if (localOperations > 0) {
                if (this.request.operationThreading() == SearchOperationThreading.SINGLE_THREAD) {
                    TransportSearchScrollQueryThenFetchAction.this.threadPool.executor("search").execute(new Runnable(){

                        @Override
                        public void run() {
                            Tuple<String, Long>[] context1 = AsyncAction.this.scrollId.getContext();
                            for (int i = 0; i < context1.length; ++i) {
                                Tuple<String, Long> target = context1[i];
                                DiscoveryNode node = AsyncAction.this.nodes.get(target.v1());
                                if (node == null || !AsyncAction.this.nodes.localNodeId().equals(node.id())) continue;
                                AsyncAction.this.executeQueryPhase(i, counter, node, target.v2());
                            }
                        }
                    });
                } else {
                    boolean localAsync = this.request.operationThreading() == SearchOperationThreading.THREAD_PER_SHARD;
                    Tuple<String, Long>[] context1 = this.scrollId.getContext();
                    for (int i = 0; i < context1.length; ++i) {
                        final Tuple<String, Long> target = context1[i];
                        final int shardIndex = i;
                        final DiscoveryNode node = this.nodes.get(target.v1());
                        if (node == null || !this.nodes.localNodeId().equals(node.id())) continue;
                        try {
                            if (localAsync) {
                                TransportSearchScrollQueryThenFetchAction.this.threadPool.executor("search").execute(new Runnable(){

                                    @Override
                                    public void run() {
                                        AsyncAction.this.executeQueryPhase(shardIndex, counter, node, (Long)target.v2());
                                    }
                                });
                                continue;
                            }
                            this.executeQueryPhase(shardIndex, counter, node, target.v2());
                            continue;
                        }
                        catch (Throwable t) {
                            this.onQueryPhaseFailure(shardIndex, counter, target.v2(), t);
                        }
                    }
                }
            }
        }

        private void executeQueryPhase(final int shardIndex, final AtomicInteger counter, DiscoveryNode node, final long searchId) {
            TransportSearchScrollQueryThenFetchAction.this.searchService.sendExecuteQuery(node, TransportSearchHelper.internalScrollSearchRequest(searchId, this.request), new SearchServiceListener<QuerySearchResult>(){

                @Override
                public void onResult(QuerySearchResult result) {
                    AsyncAction.this.queryResults.set(shardIndex, result);
                    if (counter.decrementAndGet() == 0) {
                        AsyncAction.this.executeFetchPhase();
                    }
                }

                @Override
                public void onFailure(Throwable t) {
                    AsyncAction.this.onQueryPhaseFailure(shardIndex, counter, searchId, t);
                }
            });
        }

        void onQueryPhaseFailure(int shardIndex, AtomicInteger counter, long searchId, Throwable t) {
            if (TransportSearchScrollQueryThenFetchAction.this.logger.isDebugEnabled()) {
                TransportSearchScrollQueryThenFetchAction.this.logger.debug("[{}] Failed to execute query phase", t, searchId);
            }
            this.addShardFailure(shardIndex, new ShardSearchFailure(t));
            this.successfulOps.decrementAndGet();
            if (counter.decrementAndGet() == 0) {
                this.executeFetchPhase();
            }
        }

        private void executeFetchPhase() {
            this.sortedShardList = TransportSearchScrollQueryThenFetchAction.this.searchPhaseController.sortDocs(this.queryResults);
            AtomicArray<IntArrayList> docIdsToLoad = new AtomicArray<IntArrayList>(this.queryResults.length());
            TransportSearchScrollQueryThenFetchAction.this.searchPhaseController.fillDocIdsToLoad(docIdsToLoad, this.sortedShardList);
            if (docIdsToLoad.asList().isEmpty()) {
                this.finishHim();
            }
            final AtomicInteger counter = new AtomicInteger(docIdsToLoad.asList().size());
            for (final AtomicArray.Entry<IntArrayList> entry : docIdsToLoad.asList()) {
                IntArrayList docIds = (IntArrayList)entry.value;
                final QuerySearchResult querySearchResult = this.queryResults.get(entry.index);
                FetchSearchRequest fetchSearchRequest = new FetchSearchRequest(this.request, querySearchResult.id(), docIds);
                DiscoveryNode node = this.nodes.get(querySearchResult.shardTarget().nodeId());
                TransportSearchScrollQueryThenFetchAction.this.searchService.sendExecuteFetch(node, fetchSearchRequest, new SearchServiceListener<FetchSearchResult>(){

                    @Override
                    public void onResult(FetchSearchResult result) {
                        result.shardTarget(querySearchResult.shardTarget());
                        AsyncAction.this.fetchResults.set(entry.index, result);
                        if (counter.decrementAndGet() == 0) {
                            AsyncAction.this.finishHim();
                        }
                    }

                    @Override
                    public void onFailure(Throwable t) {
                        if (TransportSearchScrollQueryThenFetchAction.this.logger.isDebugEnabled()) {
                            TransportSearchScrollQueryThenFetchAction.this.logger.debug("Failed to execute fetch phase", t, new Object[0]);
                        }
                        AsyncAction.this.successfulOps.decrementAndGet();
                        if (counter.decrementAndGet() == 0) {
                            AsyncAction.this.finishHim();
                        }
                    }
                });
            }
        }

        private void finishHim() {
            try {
                this.innerFinishHim();
            }
            catch (Throwable e) {
                this.listener.onFailure(new ReduceSearchPhaseException("fetch", "", e, this.buildShardFailures()));
            }
        }

        private void innerFinishHim() {
            InternalSearchResponse internalResponse = TransportSearchScrollQueryThenFetchAction.this.searchPhaseController.merge(this.sortedShardList, this.queryResults, this.fetchResults);
            String scrollId = null;
            if (this.request.scroll() != null) {
                scrollId = this.request.scrollId();
            }
            this.listener.onResponse(new SearchResponse(internalResponse, scrollId, this.scrollId.getContext().length, this.successfulOps.get(), System.currentTimeMillis() - this.startTime, this.buildShardFailures()));
        }
    }
}

