/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.unit;

import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.monitor.jvm.JvmInfo;

public enum MemorySizeValue {


    public static ByteSizeValue parseBytesSizeValueOrHeapRatio(String sValue) {
        if (sValue.endsWith("%")) {
            String percentAsString = sValue.substring(0, sValue.length() - 1);
            try {
                double percent = Double.parseDouble(percentAsString);
                if (percent < 0.0 || percent > 100.0) {
                    throw new ElasticsearchParseException("Percentage should be in [0-100], got " + percentAsString);
                }
                return new ByteSizeValue((long)(percent / 100.0 * (double)JvmInfo.jvmInfo().getMem().getHeapMax().bytes()), ByteSizeUnit.BYTES);
            }
            catch (NumberFormatException e) {
                throw new ElasticsearchParseException("Failed to parse [" + percentAsString + "] as a double", e);
            }
        }
        return ByteSizeValue.parseBytesSizeValue(sValue);
    }
}

