/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.collect.UnmodifiableIterator;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.util.AbstractPagedHashMap;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.DoubleArray;
import org.elasticsearch.common.util.ObjectArray;

public class DoubleObjectPagedHashMap<T>
extends AbstractPagedHashMap
implements Iterable<Cursor<T>> {
    private DoubleArray keys;
    private ObjectArray<T> values;

    public DoubleObjectPagedHashMap(BigArrays bigArrays) {
        this(16L, bigArrays);
    }

    public DoubleObjectPagedHashMap(long capacity, BigArrays bigArrays) {
        this(capacity, 0.6f, bigArrays);
    }

    public DoubleObjectPagedHashMap(long capacity, float maxLoadFactor, BigArrays bigArrays) {
        super(capacity, maxLoadFactor, bigArrays);
        this.keys = bigArrays.newDoubleArray(this.capacity(), false);
        this.values = bigArrays.newObjectArray(this.capacity());
    }

    public T get(double key) {
        long i = DoubleObjectPagedHashMap.slot(DoubleObjectPagedHashMap.hash(key), this.mask);
        T value;
        while ((value = this.values.get(i)) != null) {
            if (this.keys.get(i) == key) {
                return value;
            }
            i = DoubleObjectPagedHashMap.nextSlot(i, this.mask);
        }
        return null;
    }

    public T put(double key, T value) {
        if (this.size >= this.maxSize) {
            assert (this.size == this.maxSize);
            this.grow();
        }
        assert (this.size < this.maxSize);
        return this.set(key, value);
    }

    public T remove(double key) {
        long i = DoubleObjectPagedHashMap.slot(DoubleObjectPagedHashMap.hash(key), this.mask);
        T previous;
        while ((previous = this.values.set(i, null)) != null) {
            if (this.keys.get(i) == key) {
                --this.size;
                long j = DoubleObjectPagedHashMap.nextSlot(i, this.mask);
                while (this.used(j)) {
                    this.removeAndAdd(j);
                    j = DoubleObjectPagedHashMap.nextSlot(j, this.mask);
                }
                return previous;
            }
            this.values.set(i, previous);
            i = DoubleObjectPagedHashMap.nextSlot(i, this.mask);
        }
        return null;
    }

    private T set(double key, T value) {
        if (value == null) {
            throw new IllegalArgumentException("Null values are not supported");
        }
        long i = DoubleObjectPagedHashMap.slot(DoubleObjectPagedHashMap.hash(key), this.mask);
        while (true) {
            T previous;
            if ((previous = this.values.set(i, value)) == null) {
                this.keys.set(i, key);
                ++this.size;
                return null;
            }
            if (key == this.keys.get(i)) {
                return previous;
            }
            this.values.set(i, previous);
            i = DoubleObjectPagedHashMap.nextSlot(i, this.mask);
        }
    }

    @Override
    public Iterator<Cursor<T>> iterator() {
        return new UnmodifiableIterator<Cursor<T>>(){
            boolean cached;
            final Cursor<T> cursor = new Cursor();
            {
                this.cursor.index = -1L;
                this.cached = false;
            }

            @Override
            public boolean hasNext() {
                if (!this.cached) {
                    block2: {
                        do {
                            ++this.cursor.index;
                            if (this.cursor.index >= DoubleObjectPagedHashMap.this.capacity()) break block2;
                        } while (!DoubleObjectPagedHashMap.this.used(this.cursor.index));
                        this.cursor.key = DoubleObjectPagedHashMap.this.keys.get(this.cursor.index);
                        this.cursor.value = DoubleObjectPagedHashMap.this.values.get(this.cursor.index);
                    }
                    this.cached = true;
                }
                return this.cursor.index < DoubleObjectPagedHashMap.this.capacity();
            }

            @Override
            public Cursor<T> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.cached = false;
                return this.cursor;
            }
        };
    }

    @Override
    public boolean release() throws ElasticsearchException {
        Releasables.release(this.keys, this.values);
        return true;
    }

    @Override
    protected void resize(long capacity) {
        this.keys = this.bigArrays.resize(this.keys, capacity);
        this.values = this.bigArrays.resize(this.values, capacity);
    }

    @Override
    protected boolean used(long bucket) {
        return this.values.get(bucket) != null;
    }

    @Override
    protected void removeAndAdd(long index) {
        double key = this.keys.get(index);
        T value = this.values.set(index, null);
        --this.size;
        Object removed = this.set(key, value);
        assert (removed == null);
    }

    public static final class Cursor<T> {
        public long index;
        public double key;
        public T value;
    }
}

