/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery.local;

import java.util.HashSet;
import java.util.Queue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchIllegalStateException;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.ProcessedClusterStateUpdateTask;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodeService;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.common.base.Objects;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.internal.Nullable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.discovery.AckClusterStatePublishResponseHandler;
import org.elasticsearch.discovery.ClusterStatePublishResponseHandler;
import org.elasticsearch.discovery.Discovery;
import org.elasticsearch.discovery.DiscoveryService;
import org.elasticsearch.discovery.DiscoverySettings;
import org.elasticsearch.discovery.InitialStateDiscoveryListener;
import org.elasticsearch.node.service.NodeService;
import org.elasticsearch.transport.TransportService;

public class LocalDiscovery
extends AbstractLifecycleComponent<Discovery>
implements Discovery {
    private static final LocalDiscovery[] NO_MEMBERS = new LocalDiscovery[0];
    private final TransportService transportService;
    private final ClusterService clusterService;
    private final DiscoveryNodeService discoveryNodeService;
    private AllocationService allocationService;
    private final ClusterName clusterName;
    private final Version version;
    private final DiscoverySettings discoverySettings;
    private DiscoveryNode localNode;
    private volatile boolean master = false;
    private final AtomicBoolean initialStateSent = new AtomicBoolean();
    private final CopyOnWriteArrayList<InitialStateDiscoveryListener> initialStateListeners = new CopyOnWriteArrayList();
    private static final ConcurrentMap<ClusterName, ClusterGroup> clusterGroups = ConcurrentCollections.newConcurrentMap();

    @Inject
    public LocalDiscovery(Settings settings, ClusterName clusterName, TransportService transportService, ClusterService clusterService, DiscoveryNodeService discoveryNodeService, Version version, DiscoverySettings discoverySettings) {
        super(settings);
        this.clusterName = clusterName;
        this.clusterService = clusterService;
        this.transportService = transportService;
        this.discoveryNodeService = discoveryNodeService;
        this.version = version;
        this.discoverySettings = discoverySettings;
    }

    @Override
    public void setNodeService(@Nullable NodeService nodeService) {
    }

    @Override
    public void setAllocationService(AllocationService allocationService) {
        this.allocationService = allocationService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doStart() throws ElasticsearchException {
        ConcurrentMap<ClusterName, ClusterGroup> concurrentMap = clusterGroups;
        synchronized (concurrentMap) {
            ClusterGroup clusterGroup = (ClusterGroup)clusterGroups.get(this.clusterName);
            if (clusterGroup == null) {
                clusterGroup = new ClusterGroup();
                clusterGroups.put(this.clusterName, clusterGroup);
            }
            this.logger.debug("Connected to cluster [{}]", this.clusterName);
            this.localNode = new DiscoveryNode(this.settings.get("name"), DiscoveryService.generateNodeId(this.settings), this.transportService.boundAddress().publishAddress(), this.discoveryNodeService.buildAttributes(), this.version);
            clusterGroup.members().add(this);
            Object firstMaster = null;
            for (LocalDiscovery localDiscovery : clusterGroup.members()) {
                if (!localDiscovery.localNode().masterNode()) continue;
                firstMaster = localDiscovery;
                break;
            }
            if (firstMaster != null && firstMaster.equals(this)) {
                this.master = true;
                Object master = firstMaster;
                this.clusterService.submitStateUpdateTask("local-disco-initial_connect(master)", new ProcessedClusterStateUpdateTask((LocalDiscovery)master){
                    final /* synthetic */ LocalDiscovery val$master;
                    {
                        this.val$master = localDiscovery2;
                    }

                    @Override
                    public ClusterState execute(ClusterState currentState) {
                        DiscoveryNodes.Builder nodesBuilder = DiscoveryNodes.builder();
                        for (LocalDiscovery discovery : ((ClusterGroup)clusterGroups.get(LocalDiscovery.this.clusterName)).members()) {
                            nodesBuilder.put(discovery.localNode);
                        }
                        nodesBuilder.localNodeId(this.val$master.localNode().id()).masterNodeId(this.val$master.localNode().id());
                        ClusterBlocks.Builder blocks = ClusterBlocks.builder().blocks(currentState.blocks()).removeGlobalBlock(Discovery.NO_MASTER_BLOCK);
                        return ClusterState.builder(currentState).nodes(nodesBuilder).blocks(blocks).build();
                    }

                    @Override
                    public void onFailure(String source, Throwable t) {
                        LocalDiscovery.this.logger.error("unexpected failure during [{}]", t, source);
                    }

                    @Override
                    public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                        LocalDiscovery.this.sendInitialStateEventIfNeeded();
                    }
                });
            } else if (firstMaster != null) {
                final ClusterState masterState = ((LocalDiscovery)firstMaster).clusterService.state();
                this.clusterService.submitStateUpdateTask("local-disco(detected_master)", new ClusterStateUpdateTask(){

                    @Override
                    public ClusterState execute(ClusterState currentState) {
                        DiscoveryNodes.Builder nodesBuilder = DiscoveryNodes.builder(currentState.nodes()).put(LocalDiscovery.this.localNode).localNodeId(LocalDiscovery.this.localNode.id());
                        return ClusterState.builder(currentState).metaData(masterState.metaData()).nodes(nodesBuilder).build();
                    }

                    @Override
                    public void onFailure(String source, Throwable t) {
                        LocalDiscovery.this.logger.error("unexpected failure during [{}]", t, source);
                    }
                });
                Object master = firstMaster;
                ((LocalDiscovery)firstMaster).clusterService.submitStateUpdateTask("local-disco-receive(from node[" + this.localNode + "])", new ProcessedClusterStateUpdateTask((LocalDiscovery)master){
                    final /* synthetic */ LocalDiscovery val$master;
                    {
                        this.val$master = localDiscovery2;
                    }

                    @Override
                    public ClusterState execute(ClusterState currentState) {
                        DiscoveryNodes.Builder nodesBuilder = DiscoveryNodes.builder();
                        for (LocalDiscovery discovery : ((ClusterGroup)clusterGroups.get(LocalDiscovery.this.clusterName)).members()) {
                            nodesBuilder.put(discovery.localNode);
                        }
                        nodesBuilder.localNodeId(this.val$master.localNode().id()).masterNodeId(this.val$master.localNode().id());
                        return ClusterState.builder(currentState).nodes(nodesBuilder).build();
                    }

                    @Override
                    public void onFailure(String source, Throwable t) {
                        LocalDiscovery.this.logger.error("unexpected failure during [{}]", t, source);
                    }

                    @Override
                    public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                        LocalDiscovery.this.sendInitialStateEventIfNeeded();
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doStop() throws ElasticsearchException {
        ConcurrentMap<ClusterName, ClusterGroup> concurrentMap = clusterGroups;
        synchronized (concurrentMap) {
            ClusterGroup clusterGroup = (ClusterGroup)clusterGroups.get(this.clusterName);
            if (clusterGroup == null) {
                this.logger.warn("Illegal state, should not have an empty cluster group when stopping, I should be there at teh very least...", new Object[0]);
                return;
            }
            clusterGroup.members().remove(this);
            if (clusterGroup.members().isEmpty()) {
                clusterGroups.remove(this.clusterName);
                return;
            }
            LocalDiscovery firstMaster = null;
            for (LocalDiscovery localDiscovery : clusterGroup.members()) {
                if (!localDiscovery.localNode().masterNode()) continue;
                firstMaster = localDiscovery;
                break;
            }
            if (firstMaster != null) {
                if (this.master) {
                    firstMaster.master = true;
                }
                final HashSet<String> newMembers = Sets.newHashSet();
                for (LocalDiscovery discovery : clusterGroup.members()) {
                    newMembers.add(discovery.localNode.id());
                }
                final LocalDiscovery master = firstMaster;
                master.clusterService.submitStateUpdateTask("local-disco-update", new ClusterStateUpdateTask(){

                    @Override
                    public ClusterState execute(ClusterState currentState) {
                        DiscoveryNodes newNodes = currentState.nodes().removeDeadMembers(newMembers, master.localNode.id());
                        DiscoveryNodes.Delta delta = newNodes.delta(currentState.nodes());
                        if (delta.added()) {
                            LocalDiscovery.this.logger.warn("No new nodes should be created when a new discovery view is accepted", new Object[0]);
                        }
                        ClusterState updatedState = ClusterState.builder(currentState).nodes(newNodes).build();
                        RoutingAllocation.Result routingResult = master.allocationService.reroute(ClusterState.builder(updatedState).build());
                        return ClusterState.builder(updatedState).routingResult(routingResult).build();
                    }

                    @Override
                    public void onFailure(String source, Throwable t) {
                        LocalDiscovery.this.logger.error("unexpected failure during [{}]", t, source);
                    }
                });
            }
        }
    }

    @Override
    protected void doClose() throws ElasticsearchException {
    }

    @Override
    public DiscoveryNode localNode() {
        return this.localNode;
    }

    @Override
    public void addListener(InitialStateDiscoveryListener listener) {
        this.initialStateListeners.add(listener);
    }

    @Override
    public void removeListener(InitialStateDiscoveryListener listener) {
        this.initialStateListeners.remove(listener);
    }

    @Override
    public String nodeDescription() {
        return this.clusterName.value() + "/" + this.localNode.id();
    }

    @Override
    public void publish(ClusterState clusterState, Discovery.AckListener ackListener) {
        if (!this.master) {
            throw new ElasticsearchIllegalStateException("Shouldn't publish state when not master");
        }
        LocalDiscovery[] members = this.members();
        if (members.length > 0) {
            this.publish(members, clusterState, new AckClusterStatePublishResponseHandler(members.length - 1, ackListener));
        }
    }

    private LocalDiscovery[] members() {
        ClusterGroup clusterGroup = (ClusterGroup)clusterGroups.get(this.clusterName);
        if (clusterGroup == null) {
            return NO_MEMBERS;
        }
        Queue<LocalDiscovery> members = clusterGroup.members();
        return members.toArray(new LocalDiscovery[members.size()]);
    }

    private void publish(LocalDiscovery[] members, ClusterState clusterState, final ClusterStatePublishResponseHandler publishResponseHandler) {
        block7: {
            try {
                byte[] clusterStateBytes = ClusterState.Builder.toBytes(clusterState);
                for (final LocalDiscovery discovery : members) {
                    if (discovery.master) continue;
                    final ClusterState nodeSpecificClusterState = ClusterState.Builder.fromBytes(clusterStateBytes, discovery.localNode);
                    if (nodeSpecificClusterState.nodes().localNode() != null) {
                        discovery.clusterService.submitStateUpdateTask("local-disco-receive(from master)", new ProcessedClusterStateUpdateTask(){

                            @Override
                            public ClusterState execute(ClusterState currentState) {
                                if (nodeSpecificClusterState.version() < currentState.version() && Objects.equal(nodeSpecificClusterState.nodes().masterNodeId(), currentState.nodes().masterNodeId())) {
                                    return currentState;
                                }
                                ClusterState.Builder builder = ClusterState.builder(nodeSpecificClusterState);
                                if (nodeSpecificClusterState.routingTable().version() == currentState.routingTable().version()) {
                                    builder.routingTable(currentState.routingTable());
                                }
                                if (nodeSpecificClusterState.metaData().version() == currentState.metaData().version()) {
                                    builder.metaData(currentState.metaData());
                                }
                                return builder.build();
                            }

                            @Override
                            public void onFailure(String source, Throwable t) {
                                LocalDiscovery.this.logger.error("unexpected failure during [{}]", t, source);
                                publishResponseHandler.onFailure(discovery.localNode, t);
                            }

                            @Override
                            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                                LocalDiscovery.this.sendInitialStateEventIfNeeded();
                                publishResponseHandler.onResponse(discovery.localNode);
                            }
                        });
                        continue;
                    }
                    publishResponseHandler.onResponse(discovery.localNode);
                }
                TimeValue publishTimeout = this.discoverySettings.getPublishTimeout();
                if (publishTimeout.millis() <= 0L) break block7;
                try {
                    boolean awaited = publishResponseHandler.awaitAllNodes(publishTimeout);
                    if (!awaited) {
                        this.logger.debug("awaiting all nodes to process published state {} timed out, timeout {}", clusterState.version(), publishTimeout);
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            catch (Exception e) {
                throw new ElasticsearchIllegalStateException("Cluster state failed to serialize", e);
            }
        }
    }

    private void sendInitialStateEventIfNeeded() {
        if (this.initialStateSent.compareAndSet(false, true)) {
            for (InitialStateDiscoveryListener listener : this.initialStateListeners) {
                listener.initialStateProcessed();
            }
        }
    }

    private class ClusterGroup {
        private Queue<LocalDiscovery> members = ConcurrentCollections.newQueue();

        private ClusterGroup() {
        }

        Queue<LocalDiscovery> members() {
            return this.members;
        }
    }
}

