/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index;

import org.elasticsearch.ElasticsearchIllegalArgumentException;

public enum VersionType {
    INTERNAL(0){

        @Override
        public boolean isVersionConflict(long currentVersion, long expectedVersion) {
            if (currentVersion == -2L) {
                return false;
            }
            if (expectedVersion == 0L) {
                return false;
            }
            if (currentVersion == -1L) {
                return true;
            }
            return currentVersion != expectedVersion;
        }

        @Override
        public long updateVersion(long currentVersion, long expectedVersion) {
            return currentVersion == -2L || currentVersion == -1L ? 1L : currentVersion + 1L;
        }

        @Override
        public boolean validateVersion(long version) {
            return version > 0L || version == 0L;
        }

        @Override
        public VersionType versionTypeForReplicationAndRecovery() {
            return EXTERNAL;
        }
    }
    ,
    EXTERNAL(1){

        @Override
        public boolean isVersionConflict(long currentVersion, long expectedVersion) {
            if (currentVersion == -2L) {
                return false;
            }
            if (currentVersion == -1L) {
                return false;
            }
            if (expectedVersion == 0L) {
                return true;
            }
            return currentVersion >= expectedVersion;
        }

        @Override
        public long updateVersion(long currentVersion, long expectedVersion) {
            return expectedVersion;
        }

        @Override
        public boolean validateVersion(long version) {
            return version > 0L;
        }
    }
    ,
    EXTERNAL_GTE(2){

        @Override
        public boolean isVersionConflict(long currentVersion, long expectedVersion) {
            if (currentVersion == -2L) {
                return false;
            }
            if (currentVersion == -1L) {
                return false;
            }
            if (expectedVersion == 0L) {
                return true;
            }
            return currentVersion > expectedVersion;
        }

        @Override
        public long updateVersion(long currentVersion, long expectedVersion) {
            return expectedVersion;
        }

        @Override
        public boolean validateVersion(long version) {
            return version > 0L;
        }
    }
    ,
    FORCE(3){

        @Override
        public boolean isVersionConflict(long currentVersion, long expectedVersion) {
            if (currentVersion == -2L) {
                return false;
            }
            if (currentVersion == -1L) {
                return false;
            }
            return expectedVersion == 0L;
        }

        @Override
        public long updateVersion(long currentVersion, long expectedVersion) {
            return expectedVersion;
        }

        @Override
        public boolean validateVersion(long version) {
            return version > 0L;
        }
    };

    private final byte value;

    private VersionType(byte value) {
        this.value = value;
    }

    public byte getValue() {
        return this.value;
    }

    public abstract boolean isVersionConflict(long var1, long var3);

    public abstract long updateVersion(long var1, long var3);

    public abstract boolean validateVersion(long var1);

    public VersionType versionTypeForReplicationAndRecovery() {
        return this;
    }

    public static VersionType fromString(String versionType) {
        if ("internal".equals(versionType)) {
            return INTERNAL;
        }
        if ("external".equals(versionType)) {
            return EXTERNAL;
        }
        if ("external_gt".equals(versionType)) {
            return EXTERNAL;
        }
        if ("external_gte".equals(versionType)) {
            return EXTERNAL_GTE;
        }
        if ("force".equals(versionType)) {
            return FORCE;
        }
        throw new ElasticsearchIllegalArgumentException("No version type match [" + versionType + "]");
    }

    public static VersionType fromString(String versionType, VersionType defaultVersionType) {
        if (versionType == null) {
            return defaultVersionType;
        }
        return VersionType.fromString(versionType);
    }

    public static VersionType fromValue(byte value) {
        if (value == 0) {
            return INTERNAL;
        }
        if (value == 1) {
            return EXTERNAL;
        }
        if (value == 2) {
            return EXTERNAL_GTE;
        }
        if (value == 3) {
            return FORCE;
        }
        throw new ElasticsearchIllegalArgumentException("No version type match [" + value + "]");
    }
}

