/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.nested;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.FixedBitSet;
import org.elasticsearch.common.lucene.ReaderContextAware;
import org.elasticsearch.common.lucene.docset.DocIdSets;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.object.ObjectMapper;
import org.elasticsearch.index.search.nested.NonNestedDocsFilter;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.bucket.SingleBucketAggregator;
import org.elasticsearch.search.aggregations.bucket.nested.InternalNested;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.internal.SearchContext;

public class NestedAggregator
extends SingleBucketAggregator
implements ReaderContextAware {
    private final Aggregator parentAggregator;
    private Filter parentFilter;
    private final Filter childFilter;
    private Bits childDocs;
    private FixedBitSet parentDocs;

    public NestedAggregator(String name, AggregatorFactories factories, String nestedPath, AggregationContext aggregationContext, Aggregator parentAggregator) {
        super(name, factories, aggregationContext, parentAggregator);
        this.parentAggregator = parentAggregator;
        MapperService.SmartNameObjectMapper mapper = aggregationContext.searchContext().smartNameObjectMapper(nestedPath);
        if (mapper == null) {
            throw new AggregationExecutionException("facet nested path [" + nestedPath + "] not found");
        }
        ObjectMapper objectMapper = mapper.mapper();
        if (objectMapper == null) {
            throw new AggregationExecutionException("facet nested path [" + nestedPath + "] not found");
        }
        if (!objectMapper.nested().isNested()) {
            throw new AggregationExecutionException("facet nested path [" + nestedPath + "] is not nested");
        }
        this.childFilter = aggregationContext.searchContext().filterCache().cache(objectMapper.nestedTypeFilter());
    }

    private NestedAggregator findClosestNestedAggregator(Aggregator parent) {
        while (parent != null) {
            if (parent instanceof NestedAggregator) {
                return (NestedAggregator)parent;
            }
            parent = parent.parent();
        }
        return null;
    }

    @Override
    public void setNextReader(AtomicReaderContext reader) {
        if (this.parentFilter == null) {
            NestedAggregator closestNestedAggregator = this.findClosestNestedAggregator(this.parentAggregator);
            NonNestedDocsFilter parentFilterNotCached = closestNestedAggregator == null ? NonNestedDocsFilter.INSTANCE : closestNestedAggregator.childFilter;
            this.parentFilter = SearchContext.current().filterCache().cache(parentFilterNotCached);
        }
        try {
            DocIdSet docIdSet = this.parentFilter.getDocIdSet(reader, null);
            this.childDocs = DocIdSets.toSafeBits(reader.reader(), this.childFilter.getDocIdSet(reader, null));
            this.parentDocs = DocIdSets.isEmpty(docIdSet) ? null : (FixedBitSet)docIdSet;
        }
        catch (IOException ioe) {
            throw new AggregationExecutionException("Failed to aggregate [" + this.name + "]", ioe);
        }
    }

    @Override
    public void collect(int parentDoc, long bucketOrd) throws IOException {
        if (parentDoc == 0 || this.parentDocs == null) {
            return;
        }
        int prevParentDoc = this.parentDocs.prevSetBit(parentDoc - 1);
        int numChildren = 0;
        for (int i = parentDoc - 1; i > prevParentDoc; --i) {
            if (!this.childDocs.get(i)) continue;
            ++numChildren;
            this.collectBucketNoCounts(i, bucketOrd);
        }
        this.incrementBucketDocCount(numChildren, bucketOrd);
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) {
        return new InternalNested(this.name, this.bucketDocCount(owningBucketOrdinal), this.bucketAggregations(owningBucketOrdinal));
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new InternalNested(this.name, 0L, this.buildEmptySubAggregations());
    }

    public static class Factory
    extends AggregatorFactory {
        private final String path;

        public Factory(String name, String path) {
            super(name, InternalNested.TYPE.name());
            this.path = path;
        }

        @Override
        public Aggregator create(AggregationContext context, Aggregator parent, long expectedBucketsCount) {
            return new NestedAggregator(this.name, this.factories, this.path, context, parent);
        }
    }
}

