/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.range;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.util.InPlaceMergeSorter;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.index.fielddata.DoubleValues;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.bucket.BucketsAggregator;
import org.elasticsearch.search.aggregations.bucket.range.InternalRange;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValueSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.numeric.NumericValuesSource;
import org.elasticsearch.search.aggregations.support.numeric.ValueFormatter;
import org.elasticsearch.search.aggregations.support.numeric.ValueParser;

public class RangeAggregator
extends BucketsAggregator {
    private final NumericValuesSource valuesSource;
    private final Range[] ranges;
    private final boolean keyed;
    private final InternalRange.Factory rangeFactory;
    private DoubleValues values;
    final double[] maxTo;

    public RangeAggregator(String name, AggregatorFactories factories, NumericValuesSource valuesSource, InternalRange.Factory rangeFactory, List<Range> ranges, boolean keyed, AggregationContext aggregationContext, Aggregator parent) {
        super(name, Aggregator.BucketAggregationMode.MULTI_BUCKETS, factories, (long)ranges.size() * (parent == null ? 1L : parent.estimatedBucketCount()), aggregationContext, parent);
        int i;
        assert (valuesSource != null);
        this.valuesSource = valuesSource;
        this.keyed = keyed;
        this.rangeFactory = rangeFactory;
        this.ranges = ranges.toArray(new Range[ranges.size()]);
        for (i = 0; i < this.ranges.length; ++i) {
            this.ranges[i].process(valuesSource.parser(), this.context);
        }
        RangeAggregator.sortRanges(this.ranges);
        this.maxTo = new double[this.ranges.length];
        this.maxTo[0] = this.ranges[0].to;
        for (i = 1; i < this.ranges.length; ++i) {
            this.maxTo[i] = Math.max(this.ranges[i].to, this.maxTo[i - 1]);
        }
    }

    @Override
    public boolean shouldCollect() {
        return true;
    }

    @Override
    public void setNextReader(AtomicReaderContext reader) {
        this.values = this.valuesSource.doubleValues();
    }

    private final long subBucketOrdinal(long owningBucketOrdinal, int rangeOrd) {
        return owningBucketOrdinal * (long)this.ranges.length + (long)rangeOrd;
    }

    @Override
    public void collect(int doc, long owningBucketOrdinal) throws IOException {
        int valuesCount = this.values.setDocument(doc);
        int lo = 0;
        for (int i = 0; i < valuesCount; ++i) {
            double value = this.values.nextValue();
            lo = this.collect(doc, value, owningBucketOrdinal, lo);
        }
    }

    private int collect(int doc, double value, long owningBucketOrdinal, int lowBound) throws IOException {
        int lo = lowBound;
        int hi = this.ranges.length - 1;
        int mid = lo + hi >>> 1;
        while (lo <= hi) {
            if (value < this.ranges[mid].from) {
                hi = mid - 1;
            } else {
                if (!(value >= this.maxTo[mid])) break;
                lo = mid + 1;
            }
            mid = lo + hi >>> 1;
        }
        if (lo > hi) {
            return lo;
        }
        int startLo = lo;
        int startHi = mid;
        while (startLo <= startHi) {
            int startMid = startLo + startHi >>> 1;
            if (value >= this.maxTo[startMid]) {
                startLo = startMid + 1;
                continue;
            }
            startHi = startMid - 1;
        }
        int endLo = mid;
        int endHi = hi;
        while (endLo <= endHi) {
            int endMid = endLo + endHi >>> 1;
            if (value < this.ranges[endMid].from) {
                endHi = endMid - 1;
                continue;
            }
            endLo = endMid + 1;
        }
        assert (startLo == lowBound || value >= this.maxTo[startLo - 1]);
        assert (endHi == this.ranges.length - 1 || value < this.ranges[endHi + 1].from);
        for (int i = startLo; i <= endHi; ++i) {
            if (!this.ranges[i].matches(value)) continue;
            this.collectBucket(doc, this.subBucketOrdinal(owningBucketOrdinal, i));
        }
        return endHi + 1;
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) {
        ArrayList buckets = Lists.newArrayListWithCapacity(this.ranges.length);
        for (int i = 0; i < this.ranges.length; ++i) {
            Range range = this.ranges[i];
            long bucketOrd = this.subBucketOrdinal(owningBucketOrdinal, i);
            Object bucket = this.rangeFactory.createBucket(range.key, range.from, range.to, this.bucketDocCount(bucketOrd), this.bucketAggregations(bucketOrd), this.valuesSource.formatter());
            buckets.add(bucket);
        }
        ValueFormatter formatter = this.valuesSource != null ? this.valuesSource.formatter() : null;
        return this.rangeFactory.create(this.name, buckets, formatter, this.keyed, false);
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        InternalAggregations subAggs = this.buildEmptySubAggregations();
        ArrayList buckets = Lists.newArrayListWithCapacity(this.ranges.length);
        for (int i = 0; i < this.ranges.length; ++i) {
            Range range = this.ranges[i];
            Object bucket = this.rangeFactory.createBucket(range.key, range.from, range.to, 0L, subAggs, this.valuesSource.formatter());
            buckets.add(bucket);
        }
        ValueFormatter formatter = this.valuesSource != null ? this.valuesSource.formatter() : null;
        return this.rangeFactory.create(this.name, buckets, formatter, this.keyed, false);
    }

    private static final void sortRanges(final Range[] ranges) {
        new InPlaceMergeSorter(){

            protected void swap(int i, int j) {
                Range tmp = ranges[i];
                ranges[i] = ranges[j];
                ranges[j] = tmp;
            }

            protected int compare(int i, int j) {
                int cmp = Double.compare(ranges[i].from, ranges[j].from);
                if (cmp == 0) {
                    cmp = Double.compare(ranges[i].to, ranges[j].to);
                }
                return cmp;
            }
        }.sort(0, ranges.length);
    }

    public static class Factory
    extends ValueSourceAggregatorFactory<NumericValuesSource> {
        private final InternalRange.Factory rangeFactory;
        private final List<Range> ranges;
        private final boolean keyed;

        public Factory(String name, ValuesSourceConfig<NumericValuesSource> valueSourceConfig, InternalRange.Factory rangeFactory, List<Range> ranges, boolean keyed) {
            super(name, rangeFactory.type(), valueSourceConfig);
            this.rangeFactory = rangeFactory;
            this.ranges = ranges;
            this.keyed = keyed;
        }

        @Override
        protected Aggregator createUnmapped(AggregationContext aggregationContext, Aggregator parent) {
            return new Unmapped(this.name, this.ranges, this.keyed, this.valuesSourceConfig.formatter(), this.valuesSourceConfig.parser(), aggregationContext, parent, this.rangeFactory);
        }

        @Override
        protected Aggregator create(NumericValuesSource valuesSource, long expectedBucketsCount, AggregationContext aggregationContext, Aggregator parent) {
            return new RangeAggregator(this.name, this.factories, valuesSource, this.rangeFactory, this.ranges, this.keyed, aggregationContext, parent);
        }
    }

    public static class Unmapped
    extends Aggregator {
        private final List<Range> ranges;
        private final boolean keyed;
        private final InternalRange.Factory factory;
        private final ValueFormatter formatter;
        private final ValueParser parser;

        public Unmapped(String name, List<Range> ranges, boolean keyed, ValueFormatter formatter, ValueParser parser, AggregationContext aggregationContext, Aggregator parent, InternalRange.Factory factory) {
            super(name, Aggregator.BucketAggregationMode.MULTI_BUCKETS, AggregatorFactories.EMPTY, 0L, aggregationContext, parent);
            this.ranges = ranges;
            for (Range range : this.ranges) {
                range.process(parser, this.context);
            }
            this.keyed = keyed;
            this.formatter = formatter;
            this.parser = parser;
            this.factory = factory;
        }

        @Override
        public boolean shouldCollect() {
            return false;
        }

        @Override
        public void setNextReader(AtomicReaderContext reader) {
        }

        @Override
        public void collect(int doc, long owningBucketOrdinal) throws IOException {
        }

        @Override
        public InternalRange buildAggregation(long owningBucketOrdinal) {
            return this.buildEmptyAggregation();
        }

        @Override
        public InternalRange buildEmptyAggregation() {
            InternalAggregations subAggs = this.buildEmptySubAggregations();
            ArrayList buckets = new ArrayList(this.ranges.size());
            for (Range range : this.ranges) {
                buckets.add(this.factory.createBucket(range.key, range.from, range.to, 0L, subAggs, this.formatter));
            }
            return this.factory.create(this.name, buckets, this.formatter, this.keyed, true);
        }
    }

    public static class Range {
        public String key;
        public double from = Double.NEGATIVE_INFINITY;
        String fromAsStr;
        public double to = Double.POSITIVE_INFINITY;
        String toAsStr;

        public Range(String key, double from, String fromAsStr, double to, String toAsStr) {
            this.key = key;
            this.from = from;
            this.fromAsStr = fromAsStr;
            this.to = to;
            this.toAsStr = toAsStr;
        }

        boolean matches(double value) {
            return value >= this.from && value < this.to;
        }

        public String toString() {
            return "[" + this.from + " to " + this.to + ")";
        }

        public void process(ValueParser parser, AggregationContext aggregationContext) {
            if (this.fromAsStr != null) {
                double d = this.from = parser != null ? parser.parseDouble(this.fromAsStr, aggregationContext.searchContext()) : Double.valueOf(this.fromAsStr).doubleValue();
            }
            if (this.toAsStr != null) {
                this.to = parser != null ? parser.parseDouble(this.toAsStr, aggregationContext.searchContext()) : Double.valueOf(this.toAsStr).doubleValue();
            }
        }
    }
}

