/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics.percentiles;

import java.io.IOException;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.util.ArrayUtils;
import org.elasticsearch.search.aggregations.metrics.percentiles.tdigest.TDigest;
import org.elasticsearch.search.aggregations.support.AggregationContext;

public abstract class PercentilesEstimator
implements Releasable {
    protected double[] percents;

    public PercentilesEstimator(double[] percents) {
        this.percents = percents;
    }

    public double[] percents() {
        return this.percents;
    }

    public abstract void offer(double var1, long var3);

    public abstract Result result(long var1);

    public abstract Result emptyResult();

    static int indexOfPercent(double[] percents, double percent) {
        return ArrayUtils.binarySearch(percents, percent, 0.001);
    }

    static class Streams {
        Streams() {
        }

        static Result read(StreamInput in) throws IOException {
            switch (in.readByte()) {
                case 0: {
                    return TDigest.Result.read(in);
                }
            }
            throw new ElasticsearchIllegalArgumentException("Unknown percentile estimator");
        }

        static void write(Result estimator, StreamOutput out) throws IOException {
            out.writeByte(estimator.id());
            estimator.writeTo(out);
        }
    }

    public static interface Factory<E extends PercentilesEstimator> {
        public E create(double[] var1, long var2, AggregationContext var4);
    }

    public static abstract class Result<E extends PercentilesEstimator, F extends Result>
    implements Streamable {
        protected double[] percents;

        protected Result() {
        }

        protected Result(double[] percents) {
            this.percents = percents;
        }

        protected abstract byte id();

        public double estimate(double percent) {
            int i = PercentilesEstimator.indexOfPercent(this.percents, percent);
            assert (i >= 0);
            return this.estimate(i);
        }

        public abstract double estimate(int var1);

        public abstract Merger<E, F> merger(int var1);

        public static interface Merger<E extends PercentilesEstimator, F extends Result> {
            public void add(F var1);

            public Result merge();
        }
    }
}

