/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.collections.core.listener;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.collections.api.CollectionManager;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.runtime.api.Framework;

public class DuplicatedCollectionListener
implements EventListener {
    private static final Log log = LogFactory.getLog(DuplicatedCollectionListener.class);

    public void handleEvent(Event event) throws ClientException {
        EventContext ctx = event.getContext();
        if (!(ctx instanceof DocumentEventContext)) {
            return;
        }
        String eventId = event.getName();
        if (!eventId.equals("documentCreatedByCopy")) {
            return;
        }
        DocumentEventContext docCxt = (DocumentEventContext)event.getContext();
        DocumentModel doc = docCxt.getSourceDocument();
        CollectionManager collectionManager = (CollectionManager)Framework.getLocalService(CollectionManager.class);
        if (collectionManager.isCollection(doc)) {
            log.trace((Object)String.format("Collection %s copied", doc.getId()));
            collectionManager.processCopiedCollection(doc);
        }
    }
}

