/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.core.impl;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.impl.blob.StreamingBlob;
import org.nuxeo.ecm.core.api.pathsegment.PathSegmentService;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.impl.ACLImpl;
import org.nuxeo.ecm.core.event.EventProducer;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.query.sql.NXQL;
import org.nuxeo.ecm.core.repository.RepositoryInitializationHandler;
import org.nuxeo.ecm.platform.filemanager.api.FileManager;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.ecm.platform.routing.api.DocumentRoute;
import org.nuxeo.ecm.platform.routing.api.DocumentRouteElement;
import org.nuxeo.ecm.platform.routing.api.DocumentRouteTableElement;
import org.nuxeo.ecm.platform.routing.api.DocumentRoutingConstants;
import org.nuxeo.ecm.platform.routing.api.DocumentRoutingPersister;
import org.nuxeo.ecm.platform.routing.api.DocumentRoutingService;
import org.nuxeo.ecm.platform.routing.api.LockableDocumentRoute;
import org.nuxeo.ecm.platform.routing.api.RouteFolderElement;
import org.nuxeo.ecm.platform.routing.api.RouteModelResourceType;
import org.nuxeo.ecm.platform.routing.api.RouteTable;
import org.nuxeo.ecm.platform.routing.api.exception.DocumentRouteAlredayLockedException;
import org.nuxeo.ecm.platform.routing.api.exception.DocumentRouteException;
import org.nuxeo.ecm.platform.routing.api.exception.DocumentRouteNotLockedException;
import org.nuxeo.ecm.platform.routing.core.api.DocumentRoutingEngineService;
import org.nuxeo.ecm.platform.routing.core.impl.ChainToTypeMappingDescriptor;
import org.nuxeo.ecm.platform.routing.core.impl.GraphNode;
import org.nuxeo.ecm.platform.routing.core.impl.GraphRoute;
import org.nuxeo.ecm.platform.routing.core.impl.PersisterDescriptor;
import org.nuxeo.ecm.platform.routing.core.listener.RouteModelsInitializator;
import org.nuxeo.ecm.platform.routing.core.registries.RouteTemplateResourceRegistry;
import org.nuxeo.ecm.platform.task.Task;
import org.nuxeo.ecm.platform.task.TaskService;
import org.nuxeo.ecm.platform.task.core.service.TaskEventNotificationHelper;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.model.RuntimeContext;

public class DocumentRoutingServiceImpl
extends DefaultComponent
implements DocumentRoutingService {
    private static Log log = LogFactory.getLog(DocumentRoutingServiceImpl.class);
    private static final String AVAILABLE_ROUTES_QUERY = String.format("SELECT * FROM %s", "DocumentRoute");
    private static final String ROUTE_MODEL_WITH_ID_QUERY = String.format("SELECT * FROM %s WHERE ecm:name = %%s AND ecm:currentLifeCycleState = 'validated' AND ecm:isCheckedInVersion  = 0  AND ecm:isProxy = 0 ", "DocumentRoute");
    private static final String ROUTE_MODEL_DOC_ID_WITH_ID_QUERY = String.format("SELECT ecm:uuid FROM %s WHERE ecm:name = %%s AND ecm:currentLifeCycleState = 'validated' AND ecm:isCheckedInVersion  = 0  AND ecm:isProxy = 0 ", "DocumentRoute");
    private static final String ORDERED_CHILDREN_QUERY = "SELECT * FROM Document WHERE ecm:parentId = '%s' AND ecm:isCheckedInVersion  = 0 AND ecm:currentLifeCycleState != 'deleted' ORDER BY ecm:pos";
    public static final String CHAINS_TO_TYPE_XP = "chainsToType";
    public static final String PERSISTER_XP = "persister";
    public static final String ROUTE_MODELS_IMPORTER_XP = "routeModelImporter";
    protected Map<String, String> typeToChain = new HashMap<String, String>();
    protected Map<String, String> undoChainIdFromRunning = new HashMap<String, String>();
    protected Map<String, String> undoChainIdFromDone = new HashMap<String, String>();
    protected DocumentRoutingPersister persister;
    protected RouteTemplateResourceRegistry routeResourcesRegistry = new RouteTemplateResourceRegistry();
    protected RepositoryInitializationHandler repositoryInitializationHandler;
    private Cache<String, String> modelsChache;

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (CHAINS_TO_TYPE_XP.equals(extensionPoint)) {
            ChainToTypeMappingDescriptor desc = (ChainToTypeMappingDescriptor)contribution;
            this.typeToChain.put(desc.getDocumentType(), desc.getChainId());
            this.undoChainIdFromRunning.put(desc.getDocumentType(), desc.getUndoChainIdFromRunning());
            this.undoChainIdFromDone.put(desc.getDocumentType(), desc.getUndoChainIdFromDone());
        } else if (PERSISTER_XP.equals(extensionPoint)) {
            PersisterDescriptor des = (PersisterDescriptor)contribution;
            this.persister = des.getKlass().newInstance();
        } else if (ROUTE_MODELS_IMPORTER_XP.equals(extensionPoint)) {
            RouteModelResourceType res = (RouteModelResourceType)contribution;
            this.registerRouteResource(res, contributor.getRuntimeContext());
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (contribution instanceof RouteModelResourceType) {
            this.routeResourcesRegistry.removeContribution((RouteModelResourceType)contribution);
        }
        super.unregisterContribution(contribution, extensionPoint, contributor);
    }

    protected static void fireEvent(String eventName, Map<String, Serializable> eventProperties, DocumentRoute route, CoreSession session) {
        eventProperties.put("documentElementEventContextKey", (Serializable)route);
        eventProperties.put("category", (Serializable)((Object)"Routing"));
        DocumentEventContext envContext = new DocumentEventContext(session, session.getPrincipal(), route.getDocument());
        envContext.setProperties(eventProperties);
        EventProducer eventProducer = (EventProducer)Framework.getLocalService(EventProducer.class);
        try {
            eventProducer.fireEvent(envContext.newEvent(eventName));
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    public String createNewInstance(final String routeModelId, final List<String> docIds, final Map<String, Serializable> map, CoreSession session, final boolean startInstance) {
        try {
            final String initiator = session.getPrincipal().getName();
            final String[] res = new String[1];
            new UnrestrictedSessionRunner(session){
                protected DocumentRoute route;

                public void run() throws ClientException {
                    String routeDocId = DocumentRoutingServiceImpl.this.getRouteModelDocIdWithId(this.session, routeModelId);
                    DocumentModel model = this.session.getDocument((DocumentRef)new IdRef(routeDocId));
                    DocumentModel instance = DocumentRoutingServiceImpl.this.persister.createDocumentRouteInstanceFromDocumentRouteModel(model, this.session);
                    this.route = (DocumentRoute)instance.getAdapter(DocumentRoute.class);
                    this.route.setAttachedDocuments(docIds);
                    this.route.save(this.session);
                    HashMap<String, Serializable> props = new HashMap<String, Serializable>();
                    props.put("initiator", (Serializable)((Object)initiator));
                    this.fireEvent(DocumentRoutingConstants.Events.beforeRouteReady.name(), props);
                    this.route.setReady(this.session);
                    this.fireEvent(DocumentRoutingConstants.Events.afterRouteReady.name(), props);
                    this.route.save(this.session);
                    if (startInstance) {
                        this.fireEvent(DocumentRoutingConstants.Events.beforeRouteStart.name(), new HashMap<String, Serializable>());
                        DocumentRoutingEngineService routingEngine = (DocumentRoutingEngineService)Framework.getLocalService(DocumentRoutingEngineService.class);
                        routingEngine.start(this.route, map, this.session);
                    }
                    res[0] = instance.getId();
                }

                protected void fireEvent(String eventName, Map<String, Serializable> eventProperties) {
                    DocumentRoutingServiceImpl.fireEvent(eventName, eventProperties, this.route, this.session);
                }
            }.runUnrestricted();
            return res[0];
        }
        catch (ClientException e) {
            throw new RuntimeException(e);
        }
    }

    public String createNewInstance(String routeModelId, List<String> docIds, CoreSession session, boolean startInstance) {
        return this.createNewInstance(routeModelId, docIds, null, session, startInstance);
    }

    public DocumentRoute createNewInstance(DocumentRoute model, List<String> docIds, CoreSession session, boolean startInstance) {
        String id = this.createNewInstance(model.getDocument().getName(), docIds, session, startInstance);
        try {
            return (DocumentRoute)session.getDocument((DocumentRef)new IdRef(id)).getAdapter(DocumentRoute.class);
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    @Deprecated
    public DocumentRoute createNewInstance(DocumentRoute model, String documentId, CoreSession session, boolean startInstance) {
        return this.createNewInstance(model, Collections.singletonList(documentId), session, startInstance);
    }

    @Deprecated
    public DocumentRoute createNewInstance(DocumentRoute model, List<String> documentIds, CoreSession session) {
        return this.createNewInstance(model, documentIds, session, true);
    }

    @Deprecated
    public DocumentRoute createNewInstance(DocumentRoute model, String documentId, CoreSession session) {
        return this.createNewInstance(model, Collections.singletonList(documentId), session, true);
    }

    public void startInstance(final String routeInstanceId, final List<String> docIds, final Map<String, Serializable> map, CoreSession session) {
        try {
            new UnrestrictedSessionRunner(session){

                public void run() throws ClientException {
                    DocumentModel instance = this.session.getDocument((DocumentRef)new IdRef(routeInstanceId));
                    DocumentRoute route = (DocumentRoute)instance.getAdapter(DocumentRoute.class);
                    if (docIds != null) {
                        route.setAttachedDocuments(docIds);
                        route.save(this.session);
                    }
                    DocumentRoutingServiceImpl.fireEvent(DocumentRoutingConstants.Events.beforeRouteStart.name(), new HashMap<String, Serializable>(), route, this.session);
                    DocumentRoutingEngineService routingEngine = (DocumentRoutingEngineService)Framework.getLocalService(DocumentRoutingEngineService.class);
                    routingEngine.start(route, map, this.session);
                }
            }.runUnrestricted();
        }
        catch (ClientException e) {
            throw new RuntimeException(e);
        }
    }

    public void resumeInstance(String routeId, String nodeId, Map<String, Object> data, String status, CoreSession session) {
        this.completeTask(routeId, nodeId, null, data, status, session);
    }

    public void completeTask(String routeId, String taskId, Map<String, Object> data, String status, CoreSession session) {
        this.completeTask(routeId, null, taskId, data, status, session);
    }

    protected void completeTask(final String routeId, final String nodeId, final String taskId, final Map<String, Object> data, final String status, CoreSession session) {
        try {
            new UnrestrictedSessionRunner(session){

                public void run() throws ClientException {
                    DocumentRoutingEngineService routingEngine = (DocumentRoutingEngineService)Framework.getLocalService(DocumentRoutingEngineService.class);
                    DocumentModel routeDoc = this.session.getDocument((DocumentRef)new IdRef(routeId));
                    DocumentRoute routeInstance = (DocumentRoute)routeDoc.getAdapter(DocumentRoute.class);
                    routingEngine.resume(routeInstance, nodeId, taskId, data, status, this.session);
                }
            }.runUnrestricted();
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    public List<DocumentRoute> getAvailableDocumentRouteModel(CoreSession session) {
        DocumentModelList list = null;
        try {
            list = session.query(AVAILABLE_ROUTES_QUERY);
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
        ArrayList<DocumentRoute> routes = new ArrayList<DocumentRoute>();
        for (DocumentModel model : list) {
            routes.add((DocumentRoute)model.getAdapter(DocumentRoute.class));
        }
        return routes;
    }

    public String getOperationChainId(String documentType) {
        return this.typeToChain.get(documentType);
    }

    public String getUndoFromRunningOperationChainId(String documentType) {
        return this.undoChainIdFromRunning.get(documentType);
    }

    public String getUndoFromDoneOperationChainId(String documentType) {
        return this.undoChainIdFromDone.get(documentType);
    }

    public DocumentRoute unlockDocumentRouteUnrestrictedSession(final DocumentRoute routeModel, CoreSession userSession) throws ClientException {
        new UnrestrictedSessionRunner(userSession){

            public void run() throws ClientException {
                DocumentRoute route = (DocumentRoute)this.session.getDocument(routeModel.getDocument().getRef()).getAdapter(DocumentRoute.class);
                LockableDocumentRoute lockableRoute = (LockableDocumentRoute)route.getDocument().getAdapter(LockableDocumentRoute.class);
                lockableRoute.unlockDocument(this.session);
            }
        }.runUnrestricted();
        return (DocumentRoute)userSession.getDocument(routeModel.getDocument().getRef()).getAdapter(DocumentRoute.class);
    }

    public DocumentRoute validateRouteModel(final DocumentRoute routeModel, CoreSession userSession) throws DocumentRouteNotLockedException, ClientException {
        if (!routeModel.getDocument().isLocked()) {
            throw new DocumentRouteNotLockedException();
        }
        new UnrestrictedSessionRunner(userSession){

            public void run() throws ClientException {
                DocumentRoute route = (DocumentRoute)this.session.getDocument(routeModel.getDocument().getRef()).getAdapter(DocumentRoute.class);
                route.validate(this.session);
            }
        }.runUnrestricted();
        return (DocumentRoute)userSession.getDocument(routeModel.getDocument().getRef()).getAdapter(DocumentRoute.class);
    }

    @Deprecated
    public List<DocumentRouteTableElement> getRouteElements(DocumentRoute route, CoreSession session) {
        RouteTable table = new RouteTable(route);
        ArrayList<DocumentRouteTableElement> elements = new ArrayList<DocumentRouteTableElement>();
        this.processElementsInFolder(route.getDocument(), elements, table, session, 0, null);
        int maxDepth = 0;
        for (DocumentRouteTableElement element : elements) {
            int d = element.getDepth();
            maxDepth = d > maxDepth ? d : maxDepth;
        }
        table.setMaxDepth(maxDepth);
        for (DocumentRouteTableElement element : elements) {
            element.computeFirstChildList();
        }
        return elements;
    }

    @Deprecated
    protected void processElementsInFolder(DocumentModel doc, List<DocumentRouteTableElement> elements, RouteTable table, CoreSession session, int depth, RouteFolderElement folder) {
        try {
            DocumentModelList children = session.getChildren(doc.getRef());
            boolean first = true;
            for (DocumentModel child : children) {
                if (child.isFolder() && !session.getChildren(child.getRef()).isEmpty()) {
                    RouteFolderElement thisFolder = new RouteFolderElement((DocumentRouteElement)child.getAdapter(DocumentRouteElement.class), table, first, folder, depth);
                    this.processElementsInFolder(child, elements, table, session, depth + 1, thisFolder);
                } else {
                    if (folder != null) {
                        folder.increaseTotalChildCount();
                    } else {
                        table.increaseTotalChildCount();
                    }
                    elements.add(new DocumentRouteTableElement((DocumentRouteElement)child.getAdapter(DocumentRouteElement.class), table, depth, folder, first));
                }
                first = false;
            }
        }
        catch (ClientException e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    protected List<DocumentRouteTableElement> getRouteElements(DocumentRouteElement routeElementDocument, CoreSession session, List<DocumentRouteTableElement> routeElements, int depth) {
        return null;
    }

    public List<DocumentRoute> getDocumentRoutesForAttachedDocument(CoreSession session, String attachedDocId) {
        ArrayList<DocumentRouteElement.ElementLifeCycleState> states = new ArrayList<DocumentRouteElement.ElementLifeCycleState>();
        states.add(DocumentRouteElement.ElementLifeCycleState.ready);
        states.add(DocumentRouteElement.ElementLifeCycleState.running);
        return this.getDocumentRoutesForAttachedDocument(session, attachedDocId, states);
    }

    public List<DocumentRoute> getDocumentRoutesForAttachedDocument(CoreSession session, String attachedDocId, List<DocumentRouteElement.ElementLifeCycleState> states) {
        DocumentModelList list = null;
        StringBuilder statesString = new StringBuilder();
        if (states != null && !states.isEmpty()) {
            statesString.append(" ecm:currentLifeCycleState IN (");
            for (DocumentRouteElement.ElementLifeCycleState state : states) {
                statesString.append("'" + state.name() + "',");
            }
            statesString.deleteCharAt(statesString.length() - 1);
            statesString.append(") AND");
        }
        String query = String.format("SELECT * FROM DocumentRoute WHERE " + statesString.toString() + " docri:participatingDocuments = '%s'" + " ORDER BY dc:created", attachedDocId);
        try {
            UnrestrictedQueryRunner queryRunner = new UnrestrictedQueryRunner(session, query);
            list = queryRunner.runQuery();
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
        ArrayList<DocumentRoute> routes = new ArrayList<DocumentRoute>();
        for (DocumentModel model : list) {
            routes.add((DocumentRoute)model.getAdapter(DocumentRoute.class));
        }
        return routes;
    }

    public boolean canUserValidateRoute(NuxeoPrincipal currentUser) {
        return currentUser.getGroups().contains("routeManagers");
    }

    public boolean canValidateRoute(DocumentModel documentRoute, CoreSession coreSession) throws ClientException {
        if (!coreSession.hasChildren(documentRoute.getRef())) {
            return false;
        }
        return coreSession.hasPermission(documentRoute.getRef(), "Everything");
    }

    @Deprecated
    public void addRouteElementToRoute(DocumentRef parentDocumentRef, int idx, DocumentRouteElement routeElement, CoreSession session) throws DocumentRouteNotLockedException, ClientException {
        DocumentRoute route = this.getParentRouteModel(parentDocumentRef, session);
        if (!this.isLockedByCurrentUser(route, session)) {
            throw new DocumentRouteNotLockedException();
        }
        DocumentModelList children = session.query(String.format(ORDERED_CHILDREN_QUERY, session.getDocument(parentDocumentRef).getId()));
        try {
            DocumentModel sourceDoc = (DocumentModel)children.get(idx);
            this.addRouteElementToRoute(parentDocumentRef, sourceDoc.getName(), routeElement, session);
        }
        catch (IndexOutOfBoundsException e) {
            this.addRouteElementToRoute(parentDocumentRef, null, routeElement, session);
        }
    }

    @Deprecated
    public void addRouteElementToRoute(DocumentRef parentDocumentRef, String sourceName, DocumentRouteElement routeElement, CoreSession session) throws DocumentRouteNotLockedException, ClientException {
        PathSegmentService pss;
        DocumentRoute parentRoute = this.getParentRouteModel(parentDocumentRef, session);
        if (!this.isLockedByCurrentUser(parentRoute, session)) {
            throw new DocumentRouteNotLockedException();
        }
        try {
            pss = (PathSegmentService)Framework.getService(PathSegmentService.class);
        }
        catch (Exception e) {
            throw new ClientRuntimeException((Throwable)e);
        }
        DocumentModel docRouteElement = routeElement.getDocument();
        DocumentModel parentDocument = session.getDocument(parentDocumentRef);
        docRouteElement.setPathInfo(parentDocument.getPathAsString(), pss.generatePathSegment(docRouteElement));
        String lifecycleState = parentDocument.getCurrentLifeCycleState().equals(DocumentRouteElement.ElementLifeCycleState.draft.name()) ? DocumentRouteElement.ElementLifeCycleState.draft.name() : DocumentRouteElement.ElementLifeCycleState.ready.name();
        docRouteElement.putContextData("initialLifecycleState", (Serializable)((Object)lifecycleState));
        docRouteElement = session.createDocument(docRouteElement);
        session.orderBefore(parentDocumentRef, docRouteElement.getName(), sourceName);
        session.save();
    }

    public void removeRouteElement(DocumentRouteElement routeElement, CoreSession session) throws DocumentRouteNotLockedException, ClientException {
        DocumentRoute parentRoute = routeElement.getDocumentRoute(session);
        if (!this.isLockedByCurrentUser(parentRoute, session)) {
            throw new DocumentRouteNotLockedException();
        }
        session.removeDocument(routeElement.getDocument().getRef());
        session.save();
    }

    public DocumentModelList getOrderedRouteElement(String routeElementId, CoreSession session) throws ClientException {
        String query = String.format(ORDERED_CHILDREN_QUERY, routeElementId);
        DocumentModelList orderedChildren = session.query(query);
        return orderedChildren;
    }

    public void lockDocumentRoute(DocumentRoute routeModel, CoreSession session) throws DocumentRouteAlredayLockedException, ClientException {
        LockableDocumentRoute lockableRoute = (LockableDocumentRoute)routeModel.getDocument().getAdapter(LockableDocumentRoute.class);
        boolean lockedByCurrent = this.isLockedByCurrentUser(routeModel, session);
        if (lockableRoute.isLocked(session) && !lockedByCurrent) {
            throw new DocumentRouteAlredayLockedException();
        }
        if (!lockedByCurrent) {
            lockableRoute.lockDocument(session);
        }
    }

    public void unlockDocumentRoute(DocumentRoute routeModel, CoreSession session) throws DocumentRouteNotLockedException, ClientException {
        LockableDocumentRoute lockableRoute = (LockableDocumentRoute)routeModel.getDocument().getAdapter(LockableDocumentRoute.class);
        if (!lockableRoute.isLockedByCurrentUser(session)) {
            throw new DocumentRouteNotLockedException();
        }
        lockableRoute.unlockDocument(session);
    }

    public boolean isLockedByCurrentUser(DocumentRoute routeModel, CoreSession session) throws ClientException {
        LockableDocumentRoute lockableRoute = (LockableDocumentRoute)routeModel.getDocument().getAdapter(LockableDocumentRoute.class);
        return lockableRoute.isLockedByCurrentUser(session);
    }

    public void updateRouteElement(DocumentRouteElement routeElement, CoreSession session) throws DocumentRouteNotLockedException, ClientException {
        if (!this.isLockedByCurrentUser(routeElement.getDocumentRoute(session), session)) {
            throw new DocumentRouteNotLockedException();
        }
        routeElement.save(session);
    }

    private DocumentRoute getParentRouteModel(DocumentRef documentRef, CoreSession session) throws ClientException {
        DocumentModel parentDoc = session.getDocument(documentRef);
        if (parentDoc.hasFacet("DocumentRoute")) {
            return (DocumentRoute)parentDoc.getAdapter(DocumentRoute.class);
        }
        DocumentRouteElement rElement = (DocumentRouteElement)parentDoc.getAdapter(DocumentRouteElement.class);
        return rElement.getDocumentRoute(session);
    }

    public DocumentRoute saveRouteAsNewModel(DocumentRoute instance, CoreSession session) {
        DocumentModel instanceModel = instance.getDocument();
        DocumentModel parent = this.persister.getParentFolderForNewModel(session, instanceModel);
        String newName = this.persister.getNewModelName(instanceModel);
        try {
            DocumentModel newmodel = this.persister.saveDocumentRouteInstanceAsNewModel(instanceModel, parent, newName, session);
            DocumentRoute newRoute = (DocumentRoute)newmodel.getAdapter(DocumentRoute.class);
            if (!newRoute.isDraft()) {
                newRoute.followTransition(DocumentRouteElement.ElementLifeCycleTransistion.toDraft, session, false);
            }
            newRoute.getDocument().setPropertyValue("dc:title", (Serializable)((Object)newName));
            newRoute.setAttachedDocuments(new ArrayList());
            newRoute.save(session);
            return newRoute;
        }
        catch (ClientException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isRoutable(DocumentModel doc) {
        if (doc == null) {
            return false;
        }
        String type = doc.getType();
        return type.equals("File") || type.equals("Note");
    }

    public DocumentRoute importRouteModel(URL modelToImport, boolean overwrite, CoreSession session) throws ClientException {
        StreamingBlob fb;
        if (modelToImport == null) {
            throw new ClientException("No resource containing route templates found");
        }
        try {
            fb = StreamingBlob.createFromStream((InputStream)modelToImport.openStream());
        }
        catch (IOException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
        try {
            String file = modelToImport.getFile();
            DocumentModel doc = this.getFileManager().createDocumentFromBlob(session, (Blob)fb, this.persister.getParentFolderForDocumentRouteModels(session).getPathAsString(), true, file);
            if (doc == null) {
                throw new ClientException("Can not import document " + file);
            }
            if (this.modelsChache != null) {
                this.modelsChache.invalidate((Object)doc.getName());
            }
            DocumentRoute documentRoute = (DocumentRoute)doc.getAdapter(DocumentRoute.class);
            return documentRoute;
        }
        catch (Exception e) {
            throw new ClientException((Throwable)e);
        }
        finally {
            try {
                FileUtils.close((InputStream)fb.getStream());
            }
            catch (IOException e) {
                throw new ClientException((Throwable)e);
            }
        }
    }

    protected FileManager getFileManager() {
        try {
            return (FileManager)Framework.getService(FileManager.class);
        }
        catch (Exception e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    public void activate(ComponentContext context) throws Exception {
        super.activate(context);
        this.modelsChache = CacheBuilder.newBuilder().maximumSize(100L).expireAfterWrite(10L, TimeUnit.MINUTES).build();
        this.repositoryInitializationHandler = new RouteModelsInitializator();
        this.repositoryInitializationHandler.install();
    }

    public void deactivate(ComponentContext context) throws Exception {
        super.deactivate(context);
        if (this.repositoryInitializationHandler != null) {
            this.repositoryInitializationHandler.uninstall();
        }
    }

    public List<URL> getRouteModelTemplateResources() throws ClientException {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (URL url : this.routeResourcesRegistry.getRouteModelTemplateResources()) {
            urls.add(url);
        }
        return urls;
    }

    public List<DocumentModel> searchRouteModels(CoreSession session, String searchString) throws ClientException {
        ArrayList<DocumentModel> allRouteModels = new ArrayList<DocumentModel>();
        PageProviderService pageProviderService = (PageProviderService)Framework.getLocalService(PageProviderService.class);
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("maxResults", "PAGE_SIZE");
        props.put("coreSession", (Serializable)session);
        PageProvider pageProvider = pageProviderService.getPageProvider("DOC_ROUTING_SEARCH_ALL_ROUTE_MODELS", null, null, Long.valueOf(0L), props, new Object[]{String.format("%s%%", searchString)});
        allRouteModels.addAll(pageProvider.getCurrentPage());
        while (pageProvider.isNextPageAvailable()) {
            pageProvider.nextPage();
            allRouteModels.addAll(pageProvider.getCurrentPage());
        }
        return allRouteModels;
    }

    public void registerRouteResource(RouteModelResourceType res, RuntimeContext context) {
        if (res.getPath() != null && res.getId() != null) {
            if (this.routeResourcesRegistry.getResource(res.getId()) != null) {
                this.routeResourcesRegistry.removeContribution(res);
            }
            if (res.getUrl() == null) {
                res.setUrl(this.getUrlFromPath(res, context));
            }
            this.routeResourcesRegistry.addContribution(res);
        }
    }

    protected URL getUrlFromPath(RouteModelResourceType res, RuntimeContext extensionContext) {
        URL url;
        block4: {
            String path = res.getPath();
            if (path == null) {
                return null;
            }
            url = null;
            try {
                url = new URL(path);
            }
            catch (MalformedURLException e) {
                url = extensionContext.getLocalResource(path);
                if (url == null) {
                    url = extensionContext.getResource(path);
                }
                if (url != null) break block4;
                url = res.getClass().getResource(path);
            }
        }
        return url;
    }

    public DocumentRoute getRouteModelWithId(CoreSession session, String id) throws ClientException {
        String routeDocModelId = this.getRouteModelDocIdWithId(session, id);
        DocumentModel routeDoc = session.getDocument((DocumentRef)new IdRef(routeDocModelId));
        return (DocumentRoute)routeDoc.getAdapter(DocumentRoute.class);
    }

    public String getRouteModelDocIdWithId(CoreSession session, String id) throws ClientException {
        String routeDocId;
        if (this.modelsChache != null && (routeDocId = (String)this.modelsChache.getIfPresent((Object)id)) != null) {
            return routeDocId;
        }
        String query = String.format(ROUTE_MODEL_DOC_ID_WITH_ID_QUERY, NXQL.escapeString((String)id));
        IterableQueryResult results = session.queryAndFetch(query, "NXQL", new Object[0]);
        if (results.size() == 0L) {
            throw new ClientRuntimeException("No route found for id: " + id);
        }
        if (results.size() != 1L) {
            throw new ClientRuntimeException("More than one route model found with id: " + id);
        }
        ArrayList<String> routeIds = new ArrayList<String>();
        for (Map map : results) {
            routeIds.add(((Serializable)map.get("ecm:uuid")).toString());
        }
        results.close();
        String routeDocId2 = (String)routeIds.get(0);
        if (this.modelsChache == null) {
            this.modelsChache = CacheBuilder.newBuilder().maximumSize(100L).expireAfterWrite(10L, TimeUnit.MINUTES).build();
        }
        this.modelsChache.put((Object)id, (Object)routeDocId2);
        return routeDocId2;
    }

    public void makeRoutingTasks(CoreSession coreSession, final List<Task> tasks) throws ClientException {
        new UnrestrictedSessionRunner(coreSession){

            public void run() throws ClientException {
                for (Task task : tasks) {
                    DocumentModel taskDoc = task.getDocument();
                    taskDoc.addFacet("RoutingTask");
                    this.session.saveDocument(taskDoc);
                }
            }
        }.runUnrestricted();
    }

    public void endTask(CoreSession session, Task task, Map<String, Object> data, String status) throws ClientException {
        String comment = (String)data.get("comment");
        TaskService taskService = (TaskService)Framework.getLocalService(TaskService.class);
        taskService.endTask(session, (NuxeoPrincipal)session.getPrincipal(), task, comment, null, false);
        Map taskVariables = task.getVariables();
        String routeInstanceId = (String)taskVariables.get("routeInstanceDocId");
        if (StringUtils.isEmpty((String)routeInstanceId)) {
            throw new DocumentRouteException("Can not resume workflow, no related route");
        }
        this.completeTask(routeInstanceId, null, task.getId(), data, status, session);
        HashMap<String, String> extraEventProperties = new HashMap<String, String>();
        extraEventProperties.put("workflowTaskCompletionAction", status);
        TaskEventNotificationHelper.notifyTaskEnded((CoreSession)session, (NuxeoPrincipal)((NuxeoPrincipal)session.getPrincipal()), (Task)task, (String)comment, (String)"workflowTaskCompleted", extraEventProperties);
    }

    public List<DocumentModel> getWorkflowInputDocuments(CoreSession session, Task task) throws ClientException {
        DocumentModel routeDoc;
        String routeInstanceId;
        try {
            routeInstanceId = task.getProcessId();
        }
        catch (ClientException e) {
            throw new DocumentRouteException("Can not get the related workflow instance");
        }
        if (StringUtils.isEmpty((String)routeInstanceId)) {
            throw new DocumentRouteException("Can not get the related workflow instance");
        }
        try {
            routeDoc = session.getDocument((DocumentRef)new IdRef(routeInstanceId));
        }
        catch (ClientException e) {
            throw new DocumentRouteException("No workflow with the id:" + routeInstanceId);
        }
        DocumentRoute route = (DocumentRoute)routeDoc.getAdapter(DocumentRoute.class);
        return route.getAttachedDocuments(session);
    }

    public void grantPermissionToTaskAssignees(CoreSession session, String permission, List<DocumentModel> docs, Task task) throws ClientException {
        this.setAclForActors(session, DocumentRoutingServiceImpl.getRoutingACLName(task), permission, docs, task.getActors());
    }

    public void grantPermissionToTaskDelegatedActors(CoreSession session, String permission, List<DocumentModel> docs, Task task) throws ClientException {
        this.setAclForActors(session, DocumentRoutingServiceImpl.getDelegationACLName(task), permission, docs, task.getDelegatedActors());
    }

    public void removePermissionFromTaskAssignees(CoreSession session, final List<DocumentModel> docs, Task task) throws ClientException {
        final String aclName = DocumentRoutingServiceImpl.getRoutingACLName(task);
        new UnrestrictedSessionRunner(session){

            public void run() throws ClientException {
                for (DocumentModel doc : docs) {
                    ACP acp = doc.getACP();
                    acp.removeACL(aclName);
                    doc.setACP(acp, true);
                    this.session.saveDocument(doc);
                }
            }
        }.runUnrestricted();
    }

    public void removePermissionsForTaskActors(CoreSession session, final List<DocumentModel> docs, Task task) throws ClientException {
        final String aclRoutingName = DocumentRoutingServiceImpl.getRoutingACLName(task);
        final String aclDelegationName = DocumentRoutingServiceImpl.getDelegationACLName(task);
        new UnrestrictedSessionRunner(session){

            public void run() throws ClientException {
                for (DocumentModel doc : docs) {
                    ACP acp = doc.getACP();
                    acp.removeACL(aclRoutingName);
                    acp.removeACL(aclDelegationName);
                    doc.setACP(acp, true);
                    this.session.saveDocument(doc);
                }
            }
        }.runUnrestricted();
    }

    protected static String getRoutingACLName(Task task) {
        return "routing/" + task.getId();
    }

    protected static String getDelegationACLName(Task task) {
        return "delegation/" + task.getId();
    }

    public void finishTask(CoreSession session, DocumentRoute route, Task task, boolean delete) throws DocumentRouteException {
        DocumentModelList docs = route.getAttachedDocuments(session);
        try {
            this.removePermissionsForTaskActors(session, (List<DocumentModel>)docs, task);
            if (delete) {
                session.removeDocument((DocumentRef)new IdRef(task.getId()));
            }
        }
        catch (ClientException e) {
            throw new DocumentRouteException("Cannot finish task", (Throwable)e);
        }
    }

    public void cancelTask(CoreSession session, final String taskId) throws DocumentRouteException {
        try {
            new UnrestrictedSessionRunner(session){

                public void run() throws ClientException {
                    DocumentModel taskDoc = this.session.getDocument((DocumentRef)new IdRef(taskId));
                    Task task = (Task)taskDoc.getAdapter(Task.class);
                    if (task == null) {
                        throw new DocumentRouteException("Invalid taskId: " + taskId);
                    }
                    if (!task.isOpened().booleanValue()) {
                        log.info((Object)("Can not cancel task " + taskId + "as is not open"));
                        return;
                    }
                    task.cancel(this.session);
                    String routeId = task.getProcessId();
                    if (routeId != null) {
                        DocumentModel routeDoc = this.session.getDocument((DocumentRef)new IdRef(routeId));
                        GraphRoute routeInstance = (GraphRoute)routeDoc.getAdapter(GraphRoute.class);
                        if (routeInstance == null) {
                            throw new DocumentRouteException("Invalid routeInstanceId: " + routeId);
                        }
                        DocumentModelList docs = routeInstance.getAttachedDocumentModels();
                        DocumentRoutingServiceImpl.this.removePermissionsForTaskActors(this.session, (List<DocumentModel>)docs, task);
                        DocumentRoutingServiceImpl.this.updateTaskInfo(this.session, routeInstance, task, null);
                    }
                    this.session.saveDocument(task.getDocument());
                }
            }.runUnrestricted();
        }
        catch (ClientException e) {
            throw new DocumentRouteException("Cannot cancel task", (Throwable)e);
        }
    }

    protected void updateTaskInfo(CoreSession session, GraphRoute graph, Task task, String status) throws ClientException {
        String nodeId = task.getVariable("nodeId");
        if (StringUtils.isEmpty((String)nodeId)) {
            throw new DocumentRouteException("No nodeId found on task: " + task.getId());
        }
        GraphNode node = graph.getNode(nodeId);
        NuxeoPrincipal principal = (NuxeoPrincipal)session.getPrincipal();
        String actor = principal.getActingUser();
        node.updateTaskInfo(task.getId(), true, status, actor, null);
    }

    public void reassignTask(CoreSession session, final String taskId, final List<String> actors, final String comment) throws DocumentRouteException {
        try {
            new UnrestrictedSessionRunner(session){

                public void run() throws ClientException {
                    DocumentModel taskDoc = this.session.getDocument((DocumentRef)new IdRef(taskId));
                    Task task = (Task)taskDoc.getAdapter(Task.class);
                    if (task == null) {
                        throw new DocumentRouteException("Invalid taskId: " + taskId);
                    }
                    if (!task.isOpened().booleanValue()) {
                        throw new DocumentRouteException("Task  " + taskId + " is not opened, can not reassign it");
                    }
                    String routeId = task.getProcessId();
                    if (routeId != null) {
                        DocumentModel routeDoc = this.session.getDocument((DocumentRef)new IdRef(routeId));
                        GraphRoute routeInstance = (GraphRoute)routeDoc.getAdapter(GraphRoute.class);
                        if (routeInstance == null) {
                            throw new DocumentRouteException("Invalid routeInstanceId: " + routeId + " referenced by the task " + taskId);
                        }
                        GraphNode node = routeInstance.getNode(task.getType());
                        if (node == null) {
                            throw new DocumentRouteException("Invalid node " + routeId + " referenced by the task " + taskId);
                        }
                        if (!node.allowTaskReassignment()) {
                            throw new DocumentRouteException("Task " + taskId + " can not be reassigned. Node " + node.getId() + " doesn't allow reassignment.");
                        }
                        DocumentModelList docs = routeInstance.getAttachedDocumentModels();
                        DocumentRoutingServiceImpl.this.removePermissionFromTaskAssignees(this.session, (List<DocumentModel>)docs, task);
                        ((TaskService)Framework.getLocalService(TaskService.class)).reassignTask(this.session, taskId, actors, comment);
                        task.getDocument().refresh();
                        DocumentRoutingServiceImpl.this.grantPermissionToTaskAssignees(this.session, node.getTaskAssigneesPermission(), (List<DocumentModel>)docs, task);
                    }
                }
            }.runUnrestricted();
        }
        catch (ClientException e) {
            throw new DocumentRouteException("Can not reassign task " + taskId, (Throwable)e);
        }
    }

    public void delegateTask(CoreSession session, final String taskId, final List<String> delegatedActors, final String comment) throws DocumentRouteException {
        try {
            new UnrestrictedSessionRunner(session){

                public void run() throws ClientException {
                    DocumentModel taskDoc = this.session.getDocument((DocumentRef)new IdRef(taskId));
                    Task task = (Task)taskDoc.getAdapter(Task.class);
                    if (task == null) {
                        throw new DocumentRouteException("Invalid taskId: " + taskId);
                    }
                    String routeId = task.getProcessId();
                    if (routeId != null) {
                        DocumentModel routeDoc = this.session.getDocument((DocumentRef)new IdRef(routeId));
                        GraphRoute routeInstance = (GraphRoute)routeDoc.getAdapter(GraphRoute.class);
                        if (routeInstance == null) {
                            throw new DocumentRouteException("Invalid routeInstanceId: " + routeId + " referenced by the task " + taskId);
                        }
                        GraphNode node = routeInstance.getNode(task.getType());
                        if (node == null) {
                            throw new DocumentRouteException("Invalid node " + routeId + " referenced by the task " + taskId);
                        }
                        DocumentModelList docs = routeInstance.getAttachedDocumentModels();
                        ((TaskService)Framework.getLocalService(TaskService.class)).delegateTask(this.session, taskId, delegatedActors, comment);
                        task.getDocument().refresh();
                        DocumentRoutingServiceImpl.this.grantPermissionToTaskDelegatedActors(this.session, node.getTaskAssigneesPermission(), (List<DocumentModel>)docs, task);
                    }
                }
            }.runUnrestricted();
        }
        catch (ClientException e) {
            throw new DocumentRouteException("Can not delegate task " + taskId, (Throwable)e);
        }
    }

    protected void setAclForActors(CoreSession session, final String aclName, final String permission, final List<DocumentModel> docs, List<String> actors) throws ClientException {
        final ArrayList<String> actorIds = new ArrayList<String>();
        for (String actor : actors) {
            if (actor.contains(":")) {
                actorIds.add(actor.split(":")[1]);
                continue;
            }
            actorIds.add(actor);
        }
        new UnrestrictedSessionRunner(session){

            public void run() throws ClientException {
                for (DocumentModel doc : docs) {
                    ACP acp = doc.getACP();
                    acp.removeACL(aclName);
                    ACLImpl acl = new ACLImpl(aclName);
                    for (String actorId : actorIds) {
                        acl.add((Object)new ACE(actorId, permission, true));
                    }
                    acp.addACL(0, (ACL)acl);
                    doc.setACP(acp, true);
                    this.session.saveDocument(doc);
                }
            }
        }.runUnrestricted();
    }

    public void cleanupDoneAndCanceledRouteInstances(String reprositoryName, final int limit) throws ClientException {
        new UnrestrictedSessionRunner(reprositoryName){

            public void run() throws ClientException {
                ArrayList<String> routeIds = new ArrayList<String>();
                String query = "SELECT ecm:uuid FROM DocumentRoute WHERE (ecm:currentLifeCycleState = 'done' OR ecm:currentLifeCycleState = 'canceled') ORDER BY dc:created";
                IterableQueryResult results = this.session.queryAndFetch(query, "NXQL", new Object[0]);
                int i = 0;
                for (Map result : results) {
                    routeIds.add(((Serializable)result.get("ecm:uuid")).toString());
                    if (++i != limit) continue;
                    break;
                }
                results.close();
                for (String routeDocId : routeIds) {
                    this.session.removeDocument((DocumentRef)new IdRef(routeDocId));
                }
            }
        }.runUnrestricted();
    }

    public void invalidateRouteModelsCache() {
        this.modelsChache.invalidateAll();
    }

    class UnrestrictedQueryRunner
    extends UnrestrictedSessionRunner {
        String query;
        DocumentModelList docs;

        protected UnrestrictedQueryRunner(CoreSession session, String query) {
            super(session);
            this.query = query;
        }

        public void run() throws ClientException {
            this.docs = this.session.query(this.query);
            for (DocumentModel documentModel : this.docs) {
                documentModel.detach(true);
            }
        }

        public DocumentModelList runQuery() throws ClientException {
            this.runUnrestricted();
            return this.docs;
        }
    }
}

