/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.api;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.Environment;

public enum J2EEContainerDescriptor {
    JBOSS,
    TOMCAT,
    JETTY,
    GF3;

    public static final Log log;
    static J2EEContainerDescriptor selected;

    static J2EEContainerDescriptor autodetect() {
        String hostName = Environment.getDefault().getHostApplicationName();
        if (hostName == null) {
            return null;
        }
        if ("JBoss".equals(hostName)) {
            log.info((Object)"Detected JBoss host");
            return JBOSS;
        }
        if ("Tomcat".equals(hostName)) {
            log.info((Object)"Detected Tomcat host");
            return TOMCAT;
        }
        if ("NXServer".equals(hostName)) {
            try {
                Class.forName("com.sun.enterprise.glassfish.bootstrap.AbstractMain");
                log.info((Object)"Detected GlassFish host");
                return GF3;
            }
            catch (Exception e) {
                log.debug((Object)"Autodetect : not a glassfish host");
                try {
                    Class.forName("org.mortbay.jetty.webapp.WebAppContext");
                    log.info((Object)"Detected Jetty host");
                    return JETTY;
                }
                catch (Exception e2) {
                    log.debug((Object)"Autodetect : not a jetty host");
                    return null;
                }
            }
        }
        return null;
    }

    public static J2EEContainerDescriptor getSelected() {
        if (selected == null) {
            selected = J2EEContainerDescriptor.autodetect();
        }
        return selected;
    }

    static {
        log = LogFactory.getLog(J2EEContainerDescriptor.class);
    }
}

