/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.update.task.live.commands;

import java.io.File;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.connect.update.PackageException;
import org.nuxeo.connect.update.task.Command;
import org.nuxeo.connect.update.task.Task;
import org.nuxeo.connect.update.task.live.commands.Undeploy;
import org.nuxeo.connect.update.task.standalone.commands.CompositeCommand;
import org.nuxeo.connect.update.task.standalone.commands.DeployPlaceholder;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.reload.ReloadService;

public class Deploy
extends DeployPlaceholder {
    private static final Log log = LogFactory.getLog(Deploy.class);

    public Deploy() {
    }

    public Deploy(File file) {
        super(file);
    }

    protected Undeploy deployFile(File file, ReloadService service) throws PackageException {
        String name = service.getOSGIBundleName(file);
        if (name == null) {
            return null;
        }
        try {
            service.deployBundle(file, true);
        }
        catch (Exception e) {
            throw new PackageException("Failed to deploy bundle " + file, (Throwable)e);
        }
        return new Undeploy(file);
    }

    protected CompositeCommand deployDirectory(File dir, ReloadService service) throws PackageException {
        CompositeCommand cmd = new CompositeCommand();
        File[] files = dir.listFiles();
        if (files != null) {
            for (File fileInDir : files) {
                Undeploy ud = this.deployFile(fileInDir, service);
                if (ud == null) continue;
                cmd.addCommand((Command)ud);
            }
        }
        if (cmd.isEmpty()) {
            return null;
        }
        return cmd;
    }

    protected Command doRun(Task task, Map<String, String> prefs) throws PackageException {
        if (!this.file.exists()) {
            log.warn((Object)("Can't deploy file " + this.file + ". File is missing."));
            return null;
        }
        ReloadService srv = (ReloadService)Framework.getLocalService(ReloadService.class);
        Object rollback = this.file.isDirectory() ? this.deployDirectory(this.file, srv) : this.deployFile(this.file, srv);
        if (rollback != null) {
            try {
                srv.runDeploymentPreprocessor();
            }
            catch (Exception e) {
                throw new PackageException(e.getMessage(), (Throwable)e);
            }
        }
        return rollback;
    }
}

