/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.nuxeo.ecm.automation.AutomationAdmin;
import org.nuxeo.ecm.automation.AutomationFilter;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.ChainException;
import org.nuxeo.ecm.automation.CompiledChain;
import org.nuxeo.ecm.automation.InvalidChainException;
import org.nuxeo.ecm.automation.OperationCallback;
import org.nuxeo.ecm.automation.OperationChain;
import org.nuxeo.ecm.automation.OperationCompoundExceptionBuilder;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationDocumentation;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.OperationNotFoundException;
import org.nuxeo.ecm.automation.OperationParameters;
import org.nuxeo.ecm.automation.OperationType;
import org.nuxeo.ecm.automation.TraceException;
import org.nuxeo.ecm.automation.TypeAdapter;
import org.nuxeo.ecm.automation.core.exception.CatchChainException;
import org.nuxeo.ecm.automation.core.exception.ChainExceptionRegistry;
import org.nuxeo.ecm.automation.core.impl.AdapterKeyedRegistry;
import org.nuxeo.ecm.automation.core.impl.AutomationFilterRegistry;
import org.nuxeo.ecm.automation.core.impl.ChainTypeImpl;
import org.nuxeo.ecm.automation.core.impl.CompiledChainImpl;
import org.nuxeo.ecm.automation.core.impl.OperationTypeImpl;
import org.nuxeo.ecm.automation.core.impl.OperationTypeRegistry;
import org.nuxeo.ecm.automation.core.impl.TypeAdapterKey;
import org.nuxeo.ecm.automation.core.trace.TracerFactory;
import org.nuxeo.ecm.platform.forms.layout.api.WidgetDefinition;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class OperationServiceImpl
implements AutomationService,
AutomationAdmin {
    private static final Log log = LogFactory.getLog(OperationServiceImpl.class);
    protected final OperationTypeRegistry operations;
    protected final ChainExceptionRegistry chainExceptionRegistry;
    protected final AutomationFilterRegistry automationFilterRegistry;
    protected Map<CacheKey, CompiledChainImpl> compiledChains = new HashMap<CacheKey, CompiledChainImpl>();
    protected AdapterKeyedRegistry adapters;

    public OperationServiceImpl() {
        this.operations = new OperationTypeRegistry();
        this.adapters = new AdapterKeyedRegistry();
        this.chainExceptionRegistry = new ChainExceptionRegistry();
        this.automationFilterRegistry = new AutomationFilterRegistry();
    }

    @Override
    public Object run(OperationContext ctx, String operationId) throws Exception {
        OperationType operationType = this.getOperation(operationId);
        if (operationType instanceof ChainTypeImpl) {
            return this.run(ctx, operationType, ((ChainTypeImpl)operationType).getChainParameters());
        }
        return this.run(ctx, operationType, null);
    }

    @Override
    public Object run(OperationContext ctx, OperationChain chain) throws Exception {
        Map<String, Object> chainParameters = Collections.emptyMap();
        if (!chain.getChainParameters().isEmpty()) {
            chainParameters = chain.getChainParameters();
        }
        ChainTypeImpl chainType = new ChainTypeImpl(this, chain);
        return this.run(ctx, chainType, chainParameters);
    }

    @Override
    public Object run(OperationContext ctx, String operationId, Map<String, Object> runtimeParameters) throws Exception {
        OperationType type = this.getOperation(operationId);
        return this.run(ctx, type, runtimeParameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object runInNewTx(OperationContext ctx, String chainId, Map chainParameters, Integer timeout, boolean rollbackGlobalOnError) throws Exception {
        Object result = null;
        if (TransactionHelper.isTransactionMarkedRollback()) {
            return null;
        }
        TransactionHelper.commitOrRollbackTransaction();
        int to = timeout == null ? 0 : timeout;
        TransactionHelper.startTransaction((int)to);
        boolean ok = false;
        try {
            result = this.run(ctx, chainId, (Map<String, Object>)chainParameters);
            ok = true;
        }
        catch (OperationException e) {
            if (rollbackGlobalOnError) {
                throw e;
            }
            log.error((Object)("Error while executing operation " + chainId), (Throwable)e);
        }
        finally {
            if (!ok) {
                TransactionHelper.setTransactionRollbackOnly();
            }
            TransactionHelper.commitOrRollbackTransaction();
            TransactionHelper.startTransaction();
        }
        return result;
    }

    public Object run(OperationContext ctx, OperationType operationType, Map<String, Object> params) throws Exception {
        OperationCallback tracer;
        Boolean mainChain = true;
        if (params == null) {
            params = new HashMap<String, Object>();
        }
        ctx.put("ChainParameters", (Object)params);
        if (params != null && !params.isEmpty()) {
            ctx.put("ChainParameters", (Object)params);
        }
        TracerFactory tracerFactory = (TracerFactory)Framework.getLocalService(TracerFactory.class);
        if (ctx.getChainCallback() == null) {
            tracer = tracerFactory.newTracer(operationType.getId());
            ctx.addChainCallback(tracer);
        } else {
            mainChain = false;
            tracer = ctx.getChainCallback();
        }
        try {
            CompiledChainImpl chain;
            Object input = ctx.getInput();
            Class<Void> inputType = input == null ? Void.TYPE : input.getClass();
            tracer.onChain(operationType);
            if (ChainTypeImpl.class.isAssignableFrom(operationType.getClass())) {
                CacheKey cacheKey = new CacheKey(operationType.getId(), inputType.getName());
                chain = this.compiledChains.get(cacheKey);
                if (chain == null) {
                    chain = (CompiledChainImpl)operationType.newInstance(ctx, params);
                    if (this.hasOperation(operationType.getId())) {
                        this.compiledChains.put(cacheKey, chain);
                    }
                }
            } else {
                chain = CompiledChainImpl.buildChain(inputType, OperationServiceImpl.toParams(operationType.getId()));
            }
            Object ret = chain.invoke(ctx);
            tracer.onOutput(ret);
            if (ctx.getCoreSession() != null && ctx.isCommit()) {
                ctx.getCoreSession().save();
            }
            if (mainChain.booleanValue() && tracer.getTrace() != null && tracerFactory.getRecordingState()) {
                log.info((Object)tracer.getFormattedText());
            }
            Object object = ret;
            return object;
        }
        catch (OperationException oe) {
            tracer.onError(oe);
            String operationTypeId = operationType.getId();
            if (this.hasChainException(operationTypeId)) {
                Object object = this.run(ctx, this.getChainExceptionToRun(ctx, operationTypeId, oe));
                return object;
            }
            if (oe.isRollback()) {
                ctx.setRollback();
            }
            if (mainChain.booleanValue()) {
                throw new TraceException(tracer, (Throwable)oe);
            }
            throw new TraceException(oe);
        }
        finally {
            ctx.dispose();
        }
    }

    protected String getChainExceptionToRun(OperationContext ctx, String operationTypeId, OperationException oe) throws OperationException {
        ctx.put("Exception", (Object)oe.getClass().getSimpleName());
        ctx.put("exceptionName", (Object)oe.getClass().getSimpleName());
        ctx.put("exceptionObject", (Object)oe);
        ChainException chainException = this.getChainException(operationTypeId);
        CatchChainException catchChainException = new CatchChainException();
        for (CatchChainException catchChainExceptionItem : chainException.getCatchChainExceptions()) {
            if (catchChainExceptionItem.hasFilter().booleanValue()) {
                AutomationFilter filter = this.getAutomationFilter(catchChainExceptionItem.getFilterId());
                try {
                    String filterValue = (String)filter.getValue().eval(ctx);
                    if (!Boolean.parseBoolean(filterValue)) continue;
                    catchChainException = this.getCatchChainExceptionByPriority(catchChainException, catchChainExceptionItem);
                    continue;
                }
                catch (Exception e) {
                    throw new OperationException("Cannot evaluate Automation Filter " + filter.getId() + " mvel expression.", e);
                }
            }
            catchChainException = this.getCatchChainExceptionByPriority(catchChainException, catchChainExceptionItem);
        }
        String chainId = catchChainException.getChainId();
        if (chainId.isEmpty()) {
            throw new OperationException("No chain exception has been selected to be run. You should verify Automation filters applied.");
        }
        if (catchChainException.getRollBack().booleanValue()) {
            ctx.setRollback();
        }
        return catchChainException.getChainId();
    }

    protected CatchChainException getCatchChainExceptionByPriority(CatchChainException catchChainException, CatchChainException catchChainExceptionItem) {
        return catchChainException.getPriority() <= catchChainExceptionItem.getPriority() ? catchChainExceptionItem : catchChainException;
    }

    public static OperationParameters[] toParams(String ... ids) {
        OperationParameters[] operationParameters = new OperationParameters[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            operationParameters[i] = new OperationParameters(ids[i]);
        }
        return operationParameters;
    }

    @Override
    public synchronized void putOperationChain(OperationChain chain) throws OperationException {
        this.putOperationChain(chain, false);
    }

    @Override
    public synchronized void putOperationChain(OperationChain chain, boolean replace) throws OperationException {
        ChainTypeImpl docChainType = new ChainTypeImpl(this, chain);
        this.putOperation(docChainType, replace);
    }

    @Override
    public synchronized void removeOperationChain(String id) {
        OperationChain chain = new OperationChain(id);
        ChainTypeImpl docChainType = new ChainTypeImpl(this, chain);
        this.operations.removeContribution(docChainType);
    }

    @Override
    public OperationChain getOperationChain(String id) throws OperationNotFoundException {
        ChainTypeImpl chain = (ChainTypeImpl)this.getOperation(id);
        return chain.getChain();
    }

    @Override
    public List<OperationChain> getOperationChains() {
        ArrayList<ChainTypeImpl> chainsType = new ArrayList<ChainTypeImpl>();
        ArrayList<OperationChain> chains = new ArrayList<OperationChain>();
        for (OperationType operationType : this.operations.lookup().values()) {
            if (!(operationType instanceof ChainTypeImpl)) continue;
            chainsType.add((ChainTypeImpl)operationType);
        }
        for (ChainTypeImpl chainType : chainsType) {
            chains.add(chainType.getChain());
        }
        return chains;
    }

    @Override
    public synchronized void flushCompiledChains() {
        this.compiledChains.clear();
    }

    @Override
    public void putOperation(Class<?> type) throws OperationException {
        OperationTypeImpl op = new OperationTypeImpl(this, type);
        this.putOperation(op, false);
    }

    @Override
    public void putOperation(Class<?> type, boolean replace) throws OperationException {
        this.putOperation(type, replace, null);
    }

    @Override
    public void putOperation(Class<?> type, boolean replace, String contributingComponent) throws OperationException {
        OperationTypeImpl op = new OperationTypeImpl(this, type, contributingComponent);
        this.putOperation(op, replace);
    }

    @Override
    public void putOperation(Class<?> type, boolean replace, String contributingComponent, List<WidgetDefinition> widgetDefinitionList) throws OperationException {
        OperationTypeImpl op = new OperationTypeImpl(this, type, contributingComponent, widgetDefinitionList);
        this.putOperation(op, replace);
    }

    @Override
    public synchronized void putOperation(OperationType op, boolean replace) throws OperationException {
        this.operations.addContribution(op, replace);
    }

    @Override
    public synchronized void removeOperation(Class<?> key) {
        OperationType type = this.operations.getOperationType(key);
        if (type == null) {
            log.warn((Object)("Cannot remove operation, no such operation " + key));
            return;
        }
        this.removeOperation(type);
    }

    @Override
    public synchronized void removeOperation(OperationType type) {
        this.operations.removeContribution(type);
    }

    @Override
    public OperationType[] getOperations() {
        Collection<OperationType> values = this.operations.lookup().values();
        return values.toArray(new OperationType[values.size()]);
    }

    @Override
    public OperationType getOperation(String id) throws OperationNotFoundException {
        OperationType op = this.operations.lookup().get(id);
        if (op == null) {
            throw new OperationNotFoundException("No operation was bound on ID: " + id);
        }
        return op;
    }

    @Override
    public boolean hasOperation(String id) {
        OperationType op = this.operations.lookup().get(id);
        return op != null;
    }

    @Override
    public CompiledChain compileChain(Class<?> inputType, OperationChain chain) throws Exception, InvalidChainException {
        List<OperationParameters> ops = chain.getOperations();
        return this.compileChain(inputType, ops.toArray(new OperationParameters[ops.size()]));
    }

    @Override
    public CompiledChain compileChain(Class<?> inputType, OperationParameters ... operations) throws Exception, InvalidChainException {
        return CompiledChainImpl.buildChain(this, inputType == null ? Void.TYPE : inputType, operations);
    }

    @Override
    public void putTypeAdapter(Class<?> accept, Class<?> produce, TypeAdapter adapter) {
        this.adapters.put(new TypeAdapterKey(accept, produce), adapter);
    }

    @Override
    public void removeTypeAdapter(Class<?> accept, Class<?> produce) {
        this.adapters.remove(new TypeAdapterKey(accept, produce));
    }

    @Override
    public TypeAdapter getTypeAdapter(Class<?> accept, Class<?> produce) {
        return (TypeAdapter)this.adapters.get(new TypeAdapterKey(accept, produce));
    }

    @Override
    public boolean isTypeAdaptable(Class<?> typeToAdapt, Class<?> targetType) {
        return this.getTypeAdapter(typeToAdapt, targetType) != null;
    }

    @Override
    public <T> T getAdaptedValue(OperationContext ctx, Object toAdapt, Class<?> targetType) throws Exception {
        if (toAdapt == null) {
            return null;
        }
        Class<?> toAdaptClass = toAdapt.getClass();
        if (targetType.isPrimitive() && (targetType = OperationServiceImpl.getTypeForPrimitive(targetType)).isAssignableFrom(toAdaptClass)) {
            return (T)toAdapt;
        }
        TypeAdapter adapter = this.getTypeAdapter(toAdaptClass, targetType);
        if (adapter == null) {
            if (toAdapt instanceof JsonNode) {
                ObjectMapper mapper = new ObjectMapper();
                return (T)mapper.convertValue(toAdapt, targetType);
            }
            throw new OperationException("No type adapter found for input: " + toAdapt.getClass() + " and output " + targetType);
        }
        return (T)adapter.getAdaptedValue(ctx, toAdapt);
    }

    @Override
    public List<OperationDocumentation> getDocumentation() throws OperationException {
        ArrayList<OperationDocumentation> result = new ArrayList<OperationDocumentation>();
        Collection<OperationType> ops = this.operations.lookup().values();
        OperationCompoundExceptionBuilder errorBuilder = new OperationCompoundExceptionBuilder();
        for (OperationType ot : ops.toArray(new OperationType[ops.size()])) {
            try {
                result.add(ot.getDocumentation());
            }
            catch (OperationNotFoundException e) {
                errorBuilder.add(e);
            }
        }
        errorBuilder.throwOnError();
        Collections.sort(result);
        return result;
    }

    public static Class<?> getTypeForPrimitive(Class<?> primitiveType) {
        if (primitiveType == Boolean.TYPE) {
            return Boolean.class;
        }
        if (primitiveType == Integer.TYPE) {
            return Integer.class;
        }
        if (primitiveType == Long.TYPE) {
            return Long.class;
        }
        if (primitiveType == Float.TYPE) {
            return Float.class;
        }
        if (primitiveType == Double.TYPE) {
            return Double.class;
        }
        if (primitiveType == Character.TYPE) {
            return Character.class;
        }
        if (primitiveType == Byte.TYPE) {
            return Byte.class;
        }
        if (primitiveType == Short.TYPE) {
            return Short.class;
        }
        return primitiveType;
    }

    @Override
    public void putChainException(ChainException exceptionChain) {
        this.chainExceptionRegistry.addContribution(exceptionChain);
    }

    @Override
    public void removeExceptionChain(ChainException exceptionChain) {
        this.chainExceptionRegistry.removeContribution(exceptionChain);
    }

    @Override
    public ChainException[] getChainExceptions() {
        Collection<ChainException> chainExceptions = this.chainExceptionRegistry.lookup().values();
        return chainExceptions.toArray(new ChainException[chainExceptions.size()]);
    }

    @Override
    public ChainException getChainException(String onChainId) {
        return this.chainExceptionRegistry.getChainException(onChainId);
    }

    @Override
    public boolean hasChainException(String onChainId) {
        return this.chainExceptionRegistry.getChainException(onChainId) != null;
    }

    @Override
    public void putAutomationFilter(AutomationFilter automationFilter) {
        this.automationFilterRegistry.addContribution(automationFilter);
    }

    @Override
    public void removeAutomationFilter(AutomationFilter automationFilter) {
        this.automationFilterRegistry.removeContribution(automationFilter);
    }

    @Override
    public AutomationFilter getAutomationFilter(String id) {
        return this.automationFilterRegistry.getAutomationFilter(id);
    }

    @Override
    public AutomationFilter[] getAutomationFilters() {
        Collection<AutomationFilter> automationFilters = this.automationFilterRegistry.lookup().values();
        return automationFilters.toArray(new AutomationFilter[automationFilters.size()]);
    }

    protected static class CacheKey {
        String operationId;
        String inputType;

        public CacheKey(String operationId, String inputType) {
            this.operationId = operationId;
            this.inputType = inputType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            if (this.inputType != null ? !this.inputType.equals(cacheKey.inputType) : cacheKey.inputType != null) {
                return false;
            }
            return !(this.operationId != null ? !this.operationId.equals(cacheKey.operationId) : cacheKey.operationId != null);
        }

        public int hashCode() {
            int result = this.operationId != null ? this.operationId.hashCode() : 0;
            result = 31 * result + (this.inputType != null ? this.inputType.hashCode() : 0);
            return result;
        }
    }
}

