/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.document;

import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.core.schema.types.ListType;
import org.nuxeo.ecm.core.schema.types.Type;

public class AbstractOperationMultiValuedProperty {
    protected void checkFieldType(Type type, Object value) throws OperationException {
        if (!type.isListType()) {
            throw new OperationException("Only multivalued String Types can be set using this operation");
        }
        ListType listType = (ListType)type;
        Type itemType = listType.getFieldType();
        if (itemType.isComplexType()) {
            throw new UnsupportedOperationException("Manage only lists of scalar items");
        }
        if (!itemType.newInstance().getClass().equals(value.getClass())) {
            throw new UnsupportedOperationException(String.format("Given type \"%s\" value is not a %s type", value, itemType.getName()));
        }
    }
}

