/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.core;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.jboss.seam.annotations.intercept.AroundInvoke;
import org.jboss.seam.annotations.intercept.Interceptor;
import org.jboss.seam.annotations.intercept.InterceptorType;
import org.jboss.seam.core.LockTimeoutException;
import org.jboss.seam.intercept.AbstractInterceptor;
import org.jboss.seam.intercept.InvocationContext;

@Interceptor(type=InterceptorType.CLIENT)
public class SynchronizationInterceptor
extends AbstractInterceptor {
    private static final long serialVersionUID = -4173880108889358566L;
    private ReentrantLock lock = new ReentrantLock(true);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @AroundInvoke
    public Object aroundInvoke(InvocationContext invocation) throws Exception {
        if (this.lock.tryLock(this.getComponent().getTimeout(), TimeUnit.MILLISECONDS)) {
            try {
                Object object = invocation.proceed();
                return object;
            }
            finally {
                this.lock.unlock();
            }
        }
        throw new LockTimeoutException("could not acquire lock on @Synchronized component: " + this.getComponent().getName());
    }

    @Override
    public boolean isInterceptorEnabled() {
        return this.getComponent().isSynchronize();
    }
}

