/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.transaction;

import java.util.Stack;
import javax.transaction.Synchronization;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.transaction.SynchronizationRegistry;
import org.jboss.seam.transaction.Synchronizations;

@Name(value="org.jboss.seam.transaction.synchronizations")
@Scope(value=ScopeType.EVENT)
@Install(precedence=0)
@BypassInterceptors
public class SeSynchronizations
implements Synchronizations {
    protected Stack<SynchronizationRegistry> synchronizations = new Stack();

    @Override
    public void afterTransactionBegin() {
        this.synchronizations.push(new SynchronizationRegistry());
    }

    @Override
    public void afterTransactionCommit(boolean success) {
        if (!this.synchronizations.isEmpty()) {
            this.synchronizations.pop().afterTransactionCompletion(success);
        }
    }

    @Override
    public void afterTransactionRollback() {
        if (!this.synchronizations.isEmpty()) {
            this.synchronizations.pop().afterTransactionCompletion(false);
        }
    }

    @Override
    public void beforeTransactionCommit() {
        if (!this.synchronizations.isEmpty()) {
            this.synchronizations.peek().beforeTransactionCompletion();
        }
    }

    @Override
    public void registerSynchronization(Synchronization sync) {
        if (this.synchronizations.isEmpty()) {
            throw new IllegalStateException("Transaction begin not detected, try installing transaction:ejb-transaction in components.xml");
        }
        this.synchronizations.peek().registerSynchronization(sync);
    }

    @Override
    public boolean isAwareOfContainerTransactions() {
        return false;
    }
}

