/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.util;

import org.jboss.seam.annotations.ApplicationException;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.transaction.Transaction;
import org.jboss.seam.transaction.UserTransaction;
import org.jboss.seam.util.EJB;
import org.jboss.seam.util.JSF;

public abstract class Work<T> {
    private static final LogProvider log = Logging.getLogProvider(Work.class);

    protected abstract T work() throws Exception;

    protected boolean isNewTransactionRequired(boolean transactionActive) {
        return !transactionActive;
    }

    public final T workInTransaction() throws Exception {
        UserTransaction userTransaction;
        boolean newTransactionRequired;
        UserTransaction transaction;
        block11: {
            transaction = null;
            boolean transactionActive = false;
            newTransactionRequired = false;
            userTransaction = null;
            try {
                transaction = Transaction.instance();
                transactionActive = transaction.isActiveOrMarkedRollback() || transaction.isRolledBack();
                newTransactionRequired = this.isNewTransactionRequired(transactionActive);
                userTransaction = newTransactionRequired ? transaction : null;
            }
            catch (IllegalStateException e) {
                newTransactionRequired = this.isNewTransactionRequired(false);
                if (!newTransactionRequired) break block11;
                throw e;
            }
        }
        try {
            if (newTransactionRequired) {
                log.debug("beginning transaction");
                userTransaction.begin();
            }
            T result = this.work();
            if (newTransactionRequired) {
                if (transaction.isMarkedRollback()) {
                    log.debug("rolling back transaction");
                    userTransaction.rollback();
                } else {
                    log.debug("committing transaction");
                    userTransaction.commit();
                }
            }
            return result;
        }
        catch (Exception e) {
            if (newTransactionRequired && userTransaction.getStatus() != 6) {
                if (Work.isRollbackRequired(e, true)) {
                    log.debug("rolling back transaction");
                    userTransaction.rollback();
                } else {
                    log.debug("committing transaction after ApplicationException(rollback=false):" + e.getMessage());
                    userTransaction.commit();
                }
            }
            throw e;
        }
    }

    public static boolean isRollbackRequired(Exception e, boolean isJavaBean) {
        Class<?> clazz = e.getClass();
        return Work.isSystemException(e, isJavaBean, clazz) || isJavaBean && clazz.isAnnotationPresent(EJB.APPLICATION_EXCEPTION) && EJB.rollback(clazz.getAnnotation(EJB.APPLICATION_EXCEPTION)) || clazz.isAnnotationPresent(ApplicationException.class) && clazz.getAnnotation(ApplicationException.class).rollback();
    }

    private static boolean isSystemException(Exception e, boolean isJavaBean, Class<? extends Exception> clazz) {
        return isJavaBean && e instanceof RuntimeException && !clazz.isAnnotationPresent(EJB.APPLICATION_EXCEPTION) && !clazz.isAnnotationPresent(ApplicationException.class) && !JSF.VALIDATOR_EXCEPTION.isInstance(e) && !JSF.CONVERTER_EXCEPTION.isInstance(e);
    }
}

