/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.restAPI;

import org.dom4j.dom.DOMDocument;
import org.dom4j.dom.DOMDocumentFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.platform.ui.web.restAPI.BaseNuxeoRestlet;
import org.restlet.data.Request;
import org.restlet.data.Response;

public class BaseStatelessNuxeoRestlet
extends BaseNuxeoRestlet {
    protected CoreSession session;
    protected DocumentRef targetDocRef;
    protected DocumentModel targetDocument;

    protected boolean initRepository(Response res, String repoId) {
        DOMDocumentFactory domFactory = new DOMDocumentFactory();
        DOMDocument result = (DOMDocument)domFactory.createDocument();
        if (repoId == null || repoId.equals("*")) {
            BaseStatelessNuxeoRestlet.handleError(result, res, "you must specify a repository");
            return false;
        }
        try {
            this.session = CoreInstance.openCoreSession((String)repoId);
        }
        catch (ClientException e) {
            BaseStatelessNuxeoRestlet.handleError(result, res, (Exception)((Object)e));
            return false;
        }
        return true;
    }

    protected boolean initRepositoryAndTargetDocument(Response res, String repoId, String docId) {
        DOMDocumentFactory domFactory = new DOMDocumentFactory();
        DOMDocument result = (DOMDocument)domFactory.createDocument();
        if (repoId == null || repoId.equals("*")) {
            BaseStatelessNuxeoRestlet.handleError(result, res, "you must specify a repository");
            return false;
        }
        if (docId == null || docId.equals("")) {
            BaseStatelessNuxeoRestlet.handleError(result, res, "you must specify a document");
            return false;
        }
        try {
            this.session = CoreInstance.openCoreSession((String)repoId);
        }
        catch (ClientException e) {
            BaseStatelessNuxeoRestlet.handleError(result, res, (Exception)((Object)e));
            return false;
        }
        this.targetDocRef = new IdRef(docId);
        try {
            this.targetDocument = this.session.getDocument(this.targetDocRef);
        }
        catch (ClientException e) {
            BaseStatelessNuxeoRestlet.handleError(result, res, "Unable to open " + repoId + " repository");
            return false;
        }
        return true;
    }

    protected void cleanUp() {
        if (this.session != null) {
            this.session.close();
            this.session = null;
            this.targetDocRef = null;
            this.targetDocument = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(Request request, Response response) {
        try {
            this.doHandleStatelessRequest(request, response);
        }
        finally {
            this.cleanUp();
        }
    }

    protected void doHandleStatelessRequest(Request req, Response res) {
    }
}

