/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.localconfiguration.LocalConfigurationService;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.platform.types.SubType;
import org.nuxeo.ecm.platform.types.Type;
import org.nuxeo.ecm.platform.types.TypeManager;
import org.nuxeo.ecm.platform.types.TypeRegistry;
import org.nuxeo.ecm.platform.types.localconfiguration.UITypesConfiguration;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;

public class TypeService
extends DefaultComponent
implements TypeManager {
    public static final ComponentName ID = new ComponentName("org.nuxeo.ecm.platform.types.TypeService");
    private static final Log log = LogFactory.getLog(TypeService.class);
    public static String DEFAULT_CATEGORY = "misc";
    public static final String HIDDEN_IN_CREATION = "create";
    private TypeRegistry typeRegistry;

    public void activate(ComponentContext context) {
        this.typeRegistry = new TypeRegistry();
    }

    public void deactivate(ComponentContext context) {
        this.typeRegistry = null;
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (extensionPoint.equals("types")) {
            this.typeRegistry.addContribution((Type)contribution);
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (extensionPoint.equals("types")) {
            this.typeRegistry.removeContribution((Type)contribution);
        }
    }

    public TypeRegistry getTypeRegistry() {
        return this.typeRegistry;
    }

    public String[] getSuperTypes(String typeName) {
        try {
            SchemaManager schemaMgr = (SchemaManager)Framework.getService(SchemaManager.class);
            DocumentType type = schemaMgr.getDocumentType(typeName);
            if (type == null) {
                return null;
            }
            ArrayList<String> superTypes = new ArrayList<String>();
            for (type = (DocumentType)type.getSuperType(); type != null; type = (DocumentType)type.getSuperType()) {
                superTypes.add(type.getName());
            }
            return superTypes.toArray(new String[superTypes.size()]);
        }
        catch (Exception e) {
            log.error((Object)"Failed to lookup the SchemaManager service", (Throwable)e);
            return new String[0];
        }
    }

    public Type getType(String typeName) {
        return this.typeRegistry.getType(typeName);
    }

    public boolean hasType(String typeName) {
        return this.typeRegistry.hasType(typeName);
    }

    public Collection<Type> getTypes() {
        ArrayList<Type> types = new ArrayList<Type>();
        types.addAll(this.typeRegistry.getTypes());
        return types;
    }

    public Collection<Type> getAllowedSubTypes(String typeName) {
        return this.getAllowedSubTypes(typeName, null);
    }

    public Collection<Type> getAllowedSubTypes(String typeName, DocumentModel currentDoc) {
        ArrayList<Type> allowed = new ArrayList<Type>();
        Type type = this.getType(typeName);
        if (type != null) {
            Map<String, SubType> allowedSubTypes = type.getAllowedSubTypes();
            if (currentDoc != null) {
                allowedSubTypes = this.filterSubTypesFromConfiguration(allowedSubTypes, currentDoc);
            }
            for (String subTypeName : allowedSubTypes.keySet()) {
                Type subType = this.getType(subTypeName);
                if (subType == null) continue;
                allowed.add(subType);
            }
        }
        return allowed;
    }

    public Collection<Type> findAllAllowedSubTypesFrom(String typeName) {
        return this.findAllAllowedSubTypesFrom(typeName, null, null);
    }

    public Collection<Type> findAllAllowedSubTypesFrom(String typeName, DocumentModel currentDoc) {
        return this.findAllAllowedSubTypesFrom(typeName, currentDoc, null);
    }

    protected Collection<Type> findAllAllowedSubTypesFrom(String typeName, DocumentModel currentDoc, List<String> alreadyProcessedTypes) {
        if (alreadyProcessedTypes == null) {
            alreadyProcessedTypes = new ArrayList<String>();
        }
        HashSet<Type> allAllowedSubTypes = new HashSet<Type>();
        Collection<Type> allowedSubTypes = this.getAllowedSubTypes(typeName, currentDoc);
        allAllowedSubTypes.addAll(allowedSubTypes);
        alreadyProcessedTypes.add(typeName);
        for (Type subType : allowedSubTypes) {
            if (alreadyProcessedTypes.contains(subType.getId())) continue;
            allAllowedSubTypes.addAll(this.findAllAllowedSubTypesFrom(subType.getId(), currentDoc, alreadyProcessedTypes));
        }
        return allAllowedSubTypes;
    }

    protected UITypesConfiguration getConfiguration(DocumentModel currentDoc) {
        UITypesConfiguration configuration = null;
        try {
            LocalConfigurationService localConfigurationService = (LocalConfigurationService)Framework.getService(LocalConfigurationService.class);
            configuration = (UITypesConfiguration)localConfigurationService.getConfiguration(UITypesConfiguration.class, "UITypesLocalConfiguration", currentDoc);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
        return configuration;
    }

    public Map<String, List<Type>> getTypeMapForDocumentType(String typeName, DocumentModel currentDoc) {
        Type type = this.getType(typeName);
        if (type != null) {
            HashMap<String, List<Type>> docTypesMap = new HashMap<String, List<Type>>();
            Map<String, SubType> allowedSubTypes = type.getAllowedSubTypes();
            allowedSubTypes = this.filterSubTypesFromConfiguration(allowedSubTypes, currentDoc);
            for (Map.Entry<String, SubType> entry : allowedSubTypes.entrySet()) {
                Type subType;
                if (!this.canCreate(entry.getValue()) || (subType = this.getType(entry.getKey())) == null) continue;
                String key = subType.getCategory();
                if (key == null) {
                    key = DEFAULT_CATEGORY;
                }
                if (!docTypesMap.containsKey(key)) {
                    docTypesMap.put(key, new ArrayList());
                }
                ((List)docTypesMap.get(key)).add(subType);
            }
            return docTypesMap;
        }
        return new HashMap<String, List<Type>>();
    }

    public boolean canCreate(String typeName, String containerTypeName) {
        Type containerType = this.getType(containerTypeName);
        Map allowedSubTypes = containerType.getAllowedSubTypes();
        return this.canCreate(typeName, allowedSubTypes);
    }

    public boolean canCreate(String typeName, String containerTypeName, DocumentModel currentDoc) {
        Map<String, SubType> allowedSubTypes = this.getFilteredAllowedSubTypes(containerTypeName, currentDoc);
        return this.canCreate(typeName, allowedSubTypes);
    }

    protected Map<String, SubType> getFilteredAllowedSubTypes(String containerTypeName, DocumentModel currentDoc) {
        Type containerType = this.getType(containerTypeName);
        if (containerType == null) {
            return Collections.emptyMap();
        }
        Map allowedSubTypes = containerType.getAllowedSubTypes();
        return this.filterSubTypesFromConfiguration(allowedSubTypes, currentDoc);
    }

    protected boolean canCreate(String typeName, Map<String, SubType> allowedSubTypes) {
        if (!this.isAllowedSubType(typeName, allowedSubTypes)) {
            return false;
        }
        SubType subType = allowedSubTypes.get(typeName);
        return this.canCreate(subType);
    }

    protected boolean canCreate(SubType subType) {
        List hidden = subType.getHidden();
        return hidden == null || !hidden.contains(HIDDEN_IN_CREATION);
    }

    public boolean isAllowedSubType(String typeName, String containerTypeName) {
        Type containerType = this.getType(containerTypeName);
        if (containerType == null) {
            return false;
        }
        Map allowedSubTypes = containerType.getAllowedSubTypes();
        return this.isAllowedSubType(typeName, allowedSubTypes);
    }

    protected boolean isAllowedSubType(String typeName, Map<String, SubType> allowedSubTypes) {
        for (String subTypeName : allowedSubTypes.keySet()) {
            if (!subTypeName.equals(typeName)) continue;
            return true;
        }
        return false;
    }

    public boolean isAllowedSubType(String typeName, String containerTypeName, DocumentModel currentDoc) {
        Map<String, SubType> allowedSubTypes = this.getFilteredAllowedSubTypes(containerTypeName, currentDoc);
        return this.isAllowedSubType(typeName, allowedSubTypes);
    }

    protected Map<String, SubType> filterSubTypesFromConfiguration(Map<String, SubType> allowedSubTypes, DocumentModel currentDoc) {
        UITypesConfiguration uiTypesConfiguration = this.getConfiguration(currentDoc);
        if (uiTypesConfiguration != null) {
            allowedSubTypes = uiTypesConfiguration.filterSubTypes(allowedSubTypes);
        }
        return allowedSubTypes;
    }
}

