/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.media;

import com.phloc.commons.IHasSize;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.state.EChange;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.media.ECSSMedium;
import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class CSSMediaList
implements Serializable,
IHasSize {
    private final Set<ECSSMedium> m_aMedia = new LinkedHashSet<ECSSMedium>();

    public CSSMediaList() {
    }

    public CSSMediaList(@Nonnull ECSSMedium eCSSMedium) {
        this.addMedium(eCSSMedium);
    }

    public CSSMediaList(ECSSMedium ... eCSSMediumArray) {
        if (eCSSMediumArray != null) {
            for (ECSSMedium eCSSMedium : eCSSMediumArray) {
                this.addMedium(eCSSMedium);
            }
        }
    }

    public CSSMediaList(@Nullable Iterable<ECSSMedium> iterable) {
        if (iterable != null) {
            for (ECSSMedium eCSSMedium : iterable) {
                this.addMedium(eCSSMedium);
            }
        }
    }

    @Nonnull
    public CSSMediaList addMedium(@Nonnull ECSSMedium eCSSMedium) {
        if (eCSSMedium == null) {
            throw new NullPointerException("medium");
        }
        this.m_aMedia.add(eCSSMedium);
        return this;
    }

    @Nonnull
    public EChange removeMedium(@Nullable ECSSMedium eCSSMedium) {
        return EChange.valueOf((boolean)this.m_aMedia.remove(eCSSMedium));
    }

    public boolean hasAnyMedia() {
        return !this.m_aMedia.isEmpty();
    }

    public boolean containsMedium(@Nullable ECSSMedium eCSSMedium) {
        return this.m_aMedia.contains(eCSSMedium);
    }

    public boolean containsMediumOrAll(@Nullable ECSSMedium eCSSMedium) {
        return this.containsMedium(eCSSMedium) || this.containsMedium(ECSSMedium.ALL);
    }

    public boolean isForScreen() {
        return this.m_aMedia.isEmpty() || this.containsMediumOrAll(ECSSMedium.SCREEN);
    }

    @Nonnull
    @ReturnsMutableCopy
    public Set<ECSSMedium> getAllMedia() {
        return ContainerHelper.newSet(this.m_aMedia);
    }

    @Nonnull
    public String getMediaString() {
        return this.getMediaString(", ");
    }

    @Nonnull
    public String getMediaString(@Nonnull String string) {
        if (string == null) {
            throw new NullPointerException("separator");
        }
        if (this.m_aMedia.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (ECSSMedium eCSSMedium : this.m_aMedia) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(string);
            }
            stringBuilder.append(eCSSMedium.getName());
        }
        return stringBuilder.toString();
    }

    @Nonnegative
    public int size() {
        return this.m_aMedia.size();
    }

    public boolean isEmpty() {
        return this.m_aMedia.isEmpty();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CSSMediaList)) {
            return false;
        }
        CSSMediaList cSSMediaList = (CSSMediaList)object;
        return ((Object)this.m_aMedia).equals(cSSMediaList.m_aMedia);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aMedia).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("media", this.m_aMedia).toString();
    }
}

