/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.osgi;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.osgi.BundleFile;
import org.nuxeo.osgi.BundleManifestReader;
import org.nuxeo.osgi.NestedJarBundleFile;
import org.nuxeo.osgi.OSGiAdapter;
import org.nuxeo.osgi.util.EntryFilter;

public class JarBundleFile
implements BundleFile {
    private static final Log log = LogFactory.getLog(JarBundleFile.class);
    protected JarFile jarFile;
    protected String urlBase;

    public JarBundleFile(File file) throws IOException {
        this(new JarFile(file));
    }

    public JarBundleFile(JarFile jarFile) {
        this.jarFile = jarFile;
        try {
            this.urlBase = "jar:" + new File(jarFile.getName()).toURI().toURL() + "!/";
        }
        catch (MalformedURLException e) {
            log.error((Object)("Failed to convert bundle location to an URL: " + jarFile.getName() + ". Bundle getEntry will not work."), (Throwable)e);
        }
    }

    @Override
    public Enumeration<URL> findEntries(String name, String pattern, boolean recurse) {
        String prefix;
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        if (name.length() == 0) {
            name = null;
            prefix = "";
        } else {
            prefix = !name.endsWith("/") ? name + "/" : name;
        }
        int len = prefix.length();
        EntryFilter filter = EntryFilter.newFilter(pattern);
        Enumeration<JarEntry> entries = this.jarFile.entries();
        ArrayList<URL> result = new ArrayList<URL>();
        try {
            while (entries.hasMoreElements()) {
                String n;
                JarEntry entry = entries.nextElement();
                if (entry.isDirectory()) continue;
                String ename = entry.getName();
                if (name != null && !ename.startsWith(prefix)) continue;
                int i = ename.lastIndexOf(47);
                if (!recurse && i > -1 && ename.indexOf(47, len) > -1 || !filter.match(n = i > -1 ? ename.substring(i + 1) : ename)) continue;
                result.add(this.getEntryUrl(ename));
            }
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        return Collections.enumeration(result);
    }

    @Override
    public URL getEntry(String name) {
        ZipEntry entry = this.jarFile.getEntry(name);
        if (entry == null) {
            return null;
        }
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        try {
            return new URL(this.urlBase + name);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    @Override
    public Enumeration<String> getEntryPaths(String path) {
        throw new UnsupportedOperationException("The operation BundleFile.geEntryPaths() was not yet implemented");
    }

    @Override
    public File getFile() {
        return new File(this.jarFile.getName());
    }

    @Override
    public String getFileName() {
        int pwin;
        int p;
        String path = this.jarFile.getName();
        int punix = path.lastIndexOf(47);
        int n = p = punix > (pwin = path.lastIndexOf(92)) ? punix : pwin;
        if (p == -1) {
            return path;
        }
        if (p == 0) {
            return "";
        }
        return path.substring(p + 1);
    }

    @Override
    public String getLocation() {
        return this.jarFile.getName();
    }

    @Override
    public Manifest getManifest() {
        try {
            return this.jarFile.getManifest();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public Collection<BundleFile> getNestedBundles(File tmpDir) throws IOException {
        Attributes attrs = this.jarFile.getManifest().getMainAttributes();
        String cp = attrs.getValue("Bundle-ClassPath");
        if (cp == null) {
            cp = attrs.getValue("Class-Path");
        }
        if (cp == null) {
            return null;
        }
        String[] paths = StringUtils.split((String)cp, (char)',', (boolean)true);
        URL base = new URL("jar:" + new File(this.jarFile.getName()).toURI().toURL().toExternalForm() + "!/");
        String fileName = this.getFileName();
        ArrayList<BundleFile> nested = new ArrayList<BundleFile>();
        for (String path : paths) {
            if (path.equals(".")) continue;
            String location = base + path;
            String name = path.replace('/', '_');
            File dest = new File(tmpDir, fileName + '-' + name);
            try {
                JarBundleFile.extractNestedJar(this.jarFile, path, dest);
                nested.add(new NestedJarBundleFile(location, dest));
            }
            catch (FileNotFoundException e) {
                log.error((Object)("A nested jar is referenced in manifest but not found: " + location));
            }
            catch (IOException e) {
                log.error((Object)e);
            }
        }
        return nested;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extractNestedJar(JarFile file, String path, File dest) throws IOException {
        ZipEntry entry = file.getEntry(path);
        try (InputStream in = null;){
            in = file.getInputStream(entry);
            FileUtils.copyToFile((InputStream)in, (File)dest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extractNestedJar(JarFile file, ZipEntry entry, File dest) throws IOException {
        try (InputStream in = null;){
            in = file.getInputStream(entry);
            FileUtils.copyToFile((InputStream)in, (File)dest);
        }
    }

    @Override
    public Collection<BundleFile> findNestedBundles(File tmpDir) throws IOException {
        URL base = new URL("jar:" + new File(this.jarFile.getName()).toURI().toURL().toExternalForm() + "!/");
        String fileName = this.getFileName();
        Enumeration<JarEntry> entries = this.jarFile.entries();
        ArrayList<BundleFile> nested = new ArrayList<BundleFile>();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String path = entry.getName();
            if (!entry.getName().endsWith(".jar")) continue;
            String location = base + path;
            String name = path.replace('/', '_');
            File dest = new File(tmpDir, fileName + '-' + name);
            JarBundleFile.extractNestedJar(this.jarFile, entry, dest);
            nested.add(new NestedJarBundleFile(location, dest));
        }
        return nested;
    }

    @Override
    public String getSymbolicName() {
        try {
            String value = this.jarFile.getManifest().getMainAttributes().getValue("Bundle-SymbolicName");
            return value != null ? BundleManifestReader.removePropertiesFromHeaderValue(value) : null;
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public URL getURL() {
        try {
            return new File(this.jarFile.getName()).toURI().toURL();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public URL getJarURL() {
        try {
            String url = new File(this.jarFile.getName()).toURI().toURL().toExternalForm();
            return new URL("jar:" + url + "!/");
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public boolean isJar() {
        return true;
    }

    public String toString() {
        return this.getLocation();
    }

    protected final URL getEntryUrl(String name) throws MalformedURLException {
        return new URL(this.urlBase + name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(OSGiAdapter osgi) throws IOException {
        if (this.jarFile == null) {
            return;
        }
        try {
            osgi.getURLJarFileCloser().close(this.jarFile);
        }
        finally {
            this.jarFile = null;
        }
    }
}

