/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.io.streams;

import com.phloc.commons.io.streams.StreamUtils;
import com.phloc.commons.string.ToStringGenerator;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitOutputStream
implements Closeable,
Flushable {
    private static final Logger s_aLogger = LoggerFactory.getLogger(BitOutputStream.class);
    private final Lock m_aLock = new ReentrantLock();
    private OutputStream m_aOS;
    private final boolean m_bHighOrderBitFirst;
    private int m_nBuffer;
    private int m_nBufferedBitCount;

    public BitOutputStream(@Nonnull OutputStream outputStream, boolean bl) {
        if (outputStream == null) {
            throw new NullPointerException("outputStream");
        }
        this.m_aOS = outputStream;
        this.m_bHighOrderBitFirst = bl;
        this.m_nBufferedBitCount = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeBit(int n) throws IOException {
        if (this.m_aOS == null) {
            throw new IllegalStateException("Already closed");
        }
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException(n + " is not a bit");
        }
        this.m_aLock.lock();
        try {
            if (n == 1) {
                this.m_nBuffer = this.m_bHighOrderBitFirst ? (this.m_nBuffer |= n << 7 - this.m_nBufferedBitCount) : (this.m_nBuffer |= n << this.m_nBufferedBitCount);
            }
            if (++this.m_nBufferedBitCount == 8) {
                this.flush();
            }
        }
        finally {
            this.m_aLock.unlock();
        }
    }

    public void writeBits(int n, @Nonnegative int n2) throws IOException {
        if (n2 < 1 || n2 > 32) {
            throw new IllegalArgumentException("Illegal number of bits to write: " + n2);
        }
        for (int i = n2 - 1; i >= 0; --i) {
            this.writeBit(n >> i & 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        this.m_aLock.lock();
        try {
            if (this.m_nBufferedBitCount > 0) {
                if (this.m_nBufferedBitCount != 8) {
                    s_aLogger.warn("Flushing BitOutputStream with only " + this.m_nBufferedBitCount + " bits");
                }
                this.m_aOS.write((byte)this.m_nBuffer);
                this.m_nBufferedBitCount = 0;
                this.m_nBuffer = 0;
            }
        }
        finally {
            this.m_aLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.m_aLock.lock();
        try {
            StreamUtils.flush(this);
            StreamUtils.close(this.m_aOS);
            this.m_aOS = null;
        }
        finally {
            this.m_aLock.unlock();
        }
    }

    public String toString() {
        return new ToStringGenerator(this).append("OS", this.m_aOS).append("highOrderBitFirst", this.m_bHighOrderBitFirst).append("buffer", this.m_nBuffer).append("bitCount", this.m_nBufferedBitCount).toString();
    }
}

