/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives.adapters;

import com.phloc.commons.annotations.ReturnsMutableCopy;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import javax.annotation.Nonnull;
import org.apache.commons.collections.primitives.LongCollection;
import org.apache.commons.collections.primitives.adapters.CollectionLongCollection;
import org.apache.commons.collections.primitives.adapters.LongIteratorIterator;

abstract class AbstractLongCollectionCollection
implements Collection<Long> {
    AbstractLongCollectionCollection() {
    }

    @Nonnull
    protected abstract LongCollection getLongCollection();

    @Override
    public boolean add(Long l) {
        return this.getLongCollection().add(l);
    }

    @Override
    public boolean addAll(Collection<? extends Long> collection) {
        return this.getLongCollection().addAll(CollectionLongCollection.wrap(collection));
    }

    @Override
    public void clear() {
        this.getLongCollection().clear();
    }

    @Override
    public boolean contains(Object object) {
        return this.getLongCollection().contains((Long)object);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.getLongCollection().containsAll(CollectionLongCollection.wrap(collection));
    }

    public String toString() {
        return this.getLongCollection().toString();
    }

    @Override
    public boolean isEmpty() {
        return this.getLongCollection().isEmpty();
    }

    @Override
    public Iterator<Long> iterator() {
        return LongIteratorIterator.wrap(this.getLongCollection().iterator());
    }

    @Override
    public boolean remove(Object object) {
        return this.getLongCollection().removeElement((Long)object);
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return this.getLongCollection().removeAll(CollectionLongCollection.wrap(collection));
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return this.getLongCollection().retainAll(CollectionLongCollection.wrap(collection));
    }

    @Override
    public int size() {
        return this.getLongCollection().size();
    }

    @Nonnull
    @ReturnsMutableCopy
    public Long[] toArray() {
        long[] lArray = this.getLongCollection().toArray();
        Long[] longArray = new Long[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            longArray[i] = lArray[i];
        }
        return longArray;
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        Long[] longArray = this.toArray();
        int n = this.size();
        if (TArray.length < n) {
            return Arrays.copyOf(longArray, n, TArray.getClass());
        }
        System.arraycopy(longArray, 0, TArray, 0, n);
        if (TArray.length > n) {
            TArray[n] = null;
        }
        return TArray;
    }
}

