/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.component.file;

import java.io.InputStream;
import java.io.Serializable;
import javax.faces.convert.ConverterException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.platform.ui.web.component.file.InputFileChoice;
import org.nuxeo.ecm.platform.ui.web.util.files.FileUtils;

public class InputFileInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(InputFileInfo.class);
    public static final String INVALID_FILE_MESSAGE = "error.inputFile.invalidFile";
    public static final String INVALID_WITH_AJAX_MESSAGE = "error.inputFile.ajax";
    protected Object choice;
    protected Object blob;
    protected Object filename;
    protected Object mimeType;

    public InputFileInfo() {
    }

    public InputFileInfo(Object choice, Object blob, Object filename, Object mimeType) {
        this.choice = choice;
        this.blob = blob;
        this.filename = filename;
        this.mimeType = mimeType;
    }

    public Object getBlob() {
        return this.blob;
    }

    public void setBlob(Object blob) {
        this.blob = blob;
    }

    public Object getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(Object mimeType) {
        this.mimeType = mimeType;
    }

    public String getConvertedMimeType() throws ConverterException {
        if (this.mimeType instanceof String) {
            return (String)this.mimeType;
        }
        if (this.mimeType != null) {
            log.error((Object)("Invalid mimetype detected: " + this.mimeType));
        }
        return null;
    }

    public Blob getConvertedBlob() throws ConverterException {
        Blob convertedBlob = null;
        if (this.blob instanceof Blob) {
            convertedBlob = (Blob)this.blob;
        } else if (this.blob instanceof InputStream) {
            InputStream upFile = (InputStream)this.blob;
            try {
                if (upFile.available() == 0) {
                    throw new ConverterException(INVALID_FILE_MESSAGE);
                }
                convertedBlob = FileUtils.createSerializableBlob(upFile, this.getConvertedFilename(), this.getConvertedMimeType());
            }
            catch (ConverterException e) {
            }
            catch (Exception e) {
                throw new ConverterException(INVALID_FILE_MESSAGE);
            }
        } else if (this.blob != null) {
            throw new ConverterException(INVALID_FILE_MESSAGE);
        }
        return convertedBlob;
    }

    public Object getChoice() {
        return this.choice;
    }

    public void setChoice(Object choice) {
        this.choice = choice;
    }

    public InputFileChoice getConvertedChoice() throws ConverterException {
        InputFileChoice convertedChoice = null;
        if (this.choice instanceof InputFileChoice) {
            convertedChoice = (InputFileChoice)((Object)this.choice);
        } else if (this.choice instanceof String) {
            String stringChoice = (String)this.choice;
            try {
                convertedChoice = InputFileChoice.valueOf(stringChoice);
            }
            catch (Exception err) {
                throw new ConverterException("error.inputFile.invalidChoice");
            }
        } else if (this.choice != null) {
            throw new ConverterException("error.inputFile.invalidChoice");
        }
        return convertedChoice;
    }

    public Object getFilename() {
        return this.filename;
    }

    public void setFilename(Object filename) {
        this.filename = filename;
    }

    public String getConvertedFilename() throws ConverterException {
        String convertedFilename = null;
        if (this.filename instanceof String) {
            convertedFilename = FileUtils.getCleanFileName((String)this.filename);
        } else if (this.filename != null) {
            throw new ConverterException("error.inputFile.invalidFilename");
        }
        return convertedFilename;
    }

    protected static boolean equalValues(Object first, Object second) {
        if (first == null) {
            return second == null;
        }
        return first.equals(second);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof InputFileInfo)) {
            return false;
        }
        InputFileInfo other = (InputFileInfo)obj;
        if (!InputFileInfo.equalValues(this.choice, other.choice)) {
            return false;
        }
        if (!InputFileInfo.equalValues(this.filename, other.filename)) {
            return false;
        }
        if (!InputFileInfo.equalValues(this.blob, other.blob)) {
            return false;
        }
        return InputFileInfo.equalValues(this.mimeType, other.mimeType);
    }
}

