/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.rendition.publisher;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Unwrap;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.platform.rendition.service.RenditionService;
import org.nuxeo.runtime.api.Framework;

@Name(value="renditionService")
@Scope(value=ScopeType.SESSION)
public class RenditionBusinessDelegate
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(RenditionBusinessDelegate.class);
    protected RenditionService renditionService;

    @Unwrap
    public RenditionService getService() throws ClientException {
        if (this.renditionService == null) {
            try {
                this.renditionService = (RenditionService)Framework.getService(RenditionService.class);
            }
            catch (Exception e) {
                String errMsg = "Error connecting to RenditionService. " + e.getMessage();
                throw new ClientException(errMsg, (Throwable)e);
            }
            if (this.renditionService == null) {
                throw new ClientException("ContentViewService service not bound");
            }
        }
        return this.renditionService;
    }

    @Destroy
    public void destroy() {
        if (this.renditionService != null) {
            this.renditionService = null;
        }
        log.debug((Object)"Destroyed the seam component");
    }
}

