/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.packages;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.connect.NuxeoConnectClient;
import org.nuxeo.connect.connector.ConnectServerError;
import org.nuxeo.connect.data.DownloadablePackage;
import org.nuxeo.connect.packages.AbstractPackageSource;
import org.nuxeo.connect.packages.PackageListCache;
import org.nuxeo.connect.packages.PackageSource;
import org.nuxeo.connect.registration.ConnectRegistrationService;
import org.nuxeo.connect.update.PackageType;

public class RemotePackageSource
extends AbstractPackageSource
implements PackageSource {
    protected static final Log log = LogFactory.getLog(RemotePackageSource.class);
    protected PackageListCache cache = new PackageListCache();

    public RemotePackageSource() {
        this.id = "remote";
        this.name = "Connect Server";
    }

    @Override
    public List<DownloadablePackage> listPackages() {
        ArrayList<DownloadablePackage> all = new ArrayList<DownloadablePackage>();
        for (PackageType type : PackageType.values()) {
            all.addAll(this.listPackages(type));
        }
        return all;
    }

    @Override
    public List<DownloadablePackage> listStudioPackages() {
        if (!NuxeoConnectClient.getConnectGatewayComponent().isInstanceRegistred()) {
            log.info((Object)"Server is not registered");
            return new ArrayList<DownloadablePackage>();
        }
        List<DownloadablePackage> result = this.cache.getFromCache("StudioRegistered");
        if (result != null) {
            return result;
        }
        try {
            ConnectRegistrationService crs = NuxeoConnectClient.getConnectRegistrationService();
            result = crs.getConnector().getRegisteredStudio();
            this.cache.add(result, "StudioRegistered");
        }
        catch (ConnectServerError e) {
            log.debug((Object)e, (Throwable)e);
            log.warn((Object)("Unable to fetch remote packages list: " + e.getMessage()));
        }
        return result;
    }

    @Override
    public List<DownloadablePackage> listPackages(PackageType type) {
        if (type == null) {
            return this.listPackages();
        }
        List<DownloadablePackage> result = this.cache.getFromCache(type.toString());
        if (result != null) {
            return result;
        }
        try {
            ConnectRegistrationService crs = NuxeoConnectClient.getConnectRegistrationService();
            result = crs.getConnector().getDownloads(type);
        }
        catch (ConnectServerError e) {
            log.debug((Object)e, (Throwable)e);
            log.warn((Object)("Unable to fetch remote packages list: " + e.getMessage()));
            result = new ArrayList<DownloadablePackage>();
        }
        this.cache.add(result, type.toString());
        return result;
    }

    @Override
    public void flushCache() {
        this.cache = new PackageListCache();
        ConnectRegistrationService crs = NuxeoConnectClient.getConnectRegistrationService();
        crs.getConnector().flushCache();
    }

    @Override
    public DownloadablePackage getPackageById(String packageId) {
        DownloadablePackage pkg = this.cache.getPackageByID(packageId);
        if (pkg == null) {
            ConnectRegistrationService crs = NuxeoConnectClient.getConnectRegistrationService();
            try {
                pkg = crs.getConnector().getDownload(packageId);
            }
            catch (ConnectServerError e) {
                log.debug((Object)e, (Throwable)e);
                log.warn((Object)("Unable to fetch remote package '" + packageId + "': " + e.getMessage()));
            }
            if (pkg != null) {
                this.cache.add(pkg);
            }
        }
        return pkg;
    }

    @Override
    public Collection<? extends DownloadablePackage> listPackagesByName(String packageName) {
        ArrayList<DownloadablePackage> result = new ArrayList<DownloadablePackage>();
        for (PackageType type : PackageType.values()) {
            for (DownloadablePackage pkg : this.listPackages(type)) {
                if (!packageName.equals(pkg.getName())) continue;
                result.add(pkg);
            }
        }
        return result;
    }
}

