/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.io.services.enricher;

import java.io.IOException;
import org.codehaus.jackson.JsonGenerator;
import org.nuxeo.ecm.automation.io.services.enricher.AbstractContentEnricher;
import org.nuxeo.ecm.automation.io.services.enricher.RestEvaluationContext;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.preview.helper.PreviewHelper;
import org.nuxeo.runtime.api.Framework;

public class PreviewContentEnricher
extends AbstractContentEnricher {
    public static final String PREVIEW_URL_LABEL = "url";
    public static final String PREVIEW_CONTENT_ID = "preview";

    @Override
    public void enrich(JsonGenerator jg, RestEvaluationContext ec) throws ClientException, IOException {
        DocumentModel doc = ec.getDocumentModel();
        String relativeUrl = PreviewHelper.getPreviewURL((DocumentModel)doc);
        jg.writeStartObject();
        if (relativeUrl != null && !relativeUrl.isEmpty()) {
            String url = Framework.getProperty((String)"nuxeo.url") + "/" + PreviewHelper.getPreviewURL((DocumentModel)doc);
            jg.writeStringField(PREVIEW_URL_LABEL, url);
        } else {
            this.writeEmptyURL(jg);
        }
        jg.writeEndObject();
        jg.flush();
    }

    private void writeEmptyURL(JsonGenerator jg) throws IOException {
        jg.writeStringField(PREVIEW_URL_LABEL, null);
    }
}

