/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.datasource;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.JDBCUtils;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.datasource.DataSourceFromUrl;
import org.nuxeo.runtime.datasource.DataSourceHelper;
import org.nuxeo.runtime.datasource.PooledDataSourceRegistry;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class ConnectionHelper {
    private static final Log log = LogFactory.getLog(ConnectionHelper.class);
    private static ConcurrentMap<Transaction, SharedConnection> sharedConnections = new ConcurrentHashMap<Transaction, SharedConnection>();
    private static ConcurrentMap<Transaction, SharedConnectionSynchronization> sharedSynchronizations = new ConcurrentHashMap<Transaction, SharedConnectionSynchronization>();
    public static final String SINGLE_DS = "nuxeo.db.singleDataSource";
    public static final String EXCLUDE_DS = "nuxeo.db.singleDataSource.exclude";

    private static Transaction getTransaction() {
        try {
            return TransactionHelper.lookupTransactionManager().getTransaction();
        }
        catch (NamingException | SystemException e) {
            return null;
        }
    }

    private static int transactionStatus(Transaction transaction) {
        try {
            return transaction.getStatus();
        }
        catch (SystemException e) {
            log.error((Object)"Cannot get transaction status", (Throwable)e);
            return 5;
        }
    }

    public static Connection unwrap(Connection connection) throws SQLException {
        InvocationHandler handler;
        if (Proxy.isProxyClass(connection.getClass()) && (handler = Proxy.getInvocationHandler(connection)) instanceof ConnectionHandle) {
            ConnectionHandle h = (ConnectionHandle)handler;
            connection = h.getUnwrappedConnection();
        }
        if (connection instanceof org.tranql.connector.jdbc.ConnectionHandle) {
            return (Connection)((org.tranql.connector.jdbc.ConnectionHandle)connection).getAssociation().getPhysicalConnection();
        }
        try {
            Method m = connection.getClass().getMethod("getInnermostDelegate", new Class[0]);
            m.setAccessible(true);
            Connection delegate = (Connection)m.invoke((Object)connection, new Object[0]);
            if (delegate == null) {
                log.error((Object)"Cannot access underlying connection, you must use accessToUnderlyingConnectionAllowed=true in the pool configuration");
            } else {
                connection = delegate;
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            // empty catch block
        }
        return connection;
    }

    public static boolean useSingleConnection(String dataSourceName) {
        if (dataSourceName != null) {
            String excludes = Framework.getProperty((String)EXCLUDE_DS);
            if ("*".equals(excludes)) {
                return false;
            }
            if (!StringUtils.isBlank((String)excludes)) {
                for (String exclude : excludes.split("[, ] *")) {
                    if (!dataSourceName.equals(exclude) && !dataSourceName.equals(DataSourceHelper.getDataSourceJNDIName(exclude))) continue;
                    return false;
                }
            }
        }
        return !StringUtils.isBlank((String)Framework.getProperty((String)SINGLE_DS));
    }

    public static String getPseudoDataSourceNameForRepository(String repositoryName) {
        return "repository_" + repositoryName;
    }

    public static Connection getConnection(String dataSourceName) throws SQLException {
        return ConnectionHelper.getConnection(dataSourceName, false);
    }

    public static Connection getConnection(String dataSourceName, boolean noSharing) throws SQLException {
        if (!ConnectionHelper.useSingleConnection(dataSourceName)) {
            DataSource ds = ConnectionHelper.getDataSource(dataSourceName);
            if (ds instanceof PooledDataSourceRegistry.PooledDataSource) {
                return ((PooledDataSourceRegistry.PooledDataSource)ds).getConnection(noSharing);
            }
            return ConnectionHelper.getPhysicalConnection(dataSourceName);
        }
        return ConnectionHelper.getConnection(noSharing);
    }

    private static Connection getConnection(boolean noSharing) throws SQLException {
        String dataSourceName = Framework.getProperty((String)SINGLE_DS);
        if (StringUtils.isBlank((String)dataSourceName)) {
            return null;
        }
        if (noSharing) {
            return ConnectionHelper.getPhysicalConnection(dataSourceName);
        }
        return (Connection)Proxy.newProxyInstance(Connection.class.getClassLoader(), new Class[]{Connection.class}, (InvocationHandler)new ConnectionHandle());
    }

    private static Connection getPhysicalConnection() throws SQLException {
        return ConnectionHelper.getPhysicalConnection(Framework.getProperty((String)SINGLE_DS));
    }

    private static Connection getPhysicalConnection(String dataSourceName) throws SQLException {
        DataSource dataSource = ConnectionHelper.getDataSource(dataSourceName);
        return JDBCUtils.getConnection((DataSource)dataSource);
    }

    private static DataSource getDataSource(String dataSourceName) throws SQLException {
        try {
            return DataSourceHelper.getDataSource(dataSourceName);
        }
        catch (NamingException e) {
            if (Framework.isTestModeSet()) {
                String url = Framework.getProperty((String)"nuxeo.test.vcs.url");
                String user = Framework.getProperty((String)"nuxeo.test.vcs.user");
                String password = Framework.getProperty((String)"nuxeo.test.vcs.password");
                if (url != null && user != null) {
                    return new DataSourceFromUrl(url, user, password);
                }
            }
            throw new SQLException("Cannot find datasource: " + dataSourceName, e);
        }
    }

    public static int countConnectionReferences() {
        return sharedConnections.size();
    }

    public static void clearConnectionReferences() {
        for (SharedConnection sharedConnection : sharedConnections.values()) {
            sharedConnection.closeAfterTransaction(true);
        }
        sharedConnections.clear();
    }

    public static boolean registerSynchronization(Synchronization sync) throws SystemException {
        return ConnectionHelper.registerSynchronization(sync, true);
    }

    public static boolean registerSynchronizationLast(Synchronization sync) throws SystemException {
        return ConnectionHelper.registerSynchronization(sync, false);
    }

    private static boolean registerSynchronization(Synchronization sync, boolean first) throws SystemException {
        Transaction transaction = ConnectionHelper.getTransaction();
        if (transaction == null) {
            throw new SystemException("Cannot register synchronization: no transaction");
        }
        SharedConnectionSynchronization scs = SharedConnectionSynchronization.getInstance(transaction);
        scs.registerSynchronization(sync, first);
        return true;
    }

    private static class SharedConnectionSynchronization
    implements Synchronization {
        private final Transaction transaction;
        private final List<Synchronization> syncsFirst;
        private final List<Synchronization> syncsLast;

        public static SharedConnectionSynchronization getInstance(Transaction transaction) {
            SharedConnectionSynchronization scs = (SharedConnectionSynchronization)sharedSynchronizations.get(transaction);
            if (scs == null) {
                scs = new SharedConnectionSynchronization(transaction);
                try {
                    transaction.registerSynchronization((Synchronization)scs);
                }
                catch (IllegalStateException | RollbackException | SystemException e) {
                    throw new RuntimeException("Cannot register synchronization", e);
                }
                sharedSynchronizations.put(transaction, scs);
            }
            return scs;
        }

        public SharedConnectionSynchronization(Transaction transaction) {
            this.transaction = transaction;
            this.syncsFirst = new ArrayList<Synchronization>(5);
            this.syncsLast = new ArrayList<Synchronization>(5);
        }

        public void registerSynchronization(Synchronization sync, boolean first) {
            if (first) {
                this.syncsFirst.add(sync);
            } else {
                this.syncsLast.add(sync);
            }
        }

        public void beforeCompletion() {
            this.beforeCompletion(this.syncsFirst);
            this.beforeCompletion(this.syncsLast);
        }

        private void beforeCompletion(List<Synchronization> syncs) {
            RuntimeException exc = null;
            for (int i = 0; i < syncs.size(); ++i) {
                try {
                    syncs.get(i).beforeCompletion();
                    continue;
                }
                catch (RuntimeException e) {
                    log.error((Object)"Exception during beforeCompletion hook", (Throwable)e);
                    if (exc != null) continue;
                    exc = e;
                    try {
                        this.transaction.setRollbackOnly();
                        continue;
                    }
                    catch (SystemException se) {
                        log.error((Object)"Cannot set rollback only", (Throwable)e);
                    }
                }
            }
            if (exc != null) {
                throw exc;
            }
        }

        public void afterCompletion(int status) {
            sharedSynchronizations.remove(this.transaction);
            this.afterCompletion(this.syncsFirst, status);
            this.closeSharedAfterCompletion(status == 4);
            this.afterCompletion(this.syncsLast, status);
        }

        private void closeSharedAfterCompletion(boolean rollback) {
            SharedConnection sharedConnection = (SharedConnection)sharedConnections.remove(this.transaction);
            if (sharedConnection != null) {
                sharedConnection.closeAfterTransaction(rollback);
            }
        }

        private void afterCompletion(List<Synchronization> syncs, int status) {
            for (Synchronization sync : syncs) {
                try {
                    sync.afterCompletion(status);
                }
                catch (RuntimeException e) {
                    log.warn((Object)"Unexpected exception from afterCompletion; continuing", (Throwable)e);
                }
            }
        }
    }

    private static class SharedConnection {
        private Connection connection;
        private final List<ConnectionHandle> handles;
        private boolean mustRollback;

        public SharedConnection(Connection connection) {
            this.connection = connection;
            this.handles = new ArrayList<ConnectionHandle>(3);
        }

        private void logInvoke(String message) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Invoke shared " + message + " " + this));
            }
        }

        public Connection getConnection() {
            return this.connection;
        }

        public void begin(ConnectionHandle handle) throws SQLException {
            this.ref(handle);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void commit(ConnectionHandle handle) throws SQLException {
            try {
                if (this.handles.size() == 1) {
                    if (this.mustRollback) {
                        this.logInvoke("rollback");
                        this.mustRollback = false;
                    }
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)("commit not yet closing " + this));
                }
            }
            finally {
                this.unref(handle);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void rollback(ConnectionHandle handle) throws SQLException {
            try {
                if (this.handles.size() == 1) {
                    this.logInvoke("rollback");
                    this.mustRollback = false;
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("setting rollback only " + this));
                    }
                    this.mustRollback = true;
                }
            }
            finally {
                this.unref(handle);
            }
        }

        private void ref(ConnectionHandle handle) throws SQLException {
            if (this.handles.isEmpty() && this.connection == null) {
                this.allocate();
            }
            this.handles.add(handle);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Reference added for " + this));
            }
        }

        private void unref(ConnectionHandle handle) throws SQLException {
            this.handles.remove(handle);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Reference removed for " + this));
            }
        }

        private void allocate() throws SQLException {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Constructing physical connection " + this));
                if (log.isTraceEnabled()) {
                    log.trace((Object)"Constructing physical connection stacktrace", (Throwable)new Exception("debug"));
                }
            }
            this.connection = ConnectionHelper.getPhysicalConnection();
            this.logInvoke("setAutoCommit false");
            this.connection.setAutoCommit(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void closeAfterTransaction(boolean mustRollback) {
            if (!this.handles.isEmpty()) {
                log.error((Object)("Transaction ended with " + this.handles.size() + " connections not committed " + this + " " + this.handles));
            }
            if (this.connection == null) {
                return;
            }
            try {
                if (mustRollback) {
                    this.connection.rollback();
                } else {
                    this.connection.commit();
                }
            }
            catch (SQLException cause) {
                log.error((Object)"Could not close endup connection at transaction end", (Throwable)cause);
            }
            finally {
                this.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void close() {
            try {
                this.logInvoke("close");
                this.connection.close();
            }
            catch (SQLException e) {
                log.error((Object)"Could not close leftover connection at transaction end", (Throwable)e);
            }
            finally {
                this.connection = null;
                for (ConnectionHandle h : this.handles) {
                    h.closeFromSharedConnection();
                }
                this.handles.clear();
            }
        }

        public String toString() {
            return this.getClass().getSimpleName() + "@" + Integer.toHexString(System.identityHashCode(this));
        }
    }

    private static class ConnectionHandle
    implements InvocationHandler {
        private boolean closed;
        private boolean autoCommit = true;
        private Transaction transactionForShare;
        private Connection localConnection;
        private SharedConnection sharedConnection;
        private boolean began;

        public ConnectionHandle() {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Construct " + this));
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Construct stacktrace " + this), (Throwable)new Exception("debug"));
                }
            }
        }

        private void logInvoke(String message) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Invoke " + message + " " + this));
            }
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Connection connection;
            String methodName = method.getName();
            if (methodName.equals("isClosed")) {
                return this.isClosed();
            }
            if (methodName.equals("close")) {
                this.close();
                return null;
            }
            if (this.closed) {
                throw new SQLException("Connection is closed", "08003");
            }
            if (methodName.equals("getAutoCommit")) {
                return this.getAutoCommit();
            }
            if (methodName.equals("setAutoCommit")) {
                this.setAutoCommit((Boolean)args[0]);
                return null;
            }
            if (this.transactionForShare != null) {
                Transaction transaction = ConnectionHelper.getTransaction();
                if (transaction != this.transactionForShare) {
                    throw new SQLException("Calling method " + methodName + ", connection sharing started in transaction " + this.transactionForShare + " but it is now used in transaction " + transaction);
                }
                this.sharedConnectionAllocate();
                if (methodName.equals("commit")) {
                    if (this.autoCommit) {
                        throw new SQLException("Cannot commit outside of transaction", "25000");
                    }
                    this.sharedConnectionCommit();
                    return null;
                }
                if (methodName.equals("rollback")) {
                    if (this.autoCommit) {
                        throw new SQLException("Cannot commit outside of transaction", "25000");
                    }
                    if (args != null && args.length > 0) {
                        throw new SQLException("Not implemented: rollback(Savepoint)", "0A000");
                    }
                    this.sharedConnectionRollback();
                    return null;
                }
                if (methodName.equals("setSavepoint") || methodName.equals("releaseSavepoint")) {
                    throw new SQLException("Not implemented: " + methodName, "0A000");
                }
                this.sharedConnectionBegin(methodName);
                connection = this.sharedConnection.getConnection();
            } else {
                this.localConnectionAllocate();
                connection = this.localConnection;
            }
            try {
                if (log.isDebugEnabled()) {
                    if (this.sharedConnection == null) {
                        this.logInvoke(methodName);
                    } else {
                        this.logInvoke(methodName + " " + this.sharedConnection);
                    }
                }
                return method.invoke((Object)connection, args);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }

        private Boolean getAutoCommit() {
            return this.autoCommit;
        }

        private void setAutoCommit(boolean setAutoCommit) throws SQLException {
            if (setAutoCommit == this.autoCommit) {
                return;
            }
            this.autoCommit = setAutoCommit;
            if (log.isDebugEnabled()) {
                log.debug((Object)("setAutoCommit(" + this.autoCommit + ") " + this));
            }
            if (!this.autoCommit) {
                if (this.transactionForShare != null) {
                    throw new AssertionError((Object)"autoCommit=false when already sharing");
                }
                Transaction transaction = ConnectionHelper.getTransaction();
                if (transaction != null && ConnectionHelper.transactionStatus(transaction) == 0) {
                    this.transactionForShare = transaction;
                    if (this.localConnection != null) {
                        this.logInvoke("setAutoCommit false");
                        this.localConnection.setAutoCommit(false);
                        log.debug((Object)"Upgrading local connection to shared");
                        this.sharedConnection = this.getSharedConnection(this.localConnection);
                        this.localConnection = null;
                    }
                } else {
                    log.debug((Object)"No usable transaction");
                    if (this.localConnection != null) {
                        this.logInvoke("setAutoCommit false");
                        this.localConnection.setAutoCommit(false);
                    }
                }
            } else if (this.transactionForShare != null) {
                if (this.began) {
                    log.debug((Object)"setAutoCommit true committing shared");
                    this.sharedConnectionCommit();
                }
                this.sharedConnection = null;
                this.transactionForShare = null;
            } else if (this.localConnection != null) {
                this.logInvoke("setAutoCommit true");
                this.localConnection.setAutoCommit(true);
            }
        }

        private void localConnectionAllocate() throws SQLException {
            if (this.localConnection == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Constructing physical connection " + this));
                    if (log.isTraceEnabled()) {
                        log.trace((Object)"Constructing physical connection stacktrace", (Throwable)new Exception("debug"));
                    }
                }
                this.localConnection = ConnectionHelper.getPhysicalConnection();
                this.logInvoke("setAutoCommit " + this.autoCommit);
                this.localConnection.setAutoCommit(this.autoCommit);
            }
        }

        private void sharedConnectionAllocate() throws SQLException {
            if (this.sharedConnection == null && ConnectionHelper.transactionStatus(this.transactionForShare) == 0) {
                this.sharedConnection = this.getSharedConnection(null);
            }
        }

        private void sharedConnectionBegin(String methodName) throws SQLException {
            if (this.sharedConnection == null) {
                throw new SQLException("Cannot call " + methodName + " with transaction in state " + ConnectionHelper.transactionStatus(this.transactionForShare), "25000");
            }
            if (!this.autoCommit && !this.began) {
                this.sharedConnection.begin(this);
                this.began = true;
            }
        }

        private void sharedConnectionCommit() throws SQLException {
            if (this.began) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Committing shared " + this));
                }
                this.sharedConnection.commit(this);
                this.began = false;
            }
        }

        private void sharedConnectionRollback() throws SQLException {
            if (this.began) {
                this.sharedConnection.rollback(this);
                this.began = false;
            }
        }

        protected void closeFromSharedConnection() {
            this.sharedConnection = null;
            this.transactionForShare = null;
        }

        private Boolean isClosed() {
            return this.closed;
        }

        private void close() throws SQLException {
            if (!this.closed) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("close() " + this));
                }
                if (this.transactionForShare != null) {
                    if (this.sharedConnection != null) {
                        if (this.began) {
                            log.debug((Object)"close committing shared");
                            this.sharedConnectionCommit();
                        }
                        this.sharedConnection = null;
                    }
                    this.transactionForShare = null;
                } else if (this.localConnection != null) {
                    this.logInvoke("close");
                    this.localConnection.close();
                    this.localConnection = null;
                }
                this.closed = true;
            }
        }

        public Connection getUnwrappedConnection() throws SQLException {
            Connection connection = this.sharedConnection != null ? this.sharedConnection.getConnection() : this.localConnection;
            if (connection == null) {
                throw new SQLException("Connection not allocated");
            }
            return connection;
        }

        private SharedConnection getSharedConnection(Connection connection) throws SQLException {
            SharedConnection sharedConnection = (SharedConnection)sharedConnections.get(this.transactionForShare);
            if (sharedConnection == null) {
                sharedConnection = new SharedConnection(connection);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Allocating new shared connection " + sharedConnection + " for " + this));
                }
                if (sharedConnections.putIfAbsent(this.transactionForShare, sharedConnection) != null) {
                    throw new AssertionError((Object)"Race condition in single transaction!");
                }
                SharedConnectionSynchronization.getInstance(this.transactionForShare);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Reusing shared connection " + sharedConnection + " for " + this));
                }
                if (connection != null) {
                    log.debug((Object)"Dropping previous local connection");
                    this.logInvoke("close");
                    connection.close();
                }
            }
            return sharedConnection;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "@" + Integer.toHexString(System.identityHashCode(this));
        }
    }
}

