/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.rest;

import java.util.List;
import javax.ws.rs.GET;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.rest.DocumentObject;
import org.nuxeo.ecm.platform.audit.api.LogEntry;
import org.nuxeo.ecm.platform.audit.api.Logs;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.model.View;
import org.nuxeo.ecm.webengine.model.WebAdapter;
import org.nuxeo.ecm.webengine.model.impl.DefaultAdapter;
import org.nuxeo.runtime.api.Framework;

@WebAdapter(name="audits", type="AuditService", targetType="Document")
public class AuditService
extends DefaultAdapter {
    protected Logs guardedService() {
        Logs service;
        try {
            service = (Logs)Framework.getService(Logs.class);
        }
        catch (Exception e) {
            throw WebException.wrap((String)"Failed to get audit service", (Throwable)e);
        }
        if (service == null) {
            throw new WebException("Failed to get audit service");
        }
        return service;
    }

    @GET
    public Object doGet() {
        return new View(this.getTarget(), "audits").resolve();
    }

    public List<LogEntry> getAudits() {
        Logs logs = this.guardedService();
        DocumentObject document = (DocumentObject)this.getTarget();
        DocumentModel model = document.getAdapter(DocumentModel.class);
        String id = model.getId();
        return logs.getLogEntriesFor(id);
    }
}

