/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.usermanager.providers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DataModel;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.directory.SizeLimitExceededException;
import org.nuxeo.ecm.platform.query.api.AbstractPageProvider;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.platform.usermanager.providers.UsersPageProvider;
import org.nuxeo.runtime.api.Framework;

public abstract class AbstractUsersPageProvider<T>
extends AbstractPageProvider<T> {
    private static final Log log = LogFactory.getLog(UsersPageProvider.class);
    private static final long serialVersionUID = 1L;
    protected static final String USERS_LISTING_MODE_PROPERTY = "usersListingMode";
    protected static final String ALL_MODE = "all";
    protected static final String SEARCH_ONLY_MODE = "search_only";
    protected static final String TABBED_MODE = "tabbed";
    protected static final String SEARCH_OVERFLOW_ERROR_MESSAGE = "label.security.searchOverFlow";
    protected Map<String, DocumentModelList> userCatalog;
    protected List<DocumentModel> pageUsers;

    protected List<DocumentModel> computeCurrentPage() {
        if (this.pageUsers == null) {
            this.error = null;
            this.errorMessage = null;
            this.pageUsers = new ArrayList<DocumentModel>();
            List<Object> users = new ArrayList();
            try {
                UserManager userManager = (UserManager)Framework.getLocalService(UserManager.class);
                String userListingMode = this.getUserListingMode();
                if (ALL_MODE.equals(userListingMode)) {
                    users = this.searchAllUsers(userManager);
                } else if (SEARCH_ONLY_MODE.equals(userListingMode)) {
                    users = this.searchUsers(userManager);
                } else if (TABBED_MODE.equals(userListingMode)) {
                    users = this.searchUsersFromCatalog(userManager);
                }
            }
            catch (SizeLimitExceededException slee) {
                this.error = slee;
                this.errorMessage = SEARCH_OVERFLOW_ERROR_MESSAGE;
                log.warn((Object)slee.getMessage(), (Throwable)slee);
            }
            catch (ClientException e) {
                this.error = e;
                this.errorMessage = e.getMessage();
                log.warn((Object)e.getMessage(), (Throwable)e);
            }
            if (!this.hasError()) {
                long resultsCount = users.size();
                this.setResultsCount(resultsCount);
                long pageSize = this.getMinMaxPageSize();
                if (pageSize == 0L) {
                    this.pageUsers.addAll(users);
                } else {
                    long offset = this.getCurrentPageOffset();
                    if (offset <= resultsCount) {
                        int i = Long.valueOf(offset).intValue();
                        while ((long)i < resultsCount && (long)i < offset + pageSize) {
                            this.pageUsers.add((DocumentModel)users.get(i));
                            ++i;
                        }
                    }
                }
            }
        }
        return this.pageUsers;
    }

    protected String getUserListingMode() {
        Map props = this.getProperties();
        if (props.containsKey(USERS_LISTING_MODE_PROPERTY)) {
            return (String)props.get(USERS_LISTING_MODE_PROPERTY);
        }
        return SEARCH_ONLY_MODE;
    }

    protected String getFirstParameter() {
        String param;
        Object[] parameters = this.getParameters();
        if (parameters.length > 0 && (param = (String)parameters[0]) != null) {
            return param.trim();
        }
        return "";
    }

    protected List<DocumentModel> searchAllUsers(UserManager userManager) throws ClientException {
        return userManager.searchUsers(null);
    }

    protected List<DocumentModel> searchUsers(UserManager userManager) throws ClientException {
        ArrayList<DocumentModel> users = new ArrayList();
        String searchString = this.getFirstParameter();
        if ("*".equals(searchString)) {
            users = this.searchAllUsers(userManager);
        } else if (!StringUtils.isEmpty((String)searchString)) {
            users = userManager.searchUsers(searchString);
        }
        return users;
    }

    protected List<DocumentModel> searchUsersFromCatalog(UserManager userManager) throws ClientException {
        Collection<String> catalogLetters;
        String selectedLetter;
        if (this.userCatalog == null) {
            this.updateUserCatalog(userManager);
        }
        if (!(!StringUtils.isEmpty((String)(selectedLetter = this.getFirstParameter())) && this.userCatalog.containsKey(selectedLetter) || (catalogLetters = this.getCatalogLetters()).isEmpty())) {
            selectedLetter = catalogLetters.iterator().next();
        }
        return (List)this.userCatalog.get(selectedLetter);
    }

    protected void updateUserCatalog(UserManager userManager) throws ClientException {
        DocumentModelList allUsers = userManager.searchUsers(null);
        this.userCatalog = new HashMap<String, DocumentModelList>();
        String userSortField = userManager.getUserSortField();
        for (DocumentModel user : allUsers) {
            String firstLetter;
            DocumentModelList list;
            String displayName = null;
            if (userSortField != null) {
                DataModel dm = (DataModel)user.getDataModels().values().iterator().next();
                displayName = (String)dm.getData(userSortField);
            }
            if (StringUtils.isEmpty(displayName)) {
                displayName = user.getId();
            }
            if ((list = this.userCatalog.get(firstLetter = displayName.substring(0, 1).toUpperCase())) == null) {
                list = new DocumentModelListImpl();
                this.userCatalog.put(firstLetter, list);
            }
            list.add((Object)user);
        }
    }

    public Collection<String> getCatalogLetters() {
        if (this.userCatalog == null) {
            try {
                UserManager userManager = (UserManager)Framework.getLocalService(UserManager.class);
                this.updateUserCatalog(userManager);
            }
            catch (ClientException e) {
                log.error((Object)"Unable to update user catalog", (Throwable)e);
                return Collections.emptyList();
            }
        }
        ArrayList<String> list = new ArrayList<String>(this.userCatalog.keySet());
        Collections.sort(list);
        return list;
    }

    public boolean isSortable() {
        return false;
    }

    protected void pageChanged() {
        this.pageUsers = null;
        super.pageChanged();
    }

    public void refresh() {
        this.pageUsers = null;
        super.refresh();
    }
}

