/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.rendition.extension;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.platform.rendition.RenditionException;
import org.nuxeo.ecm.platform.rendition.extension.RenditionProvider;
import org.nuxeo.ecm.platform.rendition.service.RenditionDefinition;
import org.nuxeo.runtime.api.Framework;

public class DefaultAutomationRenditionProvider
implements RenditionProvider {
    protected static final Log log = LogFactory.getLog(DefaultAutomationRenditionProvider.class);

    public boolean isAvailable(DocumentModel doc, RenditionDefinition def) {
        String chain = def.getOperationChain();
        if (chain == null) {
            log.error((Object)"Can not run Automation rendition if chain is not defined");
            return false;
        }
        AutomationService as = (AutomationService)Framework.getLocalService(AutomationService.class);
        try {
            if (as.getOperationChain(chain) == null) {
                log.error((Object)("Chain " + chain + " is not defined : rendition can not be used"));
                return false;
            }
        }
        catch (Exception e) {
            log.error((Object)"Unable to test Rendition availability", (Throwable)e);
            return false;
        }
        if (!def.isEmptyBlobAllowed()) {
            BlobHolder bh = (BlobHolder)doc.getAdapter(BlobHolder.class);
            if (bh == null) {
                return false;
            }
            try {
                Blob blob = bh.getBlob();
                if (blob == null) {
                    return false;
                }
            }
            catch (Exception e) {
                log.error((Object)"Unable to get Blob to test Rendition availability", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public List<Blob> render(DocumentModel doc, RenditionDefinition definition) throws RenditionException {
        chain = definition.getOperationChain();
        if (chain == null) {
            throw new RenditionException("no operation defined");
        }
        as = (AutomationService)Framework.getLocalService(AutomationService.class);
        oc = new OperationContext();
        oc.push("document", (Object)doc);
        try {
            bh = (BlobHolder)doc.getAdapter(BlobHolder.class);
            if (bh != null) {
                try {
                    blob = bh.getBlob();
                    if (blob == null) ** GOTO lbl20
                    oc.push("blob", (Object)blob);
                }
                catch (Exception e) {
                    if (definition.isEmptyBlobAllowed()) ** GOTO lbl20
                    throw new RenditionException("No Blob available", e);
                }
            } else if (!definition.isEmptyBlobAllowed()) {
                throw new RenditionException("No Blob available");
            }
lbl20:
            // 5 sources

            blob = (Blob)as.run(oc, definition.getOperationChain());
            blobs = new ArrayList<Blob>();
            blobs.add(blob);
            return blobs;
        }
        catch (Exception e) {
            throw new RenditionException("Exception while running the operation chain: " + definition.getOperationChain(), e);
        }
    }
}

