/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import org.apache.pdfbox.Version;
import org.apache.pdfbox.exceptions.CryptographyException;
import org.apache.pdfbox.pdfviewer.PageWrapper;
import org.apache.pdfbox.pdfviewer.ReaderBottomPanel;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageable;
import org.apache.pdfbox.util.ExtensionFileFilter;
import org.apache.pdfbox.util.ImageIOUtil;

public class PDFReader
extends JFrame {
    private File currentDir = new File(".");
    private JMenuItem saveAsImageMenuItem;
    private JMenuItem exitMenuItem;
    private JMenu fileMenu;
    private JMenuBar menuBar;
    private JMenuItem openMenuItem;
    private JMenuItem printMenuItem;
    private JMenu viewMenu;
    private JMenuItem nextPageItem;
    private JMenuItem previousPageItem;
    private JPanel documentPanel = new JPanel();
    private ReaderBottomPanel bottomStatusPanel = new ReaderBottomPanel();
    private PDDocument document = null;
    private List<PDPage> pages = null;
    private int currentPage = 0;
    private int numberOfPages = 0;
    private String currentFilename = null;
    private static final String PASSWORD = "-password";
    private static final String NONSEQ = "-nonSeq";
    private static boolean useNonSeqParser = false;
    private static final String VERSION = Version.getVersion();
    private static final String BASETITLE = "PDFBox " + VERSION;

    public PDFReader() {
        this.initComponents();
    }

    private void initComponents() {
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.openMenuItem = new JMenuItem();
        this.saveAsImageMenuItem = new JMenuItem();
        this.exitMenuItem = new JMenuItem();
        this.printMenuItem = new JMenuItem();
        this.viewMenu = new JMenu();
        this.nextPageItem = new JMenuItem();
        this.previousPageItem = new JMenuItem();
        this.setTitle(BASETITLE);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                PDFReader.this.exitApplication();
            }
        });
        JScrollPane documentScroller = new JScrollPane();
        documentScroller.setViewportView(this.documentPanel);
        this.getContentPane().add((Component)documentScroller, "Center");
        this.getContentPane().add((Component)this.bottomStatusPanel, "South");
        this.fileMenu.setText("File");
        this.openMenuItem.setText("Open");
        this.openMenuItem.setToolTipText("Open PDF file");
        this.openMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PDFReader.this.openMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.openMenuItem);
        this.printMenuItem.setText("Print");
        this.printMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    if (PDFReader.this.document != null) {
                        PDPageable pageable = new PDPageable(PDFReader.this.document);
                        PrinterJob job = pageable.getPrinterJob();
                        job.setPageable(pageable);
                        if (job.printDialog()) {
                            job.print();
                        }
                    }
                }
                catch (PrinterException e) {
                    e.printStackTrace();
                }
            }
        });
        this.fileMenu.add(this.printMenuItem);
        this.saveAsImageMenuItem.setText("Save as image");
        this.saveAsImageMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (PDFReader.this.document != null) {
                    PDFReader.this.saveImage();
                }
            }
        });
        this.fileMenu.add(this.saveAsImageMenuItem);
        this.exitMenuItem.setText("Exit");
        this.exitMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PDFReader.this.exitApplication();
            }
        });
        this.fileMenu.add(this.exitMenuItem);
        this.menuBar.add(this.fileMenu);
        this.viewMenu.setText("View");
        this.nextPageItem.setText("Next page");
        this.nextPageItem.setAccelerator(KeyStroke.getKeyStroke('+'));
        this.nextPageItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PDFReader.this.nextPage();
            }
        });
        this.viewMenu.add(this.nextPageItem);
        this.previousPageItem.setText("Previous page");
        this.previousPageItem.setAccelerator(KeyStroke.getKeyStroke('-'));
        this.previousPageItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PDFReader.this.previousPage();
            }
        });
        this.viewMenu.add(this.previousPageItem);
        this.menuBar.add(this.viewMenu);
        this.setJMenuBar(this.menuBar);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 700) / 2, (screenSize.height - 600) / 2, 700, 600);
    }

    private void updateTitle() {
        this.setTitle(BASETITLE + ": " + this.currentFilename + " (" + (this.currentPage + 1) + "/" + this.numberOfPages + ")");
    }

    private void nextPage() {
        if (this.currentPage < this.numberOfPages - 1) {
            ++this.currentPage;
            this.updateTitle();
            this.showPage(this.currentPage);
        }
    }

    private void previousPage() {
        if (this.currentPage > 0) {
            --this.currentPage;
            this.updateTitle();
            this.showPage(this.currentPage);
        }
    }

    private void openMenuItemActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.setCurrentDirectory(this.currentDir);
        ExtensionFileFilter pdfFilter = new ExtensionFileFilter(new String[]{"PDF"}, "PDF Files");
        chooser.setFileFilter(pdfFilter);
        int result = chooser.showOpenDialog(this);
        if (result == 0) {
            String name = chooser.getSelectedFile().getPath();
            this.currentDir = new File(name).getParentFile();
            try {
                this.openPDFFile(name, "");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void exitApplication() {
        try {
            if (this.document != null) {
                this.document.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) throws Exception {
        PDFReader viewer = new PDFReader();
        String password = "";
        String filename = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals(PASSWORD)) {
                if (++i >= args.length) {
                    PDFReader.usage();
                }
                password = args[i];
            }
            if (args[i].equals(NONSEQ)) {
                useNonSeqParser = true;
                continue;
            }
            filename = args[i];
        }
        if (filename != null) {
            viewer.openPDFFile(filename, password);
        }
        viewer.setVisible(true);
    }

    private void openPDFFile(String filename, String password) throws Exception {
        if (this.document != null) {
            this.document.close();
            this.documentPanel.removeAll();
        }
        File file = new File(filename);
        this.parseDocument(file, password);
        this.pages = this.document.getDocumentCatalog().getAllPages();
        this.numberOfPages = this.pages.size();
        this.currentFilename = file.getAbsolutePath();
        this.currentPage = 0;
        this.updateTitle();
        this.showPage(0);
    }

    private void showPage(int pageNumber) {
        try {
            PageWrapper wrapper = new PageWrapper(this);
            wrapper.displayPage(this.pages.get(pageNumber));
            if (this.documentPanel.getComponentCount() > 0) {
                this.documentPanel.remove(0);
            }
            this.documentPanel.add(wrapper.getPanel());
            this.pack();
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }

    private void saveImage() {
        try {
            PDPage pageToSave = this.pages.get(this.currentPage);
            BufferedImage pageAsImage = pageToSave.convertToImage();
            String imageFilename = this.currentFilename;
            if (imageFilename.toLowerCase().endsWith(".pdf")) {
                imageFilename = imageFilename.substring(0, imageFilename.length() - 4);
            }
            imageFilename = imageFilename + "_" + (this.currentPage + 1) + ".png";
            ImageIOUtil.writeImage(pageAsImage, imageFilename, 300);
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }

    private void parseDocument(File file, String password) throws IOException {
        this.document = null;
        this.document = useNonSeqParser ? PDDocument.loadNonSeq(file, null, password) : PDDocument.load(file);
        if (this.document.isEncrypted()) {
            try {
                this.document.decrypt(password);
            }
            catch (CryptographyException e) {
                e.printStackTrace();
            }
        }
    }

    public ReaderBottomPanel getBottomStatusPanel() {
        return this.bottomStatusPanel;
    }

    private static void usage() {
        System.err.println("usage: java -jar pdfbox-app-" + VERSION + ".jar PDFReader [OPTIONS] <input-file>\n" + "  -password <password>      Password to decrypt the document\n" + "  -nonSeq                   Enables the new non-sequential parser\n" + "  <input-file>              The PDF document to be loaded\n");
    }
}

