/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.contentview.jsf;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.nuxeo.ecm.platform.contentview.jsf.ContentView;
import org.nuxeo.ecm.platform.ui.web.cache.LRUCachingMap;

public class ContentViewCache
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final Integer DEFAULT_CACHE_SIZE = new Integer(5);
    protected final Map<String, String> namedCacheKeys = new HashMap<String, String>();
    protected final Map<String, ContentView> namedContentViews = new HashMap<String, ContentView>();
    protected final Map<String, Map<String, ContentView>> cacheInstances = new HashMap<String, Map<String, ContentView>>();
    protected final Map<String, Set<String>> refreshEventToContentViewName = new HashMap<String, Set<String>>();
    protected final Map<String, Set<String>> resetEventToContentViewName = new HashMap<String, Set<String>>();

    public void add(ContentView cView) {
        if (cView != null) {
            HashSet<String> set;
            LRUCachingMap cacheEntry;
            String cacheKey = cView.getCacheKey();
            if (cacheKey == null) {
                return;
            }
            String name = cView.getName();
            Integer cacheSize = cView.getCacheSize();
            if (cacheSize == null) {
                cacheSize = DEFAULT_CACHE_SIZE;
            }
            if (cacheSize <= 0) {
                cacheSize = 1;
            }
            if ((cacheEntry = this.cacheInstances.get(name)) == null) {
                cacheEntry = new LRUCachingMap(cacheSize.intValue());
            }
            cacheEntry.put((String)cacheKey, (ContentView)cView);
            this.cacheInstances.put(name, (Map<String, ContentView>)cacheEntry);
            this.namedCacheKeys.put(name, cacheKey);
            this.namedContentViews.put(name, cView);
            List<String> events = cView.getRefreshEventNames();
            if (events != null && !events.isEmpty()) {
                for (String event : events) {
                    if (this.refreshEventToContentViewName.containsKey(event)) {
                        this.refreshEventToContentViewName.get(event).add(name);
                        continue;
                    }
                    set = new HashSet<String>();
                    set.add(name);
                    this.refreshEventToContentViewName.put(event, set);
                }
            }
            if ((events = cView.getResetEventNames()) != null && !events.isEmpty()) {
                for (String event : events) {
                    if (this.resetEventToContentViewName.containsKey(event)) {
                        this.resetEventToContentViewName.get(event).add(name);
                        continue;
                    }
                    set = new HashSet();
                    set.add(name);
                    this.resetEventToContentViewName.put(event, set);
                }
            }
        }
    }

    public ContentView get(String name) {
        ContentView cView = this.namedContentViews.get(name);
        if (cView != null) {
            String oldCacheKey = this.namedCacheKeys.get(name);
            String newCacheKey = cView.getCacheKey();
            if (newCacheKey != null && !newCacheKey.equals(oldCacheKey)) {
                Map<String, ContentView> contentViews = this.cacheInstances.get(name);
                if (contentViews.containsKey(newCacheKey)) {
                    cView = contentViews.get(newCacheKey);
                    this.namedCacheKeys.put(name, newCacheKey);
                    this.namedContentViews.put(name, cView);
                } else {
                    return null;
                }
            }
        }
        return cView;
    }

    public void refresh(String contentViewName, boolean rewind) {
        Map<String, ContentView> instances;
        ContentView cv = this.namedContentViews.get(contentViewName);
        if (cv != null) {
            if (rewind) {
                cv.refreshAndRewindPageProvider();
            } else {
                cv.refreshPageProvider();
            }
        }
        if ((instances = this.cacheInstances.get(contentViewName)) != null) {
            for (ContentView cView : instances.values()) {
                if (cView == null || cView.equals(cv)) continue;
                if (rewind) {
                    cView.refreshAndRewindPageProvider();
                    continue;
                }
                cView.refreshPageProvider();
            }
        }
    }

    public void resetPageProvider(String contentViewName) {
        Map<String, ContentView> instances;
        ContentView cv = this.namedContentViews.get(contentViewName);
        if (cv != null) {
            cv.resetPageProvider();
        }
        if ((instances = this.cacheInstances.get(contentViewName)) != null) {
            for (ContentView cView : instances.values()) {
                if (cView == null) continue;
                cView.resetPageProvider();
            }
        }
    }

    public void resetPageProviderAggregates(String contentViewName) {
        Map<String, ContentView> instances;
        ContentView cv = this.namedContentViews.get(contentViewName);
        if (cv != null) {
            cv.resetPageProviderAggregates();
        }
        if ((instances = this.cacheInstances.get(contentViewName)) != null) {
            for (ContentView cView : instances.values()) {
                if (cView == null) continue;
                cView.resetPageProviderAggregates();
            }
        }
    }

    public void refreshOnEvent(String eventName) {
        Set<String> contentViewNames;
        if (eventName != null && (contentViewNames = this.refreshEventToContentViewName.get(eventName)) != null) {
            for (String contentViewName : contentViewNames) {
                this.refresh(contentViewName, false);
            }
        }
    }

    public void resetPageProviderOnEvent(String eventName) {
        Set<String> contentViewNames;
        if (eventName != null && (contentViewNames = this.resetEventToContentViewName.get(eventName)) != null) {
            for (String contentViewName : contentViewNames) {
                this.resetPageProvider(contentViewName);
            }
        }
    }

    public void reset(String contentViewName) {
        this.namedContentViews.remove(contentViewName);
        this.namedCacheKeys.remove(contentViewName);
        this.cacheInstances.remove(contentViewName);
    }

    public void resetAllContent() {
        this.namedContentViews.clear();
        this.namedCacheKeys.clear();
        this.cacheInstances.clear();
    }

    public void resetAll() {
        this.resetAllContent();
        this.refreshEventToContentViewName.clear();
        this.resetEventToContentViewName.clear();
    }

    public void refreshAll() {
        this.refreshAll(false);
    }

    public void refreshAndRewindAll() {
        this.refreshAll(true);
    }

    protected void refreshAll(boolean rewind) {
        Set<String> cvNames = this.namedContentViews.keySet();
        for (String cvName : cvNames) {
            this.refresh(cvName, rewind);
        }
    }
}

