/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html.images;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.faces.context.FacesContext;
import org.richfaces.resource.AbstractJava2DUserResource;
import org.richfaces.resource.DynamicUserResource;
import org.richfaces.resource.PostConstructResource;
import org.richfaces.resource.ResourceParameter;
import org.richfaces.resource.StateHolderResource;
import org.richfaces.skin.Skin;
import org.richfaces.skin.SkinFactory;

@DynamicUserResource
public class AutocompleteGradient
extends AbstractJava2DUserResource
implements StateHolderResource {
    private static final Dimension DIMENSION = new Dimension(18, 8);
    private String topColorParam;
    private String bottomColorParam;
    private Integer topColor;
    private Integer bottomColor;

    public AutocompleteGradient() {
        super(DIMENSION);
    }

    @PostConstructResource
    public void initialize() {
        FacesContext context = FacesContext.getCurrentInstance();
        Skin skin = SkinFactory.getInstance((FacesContext)context).getSkin(context);
        this.topColor = skin.getColorParameter(context, this.topColorParam);
        this.bottomColor = skin.getColorParameter(context, this.bottomColorParam);
    }

    public void paint(Graphics2D graphics2d) {
        if (this.topColor == null || this.bottomColor == null) {
            return;
        }
        Dimension dimension = this.getDimension();
        GradientPaint paint = new GradientPaint(0.0f, 0.0f, new Color(this.topColor), 0.0f, dimension.height, new Color(this.bottomColor));
        graphics2d.setPaint(paint);
        graphics2d.fill(new Rectangle(dimension));
    }

    public void writeState(FacesContext context, DataOutput dataOutput) throws IOException {
        if (this.topColor != null && this.bottomColor != null) {
            dataOutput.writeBoolean(true);
            dataOutput.writeInt(this.topColor);
            dataOutput.writeInt(this.bottomColor);
        } else {
            dataOutput.writeBoolean(false);
        }
    }

    public void readState(FacesContext context, DataInput dataInput) throws IOException {
        if (dataInput.readBoolean()) {
            this.topColor = dataInput.readInt();
            this.bottomColor = dataInput.readInt();
        } else {
            this.topColor = null;
            this.bottomColor = null;
        }
    }

    public boolean isTransient() {
        return false;
    }

    @ResourceParameter(defaultValue="headerGradientColor")
    public void setTopColorParam(String topColorSkinParameter) {
        this.topColorParam = topColorSkinParameter;
    }

    @ResourceParameter(defaultValue="headerBackgroundColor")
    public void setBottomColorParam(String bottomColorSkinParameter) {
        this.bottomColorParam = bottomColorSkinParameter;
    }
}

