/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.collections.ScopeType;
import org.nuxeo.common.collections.ScopedMap;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DataModel;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.impl.DataModelImpl;
import org.nuxeo.ecm.core.api.impl.DocumentModelImpl;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.core.api.local.ClientLoginModule;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.PermissionDescriptor;
import org.nuxeo.ecm.directory.Session;

public abstract class BaseSession
implements Session {
    protected static final String POWER_USERS_GROUP = "powerusers";
    protected static final String READONLY_ENTRY_FLAG = "READONLY_ENTRY";
    protected static final String MULTI_TENANT_ID_FORMAT = "tenant_%s_%s";
    private static final Log log = LogFactory.getLog(BaseSession.class);
    protected PermissionDescriptor[] permissions = null;

    public boolean isCurrentUserAllowed(String permissionTocheck) {
        PermissionDescriptor[] permDescriptors = this.permissions;
        NuxeoPrincipal currentUser = ClientLoginModule.getCurrentPrincipal();
        if (currentUser == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Can't get current user to check directory permission. EVERYTHING is allowed by default");
            }
            return true;
        }
        String username = currentUser.getName();
        List userGroups = currentUser.getAllGroups();
        if (username.equalsIgnoreCase("system")) {
            return true;
        }
        if (permDescriptors == null || permDescriptors.length == 0) {
            if (currentUser.isAdministrator()) {
                return true;
            }
            if (currentUser.isMemberOf(POWER_USERS_GROUP)) {
                return true;
            }
            if (permissionTocheck.equalsIgnoreCase("Read")) {
                return true;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("User '%s', is not allowed for permission '%s' on the directory", currentUser, permissionTocheck));
            }
            return false;
        }
        boolean allowed = this.checkPermission(permDescriptors, permissionTocheck, username, userGroups);
        if (!allowed && permissionTocheck.equalsIgnoreCase("Read")) {
            allowed = this.checkPermission(permDescriptors, "Write", username, userGroups);
        }
        if (log.isDebugEnabled() && !allowed) {
            log.debug((Object)String.format("User '%s', is not allowed for permission '%s' on the directory", currentUser, permissionTocheck));
        }
        return allowed;
    }

    private boolean checkPermission(PermissionDescriptor[] permDescriptors, String permToChek, String username, List<String> userGroups) {
        for (int i = 0; i < permDescriptors.length; ++i) {
            int j;
            PermissionDescriptor currentDesc = permDescriptors[i];
            if (!currentDesc.name.equalsIgnoreCase(permToChek)) continue;
            if (currentDesc.groups != null) {
                for (j = 0; j < currentDesc.groups.length; ++j) {
                    String groupName = currentDesc.groups[j];
                    userGroups.add("Everyone");
                    if (!userGroups.contains(groupName)) continue;
                    return true;
                }
            }
            if (currentDesc.users == null) continue;
            for (j = 0; j < currentDesc.users.length; ++j) {
                String currentUsername = currentDesc.users[j];
                if (!currentUsername.equals(username)) continue;
                return true;
            }
        }
        return false;
    }

    public static DocumentModel createEntryModel(String sessionId, String schema, String id, Map<String, Object> values) throws PropertyException {
        DocumentModelImpl entry = new DocumentModelImpl(sessionId, schema, id, null, null, null, null, new String[]{schema}, new HashSet(), null, null);
        if (values == null) {
            values = Collections.emptyMap();
        }
        DataModelImpl dataModel = new DataModelImpl(schema, values);
        entry.addDataModel((DataModel)dataModel);
        return entry;
    }

    public static DocumentModel createEntryModel(String sessionId, String schema, String id, Map<String, Object> values, boolean readOnly) throws PropertyException {
        DocumentModel entry = BaseSession.createEntryModel(sessionId, schema, id, values);
        if (readOnly) {
            BaseSession.setReadOnlyEntry(entry);
        }
        return entry;
    }

    protected static Map<String, Serializable> mkSerializableMap(Map<String, Object> map) {
        HashMap<String, Serializable> serializableMap = null;
        if (map != null) {
            serializableMap = new HashMap<String, Serializable>();
            for (String key : map.keySet()) {
                serializableMap.put(key, (Serializable)map.get(key));
            }
        }
        return serializableMap;
    }

    protected static Map<String, Object> mkObjectMap(Map<String, Serializable> map) {
        HashMap<String, Serializable> objectMap = null;
        if (map != null) {
            objectMap = new HashMap<String, Serializable>();
            for (String key : map.keySet()) {
                objectMap.put(key, map.get(key));
            }
        }
        return objectMap;
    }

    public static boolean isReadOnlyEntry(DocumentModel entry) {
        ScopedMap contextData = entry.getContextData();
        return contextData.getScopedValue(ScopeType.REQUEST, READONLY_ENTRY_FLAG) == Boolean.TRUE;
    }

    public static void setReadOnlyEntry(DocumentModel entry) {
        ScopedMap contextData = entry.getContextData();
        contextData.putScopedValue(ScopeType.REQUEST, READONLY_ENTRY_FLAG, (Serializable)Boolean.TRUE);
    }

    public static void setReadWriteEntry(DocumentModel entry) {
        ScopedMap contextData = entry.getContextData();
        contextData.putScopedValue(ScopeType.REQUEST, READONLY_ENTRY_FLAG, (Serializable)Boolean.FALSE);
    }

    public static String computeMultiTenantDirectoryId(String tenantId, String id) {
        return String.format(MULTI_TENANT_ID_FORMAT, tenantId, id);
    }

    @Override
    public DocumentModelList query(Map<String, Serializable> filter, Set<String> fulltext, Map<String, String> orderBy, boolean fetchReferences, int limit, int offset) throws ClientException, DirectoryException {
        log.info((Object)"Call an unoverrided query with offset and limit.");
        DocumentModelList entries = this.query(filter, fulltext, orderBy, fetchReferences);
        int toIndex = offset + limit;
        if (toIndex > entries.size()) {
            toIndex = entries.size();
        }
        return new DocumentModelListImpl(entries.subList(offset, toIndex));
    }
}

