/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.application.push.impl;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.richfaces.application.push.Topic;
import org.richfaces.application.push.TopicKey;
import org.richfaces.application.push.TopicsContext;
import org.richfaces.application.push.impl.TopicImpl;

public class TopicsContextImpl
extends TopicsContext {
    private final ExecutorService publishService;
    private final ThreadFactory threadFactory;

    public TopicsContextImpl(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
        this.publishService = Executors.newCachedThreadPool(threadFactory);
    }

    @Override
    protected Topic createTopic(TopicKey key) {
        return new TopicImpl(key, this);
    }

    protected ExecutorService getPublisherService() {
        return this.publishService;
    }

    protected ThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    public void destroy() {
        this.publishService.shutdown();
    }
}

