/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl.parser;

import org.apache.commons.jexl.JexlContext;
import org.apache.commons.jexl.parser.Parser;
import org.apache.commons.jexl.parser.ParserVisitor;
import org.apache.commons.jexl.parser.SimpleNode;
import org.apache.commons.jexl.util.Coercion;

public class ASTNENode
extends SimpleNode {
    public ASTNENode(int id) {
        super(id);
    }

    public ASTNENode(Parser p, int id) {
        super(p, id);
    }

    public Object jjtAccept(ParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public Object value(JexlContext pc) throws Exception {
        Object left = ((SimpleNode)this.jjtGetChild(0)).value(pc);
        Object right = ((SimpleNode)this.jjtGetChild(1)).value(pc);
        if (left == null && right == null) {
            return Boolean.FALSE;
        }
        if (left == null || right == null) {
            return Boolean.TRUE;
        }
        if (left.getClass().equals(right.getClass())) {
            return left.equals(right) ? Boolean.FALSE : Boolean.TRUE;
        }
        if (left instanceof Float || left instanceof Double || right instanceof Float || right instanceof Double) {
            return Coercion.coerceDouble(left).equals(Coercion.coerceDouble(right)) ? Boolean.FALSE : Boolean.TRUE;
        }
        if (left instanceof Number || right instanceof Number || left instanceof Character || right instanceof Character) {
            return Coercion.coerceLong(left).equals(Coercion.coerceLong(right)) ? Boolean.FALSE : Boolean.TRUE;
        }
        if (left instanceof Boolean || right instanceof Boolean) {
            return Coercion.coerceBoolean(left).equals(Coercion.coerceBoolean(right)) ? Boolean.FALSE : Boolean.TRUE;
        }
        if (left instanceof String || right instanceof String) {
            return left.toString().equals(right.toString()) ? Boolean.FALSE : Boolean.TRUE;
        }
        return left.equals(right) ? Boolean.FALSE : Boolean.TRUE;
    }
}

